/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.parser.jackson;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.util.JsonParserDelegate;
import com.worldturner.medeia.parser.JsonParserAdapter;
import com.worldturner.medeia.parser.JsonTokenData;
import com.worldturner.medeia.parser.JsonTokenDataAndLocationConsumer;
import com.worldturner.medeia.parser.JsonTokenDataKt;
import com.worldturner.medeia.parser.JsonTokenLocation;
import com.worldturner.medeia.parser.JsonTokenType;
import com.worldturner.medeia.parser.jackson.JacksonTokenDataJsonParser$WhenMappings;
import com.worldturner.medeia.pointer.JsonPointer;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0018B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00100\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/worldturner/medeia/parser/jackson/JacksonTokenDataJsonParser;", "Lcom/fasterxml/jackson/core/util/JsonParserDelegate;", "Lcom/worldturner/medeia/parser/JsonParserAdapter;", "jsonParser", "Lcom/fasterxml/jackson/core/JsonParser;", "consumer", "Lcom/worldturner/medeia/parser/JsonTokenDataAndLocationConsumer;", "inputSourceName", "", "(Lcom/fasterxml/jackson/core/JsonParser;Lcom/worldturner/medeia/parser/JsonTokenDataAndLocationConsumer;Ljava/lang/String;)V", "dynamicTokenLocation", "Lcom/worldturner/medeia/parser/jackson/JacksonTokenDataJsonParser$DynamicJsonTokenLocation;", "level", "", "propertyNamesStack", "Ljava/util/ArrayDeque;", "", "buildJsonTokenData", "Lcom/worldturner/medeia/parser/JsonTokenData;", "jacksonType", "Lcom/fasterxml/jackson/core/JsonToken;", "nextToken", "parseAll", "", "DynamicJsonTokenLocation", "medeia-validator-jackson"})
public final class JacksonTokenDataJsonParser
extends JsonParserDelegate
implements JsonParserAdapter {
    private int level;
    private final DynamicJsonTokenLocation dynamicTokenLocation;
    private final ArrayDeque<Set<String>> propertyNamesStack;
    private final JsonTokenDataAndLocationConsumer consumer;
    private final String inputSourceName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public JsonToken nextToken() {
        JsonToken jacksonType = super.nextToken();
        JsonTokenData token = this.buildJsonTokenData(jacksonType);
        JsonTokenType type = token.getType();
        if (!type.getSyntheticType()) {
            int n;
            if (type.getLastStructureToken()) {
                n = this.level;
                this.level = n + -1;
            }
            try {
                this.consumer.consume(token, (JsonTokenLocation)this.dynamicTokenLocation);
            }
            finally {
                if (type.getFirstStructureToken()) {
                    n = this.level;
                    this.level = n + 1;
                }
            }
        }
        JsonToken jsonToken = jacksonType;
        if (jsonToken != null) {
            switch (JacksonTokenDataJsonParser$WhenMappings.$EnumSwitchMapping$0[jsonToken.ordinal()]) {
                case 1: {
                    this.propertyNamesStack.addFirst(new HashSet());
                    break;
                }
                case 2: {
                    this.propertyNamesStack.removeFirst();
                    break;
                }
                case 3: {
                    Collection collection = this.propertyNamesStack.peek();
                    String string = this.getCurrentName();
                    collection.add(string);
                }
            }
        }
        return jacksonType;
    }

    private final JsonTokenData buildJsonTokenData(JsonToken jacksonType) {
        JsonTokenData jsonTokenData;
        JsonToken jsonToken = jacksonType;
        if (jsonToken == null) {
            jsonTokenData = JsonTokenDataKt.getTOKEN_END_OF_STREAM();
        } else {
            block0 : switch (JacksonTokenDataJsonParser$WhenMappings.$EnumSwitchMapping$2[jsonToken.ordinal()]) {
                case 1: 
                case 2: {
                    JsonParser.NumberType numberType;
                    JsonParser.NumberType numberType2 = numberType = this.getNumberType();
                    if (numberType2 != null) {
                        switch (JacksonTokenDataJsonParser$WhenMappings.$EnumSwitchMapping$1[numberType2.ordinal()]) {
                            case 1: 
                            case 2: {
                                jsonTokenData = JsonTokenData.Companion.createNumber(this.getLongValue());
                                break block0;
                            }
                            case 3: {
                                jsonTokenData = new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, this.getBigIntegerValue(), null, 22, null);
                                break block0;
                            }
                        }
                    }
                    jsonTokenData = new JsonTokenData(JsonTokenType.VALUE_NUMBER, null, 0L, null, this.getDecimalValue(), 14, null);
                    break;
                }
                case 3: {
                    jsonTokenData = new JsonTokenData(JsonTokenType.FIELD_NAME, this.getCurrentName(), 0L, null, null, 28, null);
                    break;
                }
                case 4: {
                    String string = this.getText();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text");
                    jsonTokenData = JsonTokenData.Companion.createText(string);
                    break;
                }
                case 5: {
                    jsonTokenData = JsonTokenDataKt.getTOKEN_TRUE();
                    break;
                }
                case 6: {
                    jsonTokenData = JsonTokenDataKt.getTOKEN_FALSE();
                    break;
                }
                case 7: {
                    jsonTokenData = JsonTokenDataKt.getTOKEN_START_OBJECT();
                    break;
                }
                case 8: {
                    jsonTokenData = JsonTokenDataKt.getTOKEN_END_OBJECT();
                    break;
                }
                case 9: {
                    jsonTokenData = JsonTokenDataKt.getTOKEN_START_ARRAY();
                    break;
                }
                case 10: {
                    jsonTokenData = JsonTokenDataKt.getTOKEN_END_ARRAY();
                    break;
                }
                case 11: {
                    jsonTokenData = JsonTokenDataKt.getTOKEN_NULL();
                    break;
                }
                default: {
                    jsonTokenData = JsonTokenDataKt.getTOKEN_NONE();
                }
            }
        }
        return jsonTokenData;
    }

    public void parseAll() {
        while (this.nextToken() != null) {
        }
    }

    public JacksonTokenDataJsonParser(@NotNull JsonParser jsonParser, @NotNull JsonTokenDataAndLocationConsumer consumer, @Nullable String inputSourceName) {
        Intrinsics.checkParameterIsNotNull((Object)jsonParser, (String)"jsonParser");
        Intrinsics.checkParameterIsNotNull((Object)consumer, (String)"consumer");
        super(jsonParser);
        this.consumer = consumer;
        this.inputSourceName = inputSourceName;
        this.dynamicTokenLocation = new DynamicJsonTokenLocation();
        this.propertyNamesStack = new ArrayDeque();
    }

    public static final /* synthetic */ void access$setLevel$p(JacksonTokenDataJsonParser $this, int n) {
        $this.level = n;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0017\u001a\u00020\bH\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0006R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0018"}, d2={"Lcom/worldturner/medeia/parser/jackson/JacksonTokenDataJsonParser$DynamicJsonTokenLocation;", "Lcom/worldturner/medeia/parser/JsonTokenLocation;", "(Lcom/worldturner/medeia/parser/jackson/JacksonTokenDataJsonParser;)V", "column", "", "getColumn", "()I", "inputSourceName", "", "getInputSourceName", "()Ljava/lang/String;", "level", "getLevel", "line", "getLine", "pointer", "Lcom/worldturner/medeia/pointer/JsonPointer;", "getPointer", "()Lcom/worldturner/medeia/pointer/JsonPointer;", "propertyNames", "", "getPropertyNames", "()Ljava/util/Set;", "toString", "medeia-validator-jackson"})
    public final class DynamicJsonTokenLocation
    implements JsonTokenLocation {
        @NotNull
        public JsonPointer getPointer() {
            String string = JacksonTokenDataJsonParser.this.getParsingContext().pathAsPointer().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parsingContext.pathAsPointer().toString()");
            return new JsonPointer(string, true);
        }

        public int getLevel() {
            return JacksonTokenDataJsonParser.this.level;
        }

        public int getLine() {
            JsonLocation jsonLocation = JacksonTokenDataJsonParser.this.getCurrentLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonLocation, (String)"currentLocation");
            return jsonLocation.getLineNr();
        }

        public int getColumn() {
            JsonLocation jsonLocation = JacksonTokenDataJsonParser.this.getCurrentLocation();
            Intrinsics.checkExpressionValueIsNotNull((Object)jsonLocation, (String)"currentLocation");
            return jsonLocation.getColumnNr();
        }

        @NotNull
        public Set<String> getPropertyNames() {
            Set set = (Set)JacksonTokenDataJsonParser.this.propertyNamesStack.peek();
            if (set == null) {
                set = SetsKt.emptySet();
            }
            return set;
        }

        @Nullable
        public String getInputSourceName() {
            return JacksonTokenDataJsonParser.this.inputSourceName;
        }

        @NotNull
        public String toString() {
            String string;
            block3: {
                block2: {
                    String string2;
                    string = this.getInputSourceName();
                    if (string == null) break block2;
                    String it = string2 = string;
                    boolean bl = false;
                    string = "at " + this.getLine() + ':' + this.getColumn() + " in " + this.getInputSourceName();
                    if (string != null) break block3;
                }
                string = "at " + this.getLine() + ':' + this.getColumn();
            }
            return string;
        }
    }
}

