/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.config.MapConfig;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.record.ObjectRecord;
import com.hazelcast.map.impl.record.ObjectRecordWithStats;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.RecordFactory;

public class ObjectRecordFactory
implements RecordFactory<Object> {
    private final boolean statisticsEnabled;
    private final SerializationService serializationService;

    public ObjectRecordFactory(MapConfig config, SerializationService serializationService) {
        this.serializationService = serializationService;
        this.statisticsEnabled = config.isStatisticsEnabled();
    }

    @Override
    public Record<Object> newRecord(Object value) {
        Object objectValue = this.serializationService.toObject(value);
        return this.statisticsEnabled ? new ObjectRecordWithStats(objectValue) : new ObjectRecord(objectValue);
    }
}

