/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;

public final class LatencyDistribution {
    public static final int BUCKET_COUNT = 32;
    @SuppressFBWarnings(value={"MS_MUTABLE_ARRAY"})
    public static final String[] LATENCY_KEYS = new String[32];
    private static final AtomicLongFieldUpdater<LatencyDistribution> COUNT;
    private static final AtomicLongFieldUpdater<LatencyDistribution> TOTAL_MICROS;
    private static final AtomicLongFieldUpdater<LatencyDistribution> MAX_MICROS;
    private final AtomicLongArray buckets = new AtomicLongArray(32);
    private volatile long count;
    private volatile long maxMicros;
    private volatile long totalMicros;

    public int bucketCount() {
        return 32;
    }

    public long bucket(int bucket) {
        return this.buckets.get(bucket);
    }

    public static long bucketMaxUs(int bucket) {
        return bucket == 0 ? 0L : (1L << bucket) - 1L;
    }

    public static long bucketMinUs(int bucket) {
        return bucket == 0 ? 0L : LatencyDistribution.bucketMaxUs(bucket - 1) + 1L;
    }

    public long count() {
        return this.count;
    }

    public long maxMicros() {
        return this.maxMicros;
    }

    public long totalMicros() {
        return this.totalMicros;
    }

    public long avgMicros() {
        return this.count == 0L ? 0L : this.totalMicros / this.count;
    }

    public void done(long startNanos) {
        this.recordNanos(System.nanoTime() - startNanos);
    }

    public void recordNanos(long durationNanos) {
        long currentMax;
        long d;
        if (durationNanos < 0L) {
            durationNanos = 0L;
        }
        int durationMicros = (d = TimeUnit.NANOSECONDS.toMicros(durationNanos)) > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)d;
        COUNT.addAndGet(this, 1L);
        TOTAL_MICROS.addAndGet(this, durationMicros);
        while ((long)durationMicros > (currentMax = this.maxMicros) && !MAX_MICROS.compareAndSet(this, currentMax, durationMicros)) {
        }
        try {
            this.buckets.incrementAndGet(LatencyDistribution.usToBucketIndex(durationMicros));
        }
        catch (RuntimeException e) {
            throw new RuntimeException("duration nanos:" + durationNanos, e);
        }
    }

    public static int usToBucketIndex(int us) {
        int prevPow;
        if (us < 2) {
            return 0;
        }
        int nextPow = 32 - Integer.numberOfLeadingZeros(us);
        int middle = (1 << nextPow) - (1 << (prevPow = nextPow - 1) - 1);
        return us < middle ? prevPow : nextPow;
    }

    static {
        for (int k = 0; k < 32; ++k) {
            LatencyDistribution.LATENCY_KEYS[k] = LatencyDistribution.bucketMinUs(k) + ".." + LatencyDistribution.bucketMaxUs(k) + "us";
        }
        COUNT = AtomicLongFieldUpdater.newUpdater(LatencyDistribution.class, "count");
        TOTAL_MICROS = AtomicLongFieldUpdater.newUpdater(LatencyDistribution.class, "totalMicros");
        MAX_MICROS = AtomicLongFieldUpdater.newUpdater(LatencyDistribution.class, "maxMicros");
    }
}

