/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.expression.string;

import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.expression.ExpressionEvalContext;
import com.hazelcast.sql.impl.expression.TriExpression;
import com.hazelcast.sql.impl.expression.string.StringFunctionUtils;
import com.hazelcast.sql.impl.row.Row;
import com.hazelcast.sql.impl.type.QueryDataType;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LikeFunction
extends TriExpression<Boolean>
implements IdentifiedDataSerializable {
    private static final long serialVersionUID = 4157617157954663651L;
    private static final char ONE_SQL = '_';
    private static final char MANY_SQL = '%';
    private static final String ONE_JAVA = ".";
    private static final String MANY_JAVA = ".*";
    private static final String ESCAPE_CHARACTERS_JAVA = "[]()|^+*?{}$\\.";
    private transient State state;

    public LikeFunction() {
    }

    private LikeFunction(Expression<?> source, Expression<?> pattern, Expression<?> escape) {
        super(source, pattern, escape);
    }

    public static LikeFunction create(Expression<?> source, Expression<?> pattern, Expression<?> escape) {
        return new LikeFunction(source, pattern, escape);
    }

    @Override
    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="SQL has three-valued boolean logic")
    public Boolean eval(Row row, ExpressionEvalContext context) {
        String escape;
        String source = StringFunctionUtils.asVarchar(this.operand1, row, context);
        if (source == null) {
            return null;
        }
        String pattern = StringFunctionUtils.asVarchar(this.operand2, row, context);
        if (pattern == null) {
            return null;
        }
        if (this.operand3 != null) {
            escape = StringFunctionUtils.asVarchar(this.operand3, row, context);
            if (escape == null) {
                return null;
            }
        } else {
            escape = null;
        }
        if (this.state == null) {
            this.state = new State();
        }
        return this.state.like(source, pattern, escape);
    }

    @Override
    public QueryDataType getType() {
        return QueryDataType.BOOLEAN;
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 59;
    }

    public static class State {
        private String lastPattern;
        private String lastEscape;
        private Pattern lastJavaPattern;

        public boolean like(String source, String pattern, String escape) {
            Pattern javaPattern = this.convertToJavaPattern(pattern, escape);
            Matcher matcher = javaPattern.matcher(source);
            return matcher.matches();
        }

        private Pattern convertToJavaPattern(String pattern, String escape) {
            if (Objects.equals(pattern, this.lastPattern) && Objects.equals(escape, this.lastEscape)) {
                return this.lastJavaPattern;
            }
            String javaPatternStr = State.constructJavaPatternString(pattern, escape);
            Pattern javaPattern = Pattern.compile(javaPatternStr, 32);
            this.lastPattern = pattern;
            this.lastEscape = escape;
            this.lastJavaPattern = javaPattern;
            return javaPattern;
        }

        private static String constructJavaPatternString(String pattern, String escape) {
            Character escapeChar;
            if (escape != null) {
                if (escape.length() != 1) {
                    throw QueryException.error("ESCAPE parameter must be a single character");
                }
                escapeChar = Character.valueOf(escape.charAt(0));
            } else {
                escapeChar = null;
            }
            StringBuilder javaPattern = new StringBuilder();
            for (int i = 0; i < pattern.length(); ++i) {
                char patternChar = pattern.charAt(i);
                if (LikeFunction.ESCAPE_CHARACTERS_JAVA.indexOf(patternChar) >= 0) {
                    javaPattern.append('\\');
                }
                if (escapeChar != null && patternChar == escapeChar.charValue()) {
                    if (i == pattern.length() - 1) {
                        throw State.escapeWildcardsOnly();
                    }
                    char nextPatternChar = pattern.charAt(i + 1);
                    if (nextPatternChar == '_' || nextPatternChar == '%' || nextPatternChar == escapeChar.charValue()) {
                        javaPattern.append(nextPatternChar);
                        ++i;
                        continue;
                    }
                    throw State.escapeWildcardsOnly();
                }
                if (patternChar == '_') {
                    javaPattern.append(LikeFunction.ONE_JAVA);
                    continue;
                }
                if (patternChar == '%') {
                    javaPattern.append(LikeFunction.MANY_JAVA);
                    continue;
                }
                javaPattern.append(patternChar);
            }
            return javaPattern.toString();
        }

        private static QueryException escapeWildcardsOnly() {
            return QueryException.error("Only '_', '%' and the escape character can be escaped");
        }
    }
}

