/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.set;

import com.hazelcast.collection.ISet;
import com.hazelcast.collection.ItemListener;
import com.hazelcast.core.HazelcastInstance;
import java.util.UUID;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.component.hazelcast.HazelcastDefaultConsumer;
import org.apache.camel.component.hazelcast.listener.CamelItemListener;

public class HazelcastSetConsumer
extends HazelcastDefaultConsumer {
    private final ISet<Object> set;
    private UUID listener;

    public HazelcastSetConsumer(HazelcastInstance hazelcastInstance, Endpoint endpoint, Processor processor, String cacheName) {
        super(hazelcastInstance, endpoint, processor, cacheName);
        this.set = hazelcastInstance.getSet(cacheName);
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.listener = this.set.addItemListener((ItemListener)new CamelItemListener(this, this.cacheName), true);
    }

    protected void doStop() throws Exception {
        this.set.removeItemListener(this.listener);
        super.doStop();
    }
}

