/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.worker;

import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.sql.impl.LocalMemberIdProvider;
import com.hazelcast.sql.impl.operation.QueryOperationHandler;
import com.hazelcast.sql.impl.worker.QueryOperationExecutable;
import com.hazelcast.sql.impl.worker.QueryOperationWorker;
import java.util.concurrent.ThreadLocalRandom;

public class QueryOperationWorkerPool {
    private final int threadCount;
    private final QueryOperationWorker[] workers;

    public QueryOperationWorkerPool(String instanceName, int threadCount, LocalMemberIdProvider localMemberIdProvider, QueryOperationHandler operationHandler, SerializationService serializationService, ILogger logger) {
        this.threadCount = threadCount;
        this.workers = new QueryOperationWorker[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            QueryOperationWorker worker;
            this.workers[i] = worker = new QueryOperationWorker(localMemberIdProvider, operationHandler, serializationService, instanceName, i, logger);
        }
    }

    public void submit(int partition, QueryOperationExecutable task) {
        int index = this.getWorkerIndex(partition);
        QueryOperationWorker worker = this.getWorker(index);
        worker.submit(task);
    }

    public void stop() {
        for (QueryOperationWorker worker : this.workers) {
            worker.stop();
        }
    }

    QueryOperationWorker getWorker(int index) {
        return this.workers[index];
    }

    private int getWorkerIndex(int partition) {
        int index = partition == -1 ? ThreadLocalRandom.current().nextInt(this.threadCount) : partition % this.threadCount;
        assert (index >= 0 && index < this.threadCount);
        return index;
    }
}

