/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.AbstractDecimalConverter;
import java.math.BigDecimal;

public final class BigDecimalConverter
extends AbstractDecimalConverter {
    public static final BigDecimalConverter INSTANCE = new BigDecimalConverter();

    private BigDecimalConverter() {
        super(6);
    }

    @Override
    public Class<?> getValueClass() {
        return BigDecimal.class;
    }

    @Override
    public byte asTinyint(Object val) {
        BigDecimal casted = this.cast(val);
        try {
            return casted.setScale(0, 1).byteValueExact();
        }
        catch (ArithmeticException e) {
            throw this.numericOverflow(QueryDataTypeFamily.TINYINT, val);
        }
    }

    @Override
    public short asSmallint(Object val) {
        BigDecimal casted = this.cast(val);
        try {
            return casted.setScale(0, 1).shortValueExact();
        }
        catch (ArithmeticException e) {
            throw this.numericOverflow(QueryDataTypeFamily.SMALLINT, val);
        }
    }

    @Override
    public int asInt(Object val) {
        BigDecimal casted = this.cast(val);
        try {
            return casted.setScale(0, 1).intValueExact();
        }
        catch (ArithmeticException e) {
            throw this.numericOverflow(QueryDataTypeFamily.INTEGER, val);
        }
    }

    @Override
    public long asBigint(Object val) {
        BigDecimal casted = this.cast(val);
        try {
            return casted.setScale(0, 1).longValueExact();
        }
        catch (ArithmeticException e) {
            throw this.numericOverflow(QueryDataTypeFamily.BIGINT, val);
        }
    }

    @Override
    public BigDecimal asDecimal(Object val) {
        return this.cast(val);
    }

    @Override
    public float asReal(Object val) {
        return this.cast(val).floatValue();
    }

    @Override
    public double asDouble(Object val) {
        return this.cast(val).doubleValue();
    }

    @Override
    public String asVarchar(Object val) {
        return this.cast(val).toString();
    }

    private BigDecimal cast(Object val) {
        return (BigDecimal)val;
    }
}

