/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.plan.node.io;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.plan.node.PlanNode;
import com.hazelcast.sql.impl.plan.node.PlanNodeVisitor;
import com.hazelcast.sql.impl.plan.node.UniInputPlanNode;
import com.hazelcast.sql.impl.plan.node.io.EdgeAwarePlanNode;
import java.io.IOException;
import java.util.Objects;

public class RootSendPlanNode
extends UniInputPlanNode
implements EdgeAwarePlanNode,
IdentifiedDataSerializable {
    private int edgeId;

    public RootSendPlanNode() {
    }

    public RootSendPlanNode(int id, PlanNode upstream, int edgeId) {
        super(id, upstream);
        this.edgeId = edgeId;
    }

    @Override
    public int getEdgeId() {
        return this.edgeId;
    }

    @Override
    public boolean isSender() {
        return true;
    }

    @Override
    public void visit0(PlanNodeVisitor visitor) {
        visitor.onRootSendNode(this);
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 15;
    }

    @Override
    public void writeData1(ObjectDataOutput out) throws IOException {
        out.writeInt(this.edgeId);
    }

    @Override
    public void readData1(ObjectDataInput in) throws IOException {
        this.edgeId = in.readInt();
    }

    public int hashCode() {
        return Objects.hash(this.id, this.edgeId, this.upstream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RootSendPlanNode that = (RootSendPlanNode)o;
        return this.id == that.id && this.edgeId == that.edgeId && this.upstream.equals(that.upstream);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.id + ", edgeId=" + this.edgeId + ", upstream=" + this.upstream + '}';
    }
}

