/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.exec.io;

import com.hazelcast.sql.impl.exec.AbstractUpstreamAwareExec;
import com.hazelcast.sql.impl.exec.Exec;
import com.hazelcast.sql.impl.exec.IterationResult;
import com.hazelcast.sql.impl.exec.io.Outbox;
import com.hazelcast.sql.impl.exec.io.OutboxSendQualifier;
import com.hazelcast.sql.impl.row.RowBatch;

public abstract class AbstractSendExec
extends AbstractUpstreamAwareExec {
    private RowBatch pendingBatch;
    private boolean pendingLast;

    public AbstractSendExec(int id, Exec upstream) {
        super(id, upstream);
    }

    @Override
    public IterationResult advance0() {
        block4: {
            boolean last;
            if (!this.pushPendingBatch()) {
                return IterationResult.WAIT;
            }
            if (this.state.isDone()) {
                return IterationResult.FETCHED_DONE;
            }
            do {
                if (!this.state.advance()) {
                    return IterationResult.WAIT;
                }
                RowBatch batch = this.state.consumeBatch();
                boolean pushed = this.pushBatch(batch, last = this.state.isDone());
                if (!pushed) break block4;
            } while (!last);
            return IterationResult.FETCHED_DONE;
        }
        return IterationResult.WAIT;
    }

    private boolean pushPendingBatch() {
        if (this.pendingBatch == null) {
            return true;
        }
        boolean res = this.pushPendingBatch(this.pendingBatch, this.pendingLast);
        if (res) {
            this.pendingBatch = null;
            return true;
        }
        return false;
    }

    private boolean pushBatch(RowBatch batch, boolean last) {
        assert (this.pendingBatch == null);
        this.setCurrentBatch(batch);
        boolean res = true;
        for (int outboxIndex = 0; outboxIndex < this.getOutboxCount(); ++outboxIndex) {
            OutboxSendQualifier qualifier = this.getOutboxQualifier(outboxIndex);
            int position = this.getOutbox(outboxIndex).onRowBatch(batch, last, 0, qualifier);
            if (position >= batch.getRowCount()) continue;
            if (this.pendingBatch == null) {
                this.pendingBatch = batch;
                this.pendingLast = last;
            }
            this.addPendingPosition(outboxIndex, position);
            res = false;
        }
        return res;
    }

    @Override
    public RowBatch currentBatch0() {
        throw new UnsupportedOperationException("Should not be called.");
    }

    protected abstract int getOutboxCount();

    protected abstract Outbox getOutbox(int var1);

    protected abstract void setCurrentBatch(RowBatch var1);

    protected abstract OutboxSendQualifier getOutboxQualifier(int var1);

    protected abstract void addPendingPosition(int var1, int var2);

    protected abstract boolean pushPendingBatch(RowBatch var1, boolean var2);
}

