/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.discovery;

import com.hazelcast.config.properties.PropertyDefinition;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.discovery.DiscoveryNode;
import com.hazelcast.spi.discovery.DiscoveryStrategy;
import java.util.Collection;
import java.util.Map;

public interface DiscoveryStrategyFactory {
    public Class<? extends DiscoveryStrategy> getDiscoveryStrategyType();

    public DiscoveryStrategy newDiscoveryStrategy(DiscoveryNode var1, ILogger var2, Map<String, Comparable> var3);

    public Collection<PropertyDefinition> getConfigurationProperties();

    default public boolean isAutoDetectionApplicable() {
        return false;
    }

    default public DiscoveryStrategyLevel discoveryStrategyLevel() {
        return DiscoveryStrategyLevel.UNKNOWN;
    }

    public static enum DiscoveryStrategyLevel {
        UNKNOWN(0),
        CLOUD_VM(10),
        PLATFORM(20),
        CUSTOM(50);

        private int priority;

        private DiscoveryStrategyLevel(int priority) {
            this.priority = priority;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

