/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class StringUtil {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final Locale LOCALE_INTERNAL = Locale.US;
    public static final Pattern VERSION_PATTERN = Pattern.compile("^(\\d+)\\.(\\d+)(\\.(\\d+))?(-\\w+(?:-\\d+)?)?(-SNAPSHOT)?$");
    private static final String GETTER_PREFIX = "get";
    private static final ILogger LOGGER = Logger.getLogger(StringUtil.class);

    private StringUtil() {
    }

    public static String bytesToString(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length, StandardCharsets.UTF_8);
    }

    public static String bytesToString(byte[] bytes) {
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] stringToBytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static boolean isNullOrEmpty(String s) {
        if (s == null) {
            return true;
        }
        return s.isEmpty();
    }

    public static boolean isNullOrEmptyAfterTrim(String s) {
        if (s == null) {
            return true;
        }
        return s.trim().isEmpty();
    }

    public static String upperCaseInternal(String s) {
        if (StringUtil.isNullOrEmpty(s)) {
            return s;
        }
        return s.toUpperCase(LOCALE_INTERNAL);
    }

    public static String lowerCaseFirstChar(String s) {
        if (s.isEmpty()) {
            return s;
        }
        char first = s.charAt(0);
        if (Character.isLowerCase(first)) {
            return s;
        }
        return Character.toLowerCase(first) + s.substring(1);
    }

    public static String lowerCaseInternal(String s) {
        if (StringUtil.isNullOrEmpty(s)) {
            return s;
        }
        return s.toLowerCase(LOCALE_INTERNAL);
    }

    public static String timeToString(long timeMillis) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return dateFormat.format(new Date(timeMillis));
    }

    public static String timeToStringFriendly(long timeMillis) {
        return timeMillis == 0L ? "never" : StringUtil.timeToString(timeMillis);
    }

    public static int indexOf(String input, char ch, int offset) {
        for (int i = offset; i < input.length(); ++i) {
            if (input.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(String input, char ch) {
        return StringUtil.indexOf(input, ch, 0);
    }

    public static int lastIndexOf(String input, char ch, int offset) {
        for (int i = input.length() - 1 - offset; i >= 0; --i) {
            if (input.charAt(i) != ch) continue;
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(String input, char ch) {
        return StringUtil.lastIndexOf(input, ch, 0);
    }

    public static String[] tokenizeVersionString(String version) {
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (matcher.matches()) {
            String[] tokens = new String[matcher.groupCount()];
            for (int i = 0; i < matcher.groupCount(); ++i) {
                tokens[i] = matcher.group(i + 1);
            }
            return tokens;
        }
        return null;
    }

    public static String getterIntoProperty(String getterName) {
        if (getterName == null) {
            return getterName;
        }
        int length = getterName.length();
        if (!getterName.startsWith(GETTER_PREFIX) || length <= GETTER_PREFIX.length()) {
            return getterName;
        }
        String propertyName = getterName.substring(GETTER_PREFIX.length(), length);
        char firstChar = propertyName.charAt(0);
        if (Character.isLetter(firstChar)) {
            if (Character.isLowerCase(firstChar)) {
                return getterName;
            }
            propertyName = Character.toLowerCase(firstChar) + propertyName.substring(1, propertyName.length());
        }
        return propertyName;
    }

    public static String trim(String input) {
        if (input == null) {
            return null;
        }
        return input.replaceAll("^\\s+|\\s+$", "");
    }

    public static String[] splitByComma(String input, boolean allowEmpty) {
        if (input == null) {
            return null;
        }
        String[] splitWithEmptyValues = StringUtil.trim(input).split("\\s*,\\s*", -1);
        return allowEmpty ? splitWithEmptyValues : StringUtil.subtraction(splitWithEmptyValues, new String[]{""});
    }

    public static String[] intersection(String[] arr1, String[] arr2) {
        if (arr1 == null || arr2 == null) {
            return null;
        }
        if (arr1.length == 0 || arr2.length == 0) {
            return new String[0];
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(arr1));
        list.retainAll(Arrays.asList(arr2));
        return list.toArray(new String[0]);
    }

    public static String[] subtraction(String[] arr1, String[] arr2) {
        if (arr1 == null || arr1.length == 0 || arr2 == null || arr2.length == 0) {
            return arr1;
        }
        ArrayList<String> list = new ArrayList<String>(Arrays.asList(arr1));
        list.removeAll(Arrays.asList(arr2));
        return list.toArray(new String[0]);
    }

    public static boolean equalsIgnoreCase(String str1, String str2) {
        return str1 == null || str2 == null ? false : str1 == str2 || StringUtil.lowerCaseInternal(str1).equals(StringUtil.lowerCaseInternal(str2));
    }

    public static String stripTrailingSlash(String str) {
        if (StringUtil.isNullOrEmpty(str)) {
            return str;
        }
        if (str.charAt(str.length() - 1) == '/') {
            return str.substring(0, str.length() - 1);
        }
        return str;
    }

    public static String resolvePlaceholders(String pattern, String placeholderNamespace, Map<String, Object> variableValues) {
        int endIndex;
        StringBuilder sb = new StringBuilder(pattern);
        String placeholderPrefix = "$" + placeholderNamespace + "{";
        int startIndex = sb.indexOf(placeholderPrefix);
        while (startIndex > -1 && (endIndex = sb.indexOf("}", startIndex)) != -1) {
            String variableName = sb.substring(startIndex + placeholderPrefix.length(), endIndex);
            Object variableValue = variableValues.get(variableName);
            if (variableValue != null) {
                String valueStr = variableValue.toString();
                sb.replace(startIndex, endIndex + 1, valueStr);
                endIndex = startIndex + valueStr.length();
            }
            startIndex = sb.indexOf(placeholderPrefix, endIndex);
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String formatXml(@Nullable String input, int indent) throws IllegalArgumentException {
        if (input == null || indent < 0) {
            return input;
        }
        if (indent == 0) {
            throw new IllegalArgumentException("Indentation must not be 0.");
        }
        StreamResult xmlOutput = null;
        try {
            Transformer transformer;
            StreamSource xmlInput;
            block13: {
                TransformerFactory transformerFactory;
                block12: {
                    xmlInput = new StreamSource(new StringReader(input));
                    xmlOutput = new StreamResult(new StringWriter());
                    transformerFactory = TransformerFactory.newInstance();
                    transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                    transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                    try {
                        transformerFactory.setAttribute("indent-number", indent);
                    }
                    catch (IllegalArgumentException e) {
                        if (!LOGGER.isFinestEnabled()) break block12;
                        LOGGER.finest("Failed to set indent-number attribute; cause: " + e.getMessage());
                    }
                }
                transformer = transformerFactory.newTransformer();
                transformer.setErrorListener(ThrowingErrorListener.INSTANCE);
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("encoding", "UTF-8");
                transformer.setOutputProperty("indent", "yes");
                try {
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indent));
                }
                catch (IllegalArgumentException e) {
                    if (!LOGGER.isFinestEnabled()) break block13;
                    LOGGER.finest("Failed to set indent-amount property; cause: " + e.getMessage());
                }
            }
            transformer.transform(xmlInput, xmlOutput);
            String string = xmlOutput.getWriter().toString();
            return string;
        }
        catch (Exception e) {
            LOGGER.warning(e);
            String string = input;
            return string;
        }
        finally {
            if (xmlOutput != null) {
                IOUtil.closeResource(xmlOutput.getWriter());
            }
        }
    }

    static final class ThrowingErrorListener
    implements ErrorListener {
        public static final ThrowingErrorListener INSTANCE = new ThrowingErrorListener();

        private ThrowingErrorListener() {
        }

        @Override
        public void warning(TransformerException exception) throws TransformerException {
            throw exception;
        }

        @Override
        public void fatalError(TransformerException exception) throws TransformerException {
            throw exception;
        }

        @Override
        public void error(TransformerException exception) throws TransformerException {
            throw exception;
        }
    }
}

