/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;

public class MapStoreConfig
implements IdentifiedDataSerializable {
    public static final int DEFAULT_WRITE_DELAY_SECONDS = 0;
    public static final int DEFAULT_WRITE_BATCH_SIZE = 1;
    public static final boolean DEFAULT_WRITE_COALESCING = true;
    private boolean enabled = true;
    private boolean writeCoalescing = true;
    private int writeDelaySeconds = 0;
    private int writeBatchSize = 1;
    private String className;
    private String factoryClassName;
    private Object implementation;
    private Object factoryImplementation;
    private Properties properties = new Properties();
    private InitialLoadMode initialLoadMode = InitialLoadMode.LAZY;

    public MapStoreConfig() {
    }

    public MapStoreConfig(MapStoreConfig config) {
        this.enabled = config.isEnabled();
        this.className = config.getClassName();
        this.implementation = config.getImplementation();
        this.factoryClassName = config.getFactoryClassName();
        this.factoryImplementation = config.getFactoryImplementation();
        this.writeDelaySeconds = config.getWriteDelaySeconds();
        this.writeBatchSize = config.getWriteBatchSize();
        this.initialLoadMode = config.getInitialLoadMode();
        this.writeCoalescing = config.isWriteCoalescing();
        this.properties.putAll((Map<?, ?>)config.getProperties());
    }

    public String getClassName() {
        return this.className;
    }

    public MapStoreConfig setClassName(@Nonnull String className) {
        this.className = Preconditions.checkHasText(className, "Map store class name must contain text");
        this.implementation = null;
        return this;
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public MapStoreConfig setFactoryClassName(@Nonnull String factoryClassName) {
        this.factoryClassName = Preconditions.checkHasText(factoryClassName, "Map store factory class name must contain text");
        this.factoryImplementation = null;
        return this;
    }

    public int getWriteDelaySeconds() {
        return this.writeDelaySeconds;
    }

    public MapStoreConfig setWriteDelaySeconds(int writeDelaySeconds) {
        this.writeDelaySeconds = writeDelaySeconds;
        return this;
    }

    public int getWriteBatchSize() {
        return this.writeBatchSize;
    }

    public MapStoreConfig setWriteBatchSize(int writeBatchSize) {
        if (writeBatchSize < 1) {
            throw new IllegalArgumentException("Write batch size must be at least 1");
        }
        this.writeBatchSize = writeBatchSize;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public MapStoreConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public MapStoreConfig setImplementation(@Nonnull Object implementation) {
        this.implementation = Preconditions.checkNotNull(implementation, "Map store cannot be null!");
        this.className = null;
        return this;
    }

    public Object getImplementation() {
        return this.implementation;
    }

    public MapStoreConfig setFactoryImplementation(@Nonnull Object factoryImplementation) {
        this.factoryImplementation = Preconditions.checkNotNull(factoryImplementation, "Map store factory cannot be null!");
        this.factoryClassName = null;
        return this;
    }

    public Object getFactoryImplementation() {
        return this.factoryImplementation;
    }

    public MapStoreConfig setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public MapStoreConfig setProperties(Properties properties) {
        this.properties = Preconditions.checkNotNull(properties, "Map store config properties cannot be null!");
        return this;
    }

    public InitialLoadMode getInitialLoadMode() {
        return this.initialLoadMode;
    }

    public MapStoreConfig setInitialLoadMode(InitialLoadMode initialLoadMode) {
        this.initialLoadMode = initialLoadMode;
        return this;
    }

    public boolean isWriteCoalescing() {
        return this.writeCoalescing;
    }

    public MapStoreConfig setWriteCoalescing(boolean writeCoalescing) {
        this.writeCoalescing = writeCoalescing;
        return this;
    }

    public String toString() {
        return "MapStoreConfig{enabled=" + this.enabled + ", className='" + this.className + '\'' + ", factoryClassName='" + this.factoryClassName + '\'' + ", writeDelaySeconds=" + this.writeDelaySeconds + ", writeBatchSize=" + this.writeBatchSize + ", implementation=" + this.implementation + ", factoryImplementation=" + this.factoryImplementation + ", properties=" + this.properties + ", initialLoadMode=" + (Object)((Object)this.initialLoadMode) + ", writeCoalescing=" + this.writeCoalescing + '}';
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MapStoreConfig)) {
            return false;
        }
        MapStoreConfig that = (MapStoreConfig)o;
        return this.enabled == that.enabled && this.writeCoalescing == that.writeCoalescing && this.writeDelaySeconds == that.writeDelaySeconds && this.writeBatchSize == that.writeBatchSize && Objects.equals(this.implementation, that.implementation) && Objects.equals(this.className, that.className) && Objects.equals(this.factoryImplementation, that.factoryImplementation) && Objects.equals(this.factoryClassName, that.factoryClassName) && this.properties.equals(that.properties) && this.initialLoadMode == that.initialLoadMode;
    }

    public final int hashCode() {
        return Objects.hash(new Object[]{this.enabled, this.writeCoalescing, this.implementation, this.className, this.factoryImplementation, this.factoryClassName, this.writeDelaySeconds, this.writeBatchSize, this.properties, this.initialLoadMode});
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 15;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeBoolean(this.enabled);
        out.writeBoolean(this.writeCoalescing);
        out.writeUTF(this.className);
        out.writeUTF(this.factoryClassName);
        out.writeInt(this.writeDelaySeconds);
        out.writeInt(this.writeBatchSize);
        out.writeObject(this.implementation);
        out.writeObject(this.factoryImplementation);
        out.writeObject(this.properties);
        out.writeUTF(this.initialLoadMode.name());
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.enabled = in.readBoolean();
        this.writeCoalescing = in.readBoolean();
        this.className = in.readUTF();
        this.factoryClassName = in.readUTF();
        this.writeDelaySeconds = in.readInt();
        this.writeBatchSize = in.readInt();
        this.implementation = in.readObject();
        this.factoryImplementation = in.readObject();
        this.properties = (Properties)in.readObject();
        this.initialLoadMode = InitialLoadMode.valueOf(in.readUTF());
    }

    public static enum InitialLoadMode {
        LAZY,
        EAGER;

    }
}

