/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.hazelcast.listener;

import org.apache.camel.Exchange;
import org.apache.camel.component.hazelcast.HazelcastComponentHelper;
import org.apache.camel.component.hazelcast.HazelcastDefaultConsumer;

public class CamelListener {
    private final String cacheName;
    private final HazelcastDefaultConsumer consumer;

    public CamelListener(HazelcastDefaultConsumer consumer, String cacheName) {
        this.cacheName = cacheName;
        this.consumer = consumer;
    }

    protected void sendExchange(String operation, Object key, Object value) {
        Exchange exchange = this.consumer.getEndpoint().createExchange();
        exchange.getIn().setBody(value);
        if (key != null) {
            exchange.getIn().setHeader("CamelHazelcastObjectId", key);
        }
        HazelcastComponentHelper.setListenerHeaders(exchange, "cachelistener", operation, this.cacheName);
        try {
            this.consumer.getProcessor().process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            this.consumer.getExceptionHandler().handleException(String.format("Error processing exchange for hazelcast consumer on object '%s' in cache '%s'.", key, this.cacheName), exchange, (Throwable)exchange.getException());
        }
    }

    public String getCacheName() {
        return this.cacheName;
    }

    public HazelcastDefaultConsumer getConsumer() {
        return this.consumer;
    }
}

