/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.properties;

import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;

public final class HazelcastProperty {
    private final String name;
    private final String defaultValue;
    private final TimeUnit timeUnit;
    private final HazelcastProperty parent;
    private final Function<HazelcastProperties, ?> function;
    private volatile String deprecatedName;

    public HazelcastProperty(String name) {
        this(name, (String)null);
    }

    public HazelcastProperty(String name, Function<HazelcastProperties, ?> function) {
        Preconditions.checkHasText(name, "The property name cannot be null or empty!");
        this.name = name;
        this.function = function;
        this.defaultValue = null;
        this.deprecatedName = null;
        this.parent = null;
        this.timeUnit = null;
    }

    public HazelcastProperty(String name, boolean defaultValue) {
        this(name, defaultValue ? "true" : "false");
    }

    public HazelcastProperty(String name, Integer defaultValue) {
        this(name, String.valueOf(defaultValue));
    }

    public HazelcastProperty(String name, Byte defaultValue) {
        this(name, String.valueOf(defaultValue));
    }

    public HazelcastProperty(String name, Integer defaultValue, TimeUnit timeUnit) {
        this(name, String.valueOf(defaultValue), timeUnit);
    }

    public HazelcastProperty(String name, Long defaultValue, TimeUnit timeUnit) {
        this(name, Long.toString(defaultValue), timeUnit);
    }

    public HazelcastProperty(String name, HazelcastProperty property) {
        this(name, property.getDefaultValue(), property.timeUnit, property);
    }

    public HazelcastProperty(String name, String defaultValue) {
        this(name, defaultValue, null);
    }

    protected HazelcastProperty(String name, String defaultValue, TimeUnit timeUnit) {
        this(name, defaultValue, timeUnit, null);
    }

    public HazelcastProperty(String name, String defaultValue, TimeUnit timeUnit, HazelcastProperty parent) {
        Preconditions.checkHasText(name, "The property name cannot be null or empty!");
        this.name = name;
        this.defaultValue = defaultValue;
        this.function = null;
        this.timeUnit = timeUnit;
        this.parent = parent;
    }

    public HazelcastProperty setDeprecatedName(String deprecatedName) {
        this.deprecatedName = Preconditions.checkHasText(deprecatedName, "a valid string should be provided");
        return this;
    }

    public Function<HazelcastProperties, ?> getFunction() {
        return this.function;
    }

    public String getDeprecatedName() {
        return this.deprecatedName;
    }

    public String getName() {
        return this.name;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public TimeUnit getTimeUnit() {
        if (this.timeUnit == null) {
            throw new IllegalArgumentException(String.format("Cluster property %s has no TimeUnit defined!", this));
        }
        return this.timeUnit;
    }

    public HazelcastProperty getParent() {
        return this.parent;
    }

    public void setSystemProperty(String value) {
        System.setProperty(this.name, value);
    }

    public String getSystemProperty() {
        return System.getProperty(this.name);
    }

    public String toString() {
        return this.name;
    }
}

