/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.internal.util.Preconditions;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.annotation.Nonnull;

public final class SSLConfig {
    private boolean enabled;
    private String factoryClassName;
    private Object factoryImplementation;
    private Properties properties = new Properties();

    public SSLConfig() {
    }

    public SSLConfig(SSLConfig sslConfig) {
        this.enabled = sslConfig.enabled;
        this.factoryClassName = sslConfig.factoryClassName;
        this.factoryImplementation = sslConfig.factoryImplementation;
        this.properties = new Properties();
        this.properties.putAll((Map<?, ?>)sslConfig.properties);
    }

    public String getFactoryClassName() {
        return this.factoryClassName;
    }

    public SSLConfig setFactoryClassName(@Nonnull String factoryClassName) {
        this.factoryClassName = Preconditions.checkHasText(factoryClassName, "SSL context factory class name cannot be null!");
        this.factoryImplementation = null;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public SSLConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public SSLConfig setFactoryImplementation(@Nonnull Object factoryImplementation) {
        this.factoryImplementation = Preconditions.checkNotNull(factoryImplementation, "SSL context factory cannot be null!");
        this.factoryClassName = null;
        return this;
    }

    public Object getFactoryImplementation() {
        return this.factoryImplementation;
    }

    public SSLConfig setProperty(String name, String value) {
        this.properties.put(name, value);
        return this;
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public SSLConfig setProperties(Properties properties) {
        if (properties == null) {
            throw new IllegalArgumentException("properties can't be null");
        }
        this.properties = properties;
        return this;
    }

    public String toString() {
        return "SSLConfig{className='" + this.factoryClassName + '\'' + ", enabled=" + this.enabled + ", implementation=" + this.factoryImplementation + ", properties=" + this.properties + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SSLConfig sslConfig = (SSLConfig)o;
        return Objects.equals(this.enabled, sslConfig.enabled) && Objects.equals(this.properties, sslConfig.properties) && Objects.equals(this.factoryImplementation, sslConfig.factoryImplementation) && Objects.equals(this.factoryClassName, sslConfig.factoryClassName);
    }

    public int hashCode() {
        return Objects.hash(this.enabled, this.factoryImplementation, this.factoryClassName, this.properties);
    }
}

