/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy.txn;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.transaction.TransactionException;

public final class ClientTransactionUtil {
    private static final ExceptionUtil.RuntimeExceptionFactory TRANSACTION_EXCEPTION_FACTORY = new ExceptionUtil.RuntimeExceptionFactory(){

        @Override
        public RuntimeException create(Throwable throwable, String message) {
            return new TransactionException(message, throwable);
        }
    };

    private ClientTransactionUtil() {
    }

    public static ClientMessage invoke(ClientMessage request, Object objectName, HazelcastClientInstanceImpl client, Connection connection) {
        try {
            ClientInvocation clientInvocation = new ClientInvocation(client, request, objectName, connection);
            ClientInvocationFuture future = clientInvocation.invoke();
            return (ClientMessage)future.get();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow((Throwable)e, TRANSACTION_EXCEPTION_FACTORY);
        }
    }
}

