/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnectionManager;
import com.hazelcast.client.impl.connection.nio.ClientConnection;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.spi.ClientInvocationService;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientPartitionServiceImpl;
import com.hazelcast.client.impl.spi.impl.ClientResponseHandlerSupplier;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import com.hazelcast.spi.impl.sequence.CallIdFactory;
import com.hazelcast.spi.impl.sequence.CallIdSequence;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public abstract class AbstractClientInvocationService
implements ClientInvocationService {
    private static final HazelcastProperty CLEAN_RESOURCES_MILLIS = new HazelcastProperty("hazelcast.client.internal.clean.resources.millis", 100, TimeUnit.MILLISECONDS);
    protected final HazelcastClientInstanceImpl client;
    protected ClientConnectionManager connectionManager;
    protected ClientPartitionServiceImpl partitionService;
    final ILogger invocationLogger;
    @Probe(name="pendingCalls", level=ProbeLevel.MANDATORY)
    private ConcurrentMap<Long, ClientInvocation> invocations = new ConcurrentHashMap<Long, ClientInvocation>();
    private ClientResponseHandlerSupplier responseHandlerSupplier;
    private volatile boolean isShutdown;
    private final long invocationTimeoutMillis;
    private final long invocationRetryPauseMillis;
    private final CallIdSequence callIdSequence;
    private final boolean shouldFailOnIndeterminateOperationState;
    private final int operationBackupTimeoutMillis;

    AbstractClientInvocationService(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.invocationLogger = client.getLoggingService().getLogger(ClientInvocationService.class);
        this.invocationTimeoutMillis = this.initInvocationTimeoutMillis();
        this.invocationRetryPauseMillis = this.initInvocationRetryPauseMillis();
        this.responseHandlerSupplier = new ClientResponseHandlerSupplier(this, client.getConcurrencyDetection());
        HazelcastProperties properties = client.getProperties();
        this.callIdSequence = CallIdFactory.newCallIdSequence(properties.getInteger(ClientProperty.MAX_CONCURRENT_INVOCATIONS), properties.getLong(ClientProperty.BACKPRESSURE_BACKOFF_TIMEOUT_MILLIS), client.getConcurrencyDetection());
        this.operationBackupTimeoutMillis = properties.getInteger(ClientProperty.OPERATION_BACKUP_TIMEOUT_MILLIS);
        this.shouldFailOnIndeterminateOperationState = properties.getBoolean(ClientProperty.FAIL_ON_INDETERMINATE_OPERATION_STATE);
        client.getMetricsRegistry().registerStaticMetrics(this, "invocations");
    }

    private long initInvocationRetryPauseMillis() {
        return this.client.getProperties().getPositiveMillisOrDefault(ClientProperty.INVOCATION_RETRY_PAUSE_MILLIS);
    }

    private long initInvocationTimeoutMillis() {
        return this.client.getProperties().getPositiveMillisOrDefault(ClientProperty.INVOCATION_TIMEOUT_SECONDS);
    }

    @Probe(name="startedInvocations", level=ProbeLevel.MANDATORY)
    private long startedInvocations() {
        return this.callIdSequence.getLastCallId();
    }

    @Probe(name="maxCurrentInvocations", level=ProbeLevel.MANDATORY)
    private long maxCurrentInvocations() {
        return this.callIdSequence.getMaxConcurrentInvocations();
    }

    public long getInvocationTimeoutMillis() {
        return this.invocationTimeoutMillis;
    }

    public long getInvocationRetryPauseMillis() {
        return this.invocationRetryPauseMillis;
    }

    CallIdSequence getCallIdSequence() {
        return this.callIdSequence;
    }

    public void start() {
        this.connectionManager = this.client.getConnectionManager();
        this.partitionService = (ClientPartitionServiceImpl)this.client.getClientPartitionService();
        this.responseHandlerSupplier.start();
        TaskScheduler executionService = this.client.getTaskScheduler();
        long cleanResourcesMillis = this.client.getProperties().getPositiveMillisOrDefault(CLEAN_RESOURCES_MILLIS);
        executionService.scheduleWithRepetition(new CleanResourcesTask(), cleanResourcesMillis, cleanResourcesMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public Consumer<ClientMessage> getResponseHandler() {
        return this.responseHandlerSupplier.get();
    }

    @Override
    public boolean isRedoOperation() {
        return this.client.getClientConfig().getNetworkConfig().isRedoOperation();
    }

    protected final void send(ClientInvocation invocation, ClientConnection connection) throws IOException {
        if (this.isShutdown) {
            throw new HazelcastClientNotActiveException();
        }
        this.registerInvocation(invocation, connection);
        ClientMessage clientMessage = invocation.getClientMessage();
        if (!this.writeToConnection(connection, clientMessage)) {
            throw new IOException("Packet not sent to " + connection.getEndPoint() + " " + clientMessage);
        }
        invocation.setSendConnection(connection);
    }

    private boolean writeToConnection(ClientConnection connection, ClientMessage clientMessage) {
        return connection.write(clientMessage);
    }

    private void registerInvocation(ClientInvocation clientInvocation, ClientConnection connection) {
        ClientMessage clientMessage = clientInvocation.getClientMessage();
        long correlationId = clientMessage.getCorrelationId();
        this.invocations.put(correlationId, clientInvocation);
        EventHandler handler = clientInvocation.getEventHandler();
        if (handler != null) {
            connection.addEventHandler(correlationId, handler);
        }
    }

    void deRegisterInvocation(long callId) {
        this.invocations.remove(callId);
    }

    ClientInvocation getInvocation(long callId) {
        return (ClientInvocation)this.invocations.get(callId);
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public void shutdown() {
        this.isShutdown = true;
        this.responseHandlerSupplier.shutdown();
        for (ClientInvocation invocation : this.invocations.values()) {
            invocation.notifyException(new HazelcastClientNotActiveException());
        }
    }

    void checkInvocationAllowed() throws IOException {
        this.connectionManager.checkInvocationAllowed();
    }

    boolean shouldFailOnIndeterminateOperationState() {
        return this.shouldFailOnIndeterminateOperationState;
    }

    private class CleanResourcesTask
    implements Runnable {
        private CleanResourcesTask() {
        }

        @Override
        public void run() {
            for (ClientInvocation invocation : AbstractClientInvocationService.this.invocations.values()) {
                ClientConnection connection = invocation.getSendConnection();
                if (connection == null) continue;
                if (!connection.isAlive()) {
                    this.notifyException(invocation, connection);
                    return;
                }
                invocation.detectAndHandleBackupTimeout(AbstractClientInvocationService.this.operationBackupTimeoutMillis);
            }
        }

        private void notifyException(ClientInvocation invocation, ClientConnection connection) {
            TargetDisconnectedException ex = new TargetDisconnectedException(connection.getCloseReason(), connection.getCloseCause());
            invocation.notifyException(ex);
        }
    }
}

