/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecord;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.GenericRecordBuilder;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PortableGenericRecordBuilder
implements GenericRecordBuilder {
    private final ClassDefinition classDefinition;
    private final Object[] objects;
    private final boolean[] isSet;
    private final boolean isClone;

    public PortableGenericRecordBuilder(ClassDefinition classDefinition) {
        this.classDefinition = classDefinition;
        this.objects = new Object[classDefinition.getFieldCount()];
        this.isClone = false;
        this.isSet = new boolean[this.objects.length];
    }

    PortableGenericRecordBuilder(ClassDefinition classDefinition, Object[] objects) {
        this.classDefinition = classDefinition;
        this.objects = objects;
        this.isClone = true;
        this.isSet = new boolean[objects.length];
    }

    @Override
    @Nonnull
    public GenericRecord build() {
        if (!this.isClone) {
            for (int i = 0; i < this.isSet.length; ++i) {
                if (this.isSet[i]) continue;
                throw new HazelcastSerializationException("All fields must be written when building a GenericRecord for portable, unwritten field :" + this.classDefinition.getField(i));
            }
        }
        return new PortableGenericRecord(this.classDefinition, this.objects);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setInt(@Nonnull String fieldName, int value) {
        return this.set(fieldName, value, FieldType.INT);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setLong(@Nonnull String fieldName, long value) {
        return this.set(fieldName, value, FieldType.LONG);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setString(@Nonnull String fieldName, String value) {
        return this.set(fieldName, value, FieldType.UTF);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setBoolean(@Nonnull String fieldName, boolean value) {
        return this.set(fieldName, value, FieldType.BOOLEAN);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setByte(@Nonnull String fieldName, byte value) {
        return this.set(fieldName, value, FieldType.BYTE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setChar(@Nonnull String fieldName, char value) {
        return this.set(fieldName, Character.valueOf(value), FieldType.CHAR);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDouble(@Nonnull String fieldName, double value) {
        return this.set(fieldName, value, FieldType.DOUBLE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setFloat(@Nonnull String fieldName, float value) {
        return this.set(fieldName, Float.valueOf(value), FieldType.FLOAT);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setShort(@Nonnull String fieldName, short value) {
        return this.set(fieldName, value, FieldType.SHORT);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setGenericRecord(@Nonnull String fieldName, @Nullable GenericRecord value) {
        return this.set(fieldName, value, FieldType.PORTABLE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDecimal(@Nonnull String fieldName, @Nullable BigDecimal value) {
        return this.set(fieldName, value, FieldType.DECIMAL);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTime(@Nonnull String fieldName, @Nullable LocalTime value) {
        return this.set(fieldName, value, FieldType.TIME);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDate(@Nonnull String fieldName, @Nullable LocalDate value) {
        return this.set(fieldName, value, FieldType.DATE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestamp(@Nonnull String fieldName, @Nullable LocalDateTime value) {
        return this.set(fieldName, value, FieldType.TIMESTAMP);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestampWithTimezone(@Nonnull String fieldName, @Nullable OffsetDateTime value) {
        return this.set(fieldName, value, FieldType.TIMESTAMP_WITH_TIMEZONE);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setGenericRecordArray(@Nonnull String fieldName, @Nullable GenericRecord[] value) {
        return this.set(fieldName, value, FieldType.PORTABLE_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setByteArray(@Nonnull String fieldName, byte[] value) {
        return this.set(fieldName, value, FieldType.BYTE_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setBooleanArray(@Nonnull String fieldName, boolean[] value) {
        return this.set(fieldName, value, FieldType.BOOLEAN_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setCharArray(@Nonnull String fieldName, char[] value) {
        return this.set(fieldName, value, FieldType.CHAR_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setIntArray(@Nonnull String fieldName, int[] value) {
        return this.set(fieldName, value, FieldType.INT_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setLongArray(@Nonnull String fieldName, long[] value) {
        return this.set(fieldName, value, FieldType.LONG_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDoubleArray(@Nonnull String fieldName, double[] value) {
        return this.set(fieldName, value, FieldType.DOUBLE_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setFloatArray(@Nonnull String fieldName, float[] value) {
        return this.set(fieldName, value, FieldType.FLOAT_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setShortArray(@Nonnull String fieldName, short[] value) {
        return this.set(fieldName, value, FieldType.SHORT_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setStringArray(@Nonnull String fieldName, String[] value) {
        return this.set(fieldName, value, FieldType.UTF_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDecimalArray(@Nonnull String fieldName, BigDecimal[] value) {
        return this.set(fieldName, value, FieldType.DECIMAL_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimeArray(@Nonnull String fieldName, LocalTime[] value) {
        return this.set(fieldName, value, FieldType.TIME_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setDateArray(@Nonnull String fieldName, LocalDate[] value) {
        return this.set(fieldName, value, FieldType.DATE_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestampArray(@Nonnull String fieldName, LocalDateTime[] value) {
        return this.set(fieldName, value, FieldType.TIMESTAMP_ARRAY);
    }

    @Override
    @Nonnull
    public GenericRecordBuilder setTimestampWithTimezoneArray(@Nonnull String fieldName, OffsetDateTime[] value) {
        return this.set(fieldName, value, FieldType.TIMESTAMP_WITH_TIMEZONE_ARRAY);
    }

    private GenericRecordBuilder set(@Nonnull String fieldName, Object value, FieldType fieldType) {
        FieldDefinition fd = this.check(fieldName, fieldType);
        int index = fd.getIndex();
        if (this.isSet[index]) {
            if (!this.isClone) {
                throw new HazelcastSerializationException("It is illegal to the overwrite the field");
            }
            throw new HazelcastSerializationException("Field can only overwritten once with `cloneWithBuilder`");
        }
        this.objects[index] = value;
        this.isSet[index] = true;
        return this;
    }

    @Nonnull
    private FieldDefinition check(@Nonnull String fieldName, FieldType fieldType) {
        FieldDefinition fd = this.classDefinition.getField(fieldName);
        if (fd == null) {
            throw new HazelcastSerializationException("Invalid field name: '" + fieldName + "' for ClassDefinition {id: " + this.classDefinition.getClassId() + ", version: " + this.classDefinition.getVersion() + "}");
        }
        if (!fd.getType().equals((Object)fieldType)) {
            throw new HazelcastSerializationException("Invalid field type: '" + fieldName + "' for ClassDefinition {id: " + this.classDefinition.getClassId() + ", version: " + this.classDefinition.getVersion() + "}, expected : " + (Object)((Object)fd.getType()) + ", given : " + (Object)((Object)fieldType));
        }
        return fd;
    }
}

