/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl;

import com.hazelcast.config.SqlConfig;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.nio.Packet;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.exception.ServiceNotFoundException;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.NodeEngineImpl;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlService;
import com.hazelcast.sql.SqlStatement;
import com.hazelcast.sql.impl.JetSqlCoreBackend;
import com.hazelcast.sql.impl.NodeServiceProviderImpl;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.QueryUtils;
import com.hazelcast.sql.impl.SqlInternalService;
import com.hazelcast.sql.impl.SqlResultImpl;
import com.hazelcast.sql.impl.optimizer.DisabledSqlOptimizer;
import com.hazelcast.sql.impl.optimizer.OptimizationTask;
import com.hazelcast.sql.impl.optimizer.SqlOptimizer;
import com.hazelcast.sql.impl.optimizer.SqlPlan;
import com.hazelcast.sql.impl.plan.Plan;
import com.hazelcast.sql.impl.plan.cache.CacheablePlan;
import com.hazelcast.sql.impl.plan.cache.PlanCache;
import com.hazelcast.sql.impl.plan.cache.PlanCacheChecker;
import com.hazelcast.sql.impl.plan.cache.PlanCacheKey;
import com.hazelcast.sql.impl.schema.SqlCatalog;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.schema.map.JetMapMetadataResolver;
import com.hazelcast.sql.impl.schema.map.PartitionedMapTableResolver;
import com.hazelcast.sql.impl.security.NoOpSqlSecurityContext;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import com.hazelcast.sql.impl.state.QueryState;
import java.lang.reflect.Constructor;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.logging.Level;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SqlServiceImpl
implements SqlService,
Consumer<Packet> {
    static final String OPTIMIZER_CLASS_PROPERTY_NAME = "hazelcast.sql.optimizerClass";
    private static final String SQL_MODULE_OPTIMIZER_CLASS = "com.hazelcast.sql.impl.calcite.CalciteSqlOptimizer";
    private static final int OUTBOX_BATCH_SIZE = 524288;
    private static final long STATE_CHECK_FREQUENCY = 1000L;
    private static final int PLAN_CACHE_SIZE = 10000;
    private final ILogger logger;
    private final NodeEngineImpl nodeEngine;
    private final NodeServiceProviderImpl nodeServiceProvider;
    private final PlanCache planCache = new PlanCache(10000);
    private final int executorPoolSize;
    private final int operationPoolSize;
    private final long queryTimeout;
    private JetSqlCoreBackend jetSqlCoreBackend;
    private List<TableResolver> tableResolvers;
    private SqlOptimizer optimizer;
    private volatile SqlInternalService internalService;

    public SqlServiceImpl(NodeEngineImpl nodeEngine) {
        this.logger = nodeEngine.getLogger(this.getClass());
        this.nodeEngine = nodeEngine;
        this.nodeServiceProvider = new NodeServiceProviderImpl(nodeEngine);
        SqlConfig config = nodeEngine.getConfig().getSqlConfig();
        int executorPoolSize = config.getExecutorPoolSize();
        int operationPoolSize = config.getOperationPoolSize();
        long queryTimeout = config.getStatementTimeoutMillis();
        if (executorPoolSize == -1) {
            executorPoolSize = Runtime.getRuntime().availableProcessors();
        }
        if (operationPoolSize == -1) {
            operationPoolSize = Runtime.getRuntime().availableProcessors();
        }
        assert (executorPoolSize > 0);
        assert (operationPoolSize > 0);
        assert (queryTimeout >= 0L);
        this.executorPoolSize = executorPoolSize;
        this.operationPoolSize = operationPoolSize;
        this.queryTimeout = queryTimeout;
    }

    public void start() {
        block2: {
            try {
                this.jetSqlCoreBackend = (JetSqlCoreBackend)this.nodeEngine.getService("hz:impl:jetSqlCoreBackend");
            }
            catch (HazelcastException e) {
                if (e.getCause() instanceof ServiceNotFoundException) break block2;
                throw e;
            }
        }
        this.tableResolvers = SqlServiceImpl.createTableResolvers(this.nodeEngine, this.jetSqlCoreBackend);
        this.optimizer = this.createOptimizer(this.nodeEngine, this.jetSqlCoreBackend);
        String instanceName = this.nodeEngine.getHazelcastInstance().getName();
        InternalSerializationService serializationService = (InternalSerializationService)this.nodeEngine.getSerializationService();
        PlanCacheChecker planCacheChecker = new PlanCacheChecker(this.nodeEngine, this.planCache, this.tableResolvers);
        this.internalService = new SqlInternalService(instanceName, this.nodeServiceProvider, serializationService, this.operationPoolSize, this.executorPoolSize, 524288, 1000L, planCacheChecker);
        this.internalService.start();
    }

    public void reset() {
        this.planCache.clear();
        if (this.jetSqlCoreBackend != null) {
            this.jetSqlCoreBackend.reset();
        }
    }

    public void shutdown() {
        this.planCache.clear();
        if (this.jetSqlCoreBackend != null) {
            this.jetSqlCoreBackend.shutdown(true);
        }
        if (this.internalService != null) {
            this.internalService.shutdown();
        }
    }

    public SqlInternalService getInternalService() {
        return this.internalService;
    }

    public void setInternalService(SqlInternalService internalService) {
        this.internalService = internalService;
    }

    public SqlOptimizer getOptimizer() {
        return this.optimizer;
    }

    public PlanCache getPlanCache() {
        return this.planCache;
    }

    @Override
    @Nonnull
    public SqlResult execute(@Nonnull SqlStatement statement) {
        return this.execute(statement, NoOpSqlSecurityContext.INSTANCE);
    }

    public SqlResult execute(@Nonnull SqlStatement statement, SqlSecurityContext securityContext) {
        Preconditions.checkNotNull(statement, "Query cannot be null");
        try {
            if (this.nodeEngine.getLocalMember().isLiteMember()) {
                throw QueryException.error("SQL queries cannot be executed on lite members");
            }
            long timeout = statement.getTimeoutMillis();
            if (timeout == -1L) {
                timeout = this.queryTimeout;
            }
            return this.query0(statement.getSql(), statement.getParameters(), timeout, statement.getCursorBufferSize(), securityContext);
        }
        catch (AccessControlException e) {
            throw e;
        }
        catch (Exception e) {
            throw QueryUtils.toPublicException(e, this.nodeServiceProvider.getLocalMemberId());
        }
    }

    @Override
    public void accept(Packet packet) {
        this.internalService.onPacket(packet);
    }

    private SqlResult query0(String sql, List<Object> params, long timeout, int pageSize, SqlSecurityContext securityContext) {
        if (sql == null || sql.isEmpty()) {
            throw QueryException.error("SQL statement cannot be empty.");
        }
        ArrayList<Object> params0 = new ArrayList<Object>(params);
        if (timeout < 0L) {
            throw QueryException.error("Timeout cannot be negative: " + timeout);
        }
        if (pageSize <= 0) {
            throw QueryException.error("Page size must be positive: " + pageSize);
        }
        SqlPlan plan = this.prepare(sql);
        if (securityContext.isSecurityEnabled()) {
            plan.checkPermissions(securityContext);
        }
        return this.execute(plan, params0, timeout, pageSize);
    }

    private SqlPlan prepare(String sql) {
        SqlCatalog schema;
        List<List<String>> searchPaths = QueryUtils.prepareSearchPaths(Collections.emptyList(), this.tableResolvers);
        PlanCacheKey planKey = new PlanCacheKey(searchPaths, sql);
        SqlPlan plan = this.planCache.get(planKey);
        if (plan == null && (plan = this.optimizer.prepare(new OptimizationTask(sql, searchPaths, schema = new SqlCatalog(this.tableResolvers)))) instanceof CacheablePlan) {
            SqlPlan plan0 = plan;
            this.planCache.put(planKey, (CacheablePlan)plan0);
        }
        return plan;
    }

    private SqlResult execute(SqlPlan plan, List<Object> params, long timeout, int pageSize) {
        if (plan instanceof Plan) {
            return this.executeImdg((Plan)plan, params, timeout, pageSize);
        }
        return this.executeJet(plan, params, timeout, pageSize);
    }

    private SqlResult executeImdg(Plan plan, List<Object> params, long timeout, int pageSize) {
        QueryState state = this.internalService.execute(plan, params, timeout, pageSize, this.planCache);
        return SqlResultImpl.createRowsResult(state);
    }

    private SqlResult executeJet(SqlPlan plan, List<Object> params, long timeout, int pageSize) {
        return this.jetSqlCoreBackend.execute(plan, params, timeout, pageSize);
    }

    private SqlOptimizer createOptimizer(NodeEngine nodeEngine, JetSqlCoreBackend jetSqlCoreBackend) {
        Constructor<?> constructor;
        Class<?> clazz;
        String className = System.getProperty(OPTIMIZER_CLASS_PROPERTY_NAME, SQL_MODULE_OPTIMIZER_CLASS);
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(SQL_MODULE_OPTIMIZER_CLASS.equals(className) ? Level.FINE : Level.WARNING, "Optimizer class \"" + className + "\" not found, falling back to " + DisabledSqlOptimizer.class.getName());
            return new DisabledSqlOptimizer();
        }
        catch (Exception e) {
            throw new HazelcastException("Failed to resolve optimizer class " + className + ": " + e.getMessage(), e);
        }
        try {
            constructor = clazz.getConstructor(NodeEngine.class, JetSqlCoreBackend.class);
        }
        catch (ReflectiveOperationException e) {
            throw new HazelcastException("Failed to get the constructor for the optimizer class " + className + ": " + e.getMessage(), e);
        }
        try {
            return (SqlOptimizer)constructor.newInstance(nodeEngine, jetSqlCoreBackend);
        }
        catch (ReflectiveOperationException e) {
            throw new HazelcastException("Failed to instantiate the optimizer class " + className + ": " + e.getMessage(), e);
        }
    }

    private static List<TableResolver> createTableResolvers(NodeEngine nodeEngine, @Nullable JetSqlCoreBackend jetSqlCoreBackend) {
        JetMapMetadataResolver jetMetadataResolver;
        ArrayList<TableResolver> res = new ArrayList<TableResolver>();
        if (jetSqlCoreBackend != null) {
            res.addAll(jetSqlCoreBackend.tableResolvers());
            jetMetadataResolver = jetSqlCoreBackend.mapMetadataResolver();
        } else {
            jetMetadataResolver = JetMapMetadataResolver.NO_OP;
        }
        res.add(new PartitionedMapTableResolver(nodeEngine, jetMetadataResolver));
        return res;
    }
}

