/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import com.hazelcast.spi.impl.operationservice.PartitionAwareOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PutAllBackupOperation
extends MapOperation
implements PartitionAwareOperation,
BackupOperation {
    private boolean disableWanReplicationEvent;
    private List dataKeyDataValueRecord;
    private transient int lastIndex;
    private transient List dataKeyRecord;

    public PutAllBackupOperation(String name, List dataKeyDataValueRecord, boolean disableWanReplicationEvent) {
        super(name);
        this.dataKeyDataValueRecord = dataKeyDataValueRecord;
        this.disableWanReplicationEvent = disableWanReplicationEvent;
    }

    public PutAllBackupOperation() {
    }

    @Override
    protected void runInternal() {
        if (this.dataKeyRecord != null) {
            for (int i = this.lastIndex; i < this.dataKeyRecord.size(); i += 2) {
                Data key = (Data)this.dataKeyRecord.get(i);
                Record record = (Record)this.dataKeyRecord.get(i + 1);
                this.putBackup(key, record);
                this.lastIndex = i;
            }
        } else {
            for (int i = this.lastIndex; i < this.dataKeyDataValueRecord.size(); i += 3) {
                Data key = (Data)this.dataKeyDataValueRecord.get(i);
                Record record = (Record)this.dataKeyDataValueRecord.get(i + 2);
                this.putBackup(key, record);
                this.lastIndex = i;
            }
        }
    }

    private void putBackup(Data key, Record record) {
        Object currentRecord = this.recordStore.putBackup(key, record, false, this.getCallerProvenance());
        Records.copyMetadataFrom(record, currentRecord);
        this.publishWanUpdate(key, record.getValue());
        this.evict(key);
    }

    @Override
    protected boolean disableWanReplicationEvent() {
        return this.disableWanReplicationEvent;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.dataKeyDataValueRecord.size() / 3);
        for (int i = 0; i < this.dataKeyDataValueRecord.size(); i += 3) {
            Data dataKey = (Data)this.dataKeyDataValueRecord.get(i);
            Data dataValue = (Data)this.dataKeyDataValueRecord.get(i + 1);
            Record record = (Record)this.dataKeyDataValueRecord.get(i + 2);
            IOUtil.writeData(out, dataKey);
            Records.writeRecord(out, record, dataValue);
        }
        out.writeBoolean(this.disableWanReplicationEvent);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        ArrayList<Object> dataKeyRecord = new ArrayList<Object>(size * 2);
        for (int i = 0; i < size; ++i) {
            dataKeyRecord.add(IOUtil.readData(in));
            dataKeyRecord.add(Records.readRecord(in));
        }
        this.dataKeyRecord = dataKeyRecord;
        this.disableWanReplicationEvent = in.readBoolean();
    }

    @Override
    public int getClassId() {
        return 22;
    }
}

