/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.config.Config;
import com.hazelcast.config.EndpointConfig;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.ProtocolType;
import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.Networking;
import com.hazelcast.internal.nio.ConnectionListener;
import com.hazelcast.internal.server.NetworkStats;
import com.hazelcast.internal.server.Server;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.ServerContext;
import com.hazelcast.internal.server.tcp.ServerSocketRegistry;
import com.hazelcast.internal.server.tcp.TcpServerAcceptor;
import com.hazelcast.internal.server.tcp.TcpServerConnectionManager;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.concurrent.ThreadFactoryImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.properties.ClusterProperty;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

public final class TcpServer
implements Server {
    private static final int SCHEDULER_POOL_SIZE = 4;
    private final ServerContext context;
    private final ILogger logger;
    private final Networking networking;
    private final MetricsRegistry metricsRegistry;
    private ScheduledFuture refreshStatsFuture;
    private final RefreshNetworkStatsTask refreshStatsTask;
    private final int refreshStatsIntervalSeconds;
    private final ServerSocketRegistry registry;
    private final ConcurrentMap<EndpointQualifier, TcpServerConnectionManager> connectionManagers = new ConcurrentHashMap<EndpointQualifier, TcpServerConnectionManager>();
    private final TcpServerConnectionManager unifiedConnectionManager;
    private final ScheduledExecutorService scheduler;
    private final AtomicReference<TcpServerAcceptor> acceptorRef = new AtomicReference();
    private volatile boolean live;

    public TcpServer(Config config, ServerContext context, ServerSocketRegistry registry, MetricsRegistry metricsRegistry, Networking networking, Function<EndpointQualifier, ChannelInitializer> channelInitializerFn) {
        this.context = context;
        this.networking = networking;
        this.metricsRegistry = metricsRegistry;
        this.refreshStatsTask = new RefreshNetworkStatsTask();
        this.refreshStatsIntervalSeconds = context.properties().getInteger(ClusterProperty.NETWORK_STATS_REFRESH_INTERVAL_SECONDS);
        this.registry = registry;
        this.logger = context.getLoggingService().getLogger(TcpServer.class);
        this.scheduler = new ScheduledThreadPoolExecutor(4, new ThreadFactoryImpl(ThreadUtil.createThreadPoolName(context.getHazelcastName(), "TcpServer")));
        if (registry.holdsUnifiedSocket()) {
            this.unifiedConnectionManager = new TcpServerConnectionManager(this, null, channelInitializerFn, context, ProtocolType.valuesAsSet());
        } else {
            this.unifiedConnectionManager = null;
            for (EndpointConfig endpointConfig : config.getAdvancedNetworkConfig().getEndpointConfigs().values()) {
                EndpointQualifier qualifier = endpointConfig.getQualifier();
                TcpServerConnectionManager cm = new TcpServerConnectionManager(this, endpointConfig, channelInitializerFn, context, Collections.singleton(endpointConfig.getProtocolType()));
                this.connectionManagers.put(qualifier, cm);
            }
            this.refreshStatsTask.registerMetrics(metricsRegistry);
        }
        metricsRegistry.registerDynamicMetricsProvider(new MetricsProvider());
    }

    @Override
    public ServerContext getContext() {
        return this.context;
    }

    public Networking getNetworking() {
        return this.networking;
    }

    @Override
    public boolean isLive() {
        return this.live;
    }

    @Override
    public synchronized void start() {
        if (this.live) {
            return;
        }
        if (!this.registry.isOpen()) {
            throw new IllegalStateException("TcpServer is already shutdown. Cannot start!");
        }
        this.live = true;
        this.logger.finest("Starting TcpServer.");
        this.networking.restart();
        this.startAcceptor();
        if (this.unifiedConnectionManager == null) {
            this.refreshStatsFuture = this.metricsRegistry.scheduleAtFixedRate(this.refreshStatsTask, this.refreshStatsIntervalSeconds, TimeUnit.SECONDS, ProbeLevel.INFO);
        }
    }

    @Override
    public synchronized void stop() {
        if (!this.live) {
            return;
        }
        this.live = false;
        this.logger.finest("Stopping TcpServer");
        if (this.refreshStatsFuture != null) {
            this.refreshStatsFuture.cancel(false);
            this.refreshStatsFuture = null;
        }
        this.shutdownAcceptor();
        if (this.unifiedConnectionManager != null) {
            this.unifiedConnectionManager.reset(false);
        } else {
            this.connectionManagers.values().forEach(connectionManager -> connectionManager.reset(false));
        }
        this.networking.shutdown();
    }

    @Override
    public synchronized void shutdown() {
        this.shutdownAcceptor();
        this.closeServerSockets();
        this.stop();
        this.scheduler.shutdownNow();
        if (this.unifiedConnectionManager != null) {
            this.unifiedConnectionManager.reset(true);
        } else {
            this.connectionManagers.values().forEach(connectionManager -> connectionManager.reset(true));
        }
    }

    @Override
    @Nonnull
    public Collection<ServerConnection> getConnections() {
        if (this.unifiedConnectionManager != null) {
            return this.unifiedConnectionManager.getConnections();
        }
        HashSet<ServerConnection> connections = new HashSet<ServerConnection>();
        for (TcpServerConnectionManager connectionManager : this.connectionManagers.values()) {
            connections.addAll(connectionManager.getConnections());
        }
        return connections;
    }

    @Override
    public int connectionCount(Predicate<ServerConnection> predicate) {
        if (this.unifiedConnectionManager != null) {
            return this.unifiedConnectionManager.connectionCount(predicate);
        }
        return this.connectionManagers.values().stream().mapToInt(connectionManager -> connectionManager.connectionCount(predicate)).sum();
    }

    @Override
    public Map<EndpointQualifier, NetworkStats> getNetworkStats() {
        if (this.unifiedConnectionManager != null) {
            return Collections.emptyMap();
        }
        HashMap<EndpointQualifier, NetworkStats> stats = new HashMap<EndpointQualifier, NetworkStats>();
        for (Map.Entry entry : this.connectionManagers.entrySet()) {
            stats.put((EndpointQualifier)entry.getKey(), ((TcpServerConnectionManager)entry.getValue()).getNetworkStats());
        }
        return stats;
    }

    @Override
    public void addConnectionListener(ConnectionListener<ServerConnection> listener) {
        if (this.unifiedConnectionManager != null) {
            this.unifiedConnectionManager.addConnectionListener((ConnectionListener)listener);
        } else {
            this.connectionManagers.values().forEach(manager -> manager.addConnectionListener((ConnectionListener)listener));
        }
    }

    @Override
    public TcpServerConnectionManager getConnectionManager(EndpointQualifier qualifier) {
        if (this.unifiedConnectionManager != null) {
            return this.unifiedConnectionManager;
        }
        TcpServerConnectionManager connectionManager = (TcpServerConnectionManager)this.connectionManagers.get(qualifier);
        if (connectionManager == null) {
            this.logger.finest("An connection manager for qualifier " + qualifier + " was never registered.");
        }
        return connectionManager;
    }

    void scheduleDeferred(Runnable task, long delay, TimeUnit unit) {
        this.scheduler.schedule(task, delay, unit);
    }

    private void startAcceptor() {
        if (this.acceptorRef.get() != null) {
            this.logger.warning("TcpServerAcceptor is already running! Shutting down old acceptorRef...");
            this.shutdownAcceptor();
        }
        this.acceptorRef.set(new TcpServerAcceptor(this.registry, this, this.context).start());
    }

    private void shutdownAcceptor() {
        TcpServerAcceptor acceptor = this.acceptorRef.get();
        if (acceptor != null) {
            acceptor.shutdown();
            this.acceptorRef.set(null);
        }
    }

    private void closeServerSockets() {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Closing server socket channel: " + this.registry);
        }
        this.registry.destroy();
    }

    private final class MetricsProvider
    implements DynamicMetricsProvider {
        private MetricsProvider() {
        }

        @Override
        public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
            descriptor.withPrefix("tcp");
            context.collect(descriptor, this);
            TcpServerAcceptor acceptor = (TcpServerAcceptor)TcpServer.this.acceptorRef.get();
            if (acceptor != null) {
                acceptor.provideDynamicMetrics(descriptor.copy(), context);
            }
            if (TcpServer.this.unifiedConnectionManager != null) {
                TcpServer.this.unifiedConnectionManager.provideDynamicMetrics(descriptor.copy(), context);
            } else {
                TcpServer.this.connectionManagers.values().forEach(manager -> manager.provideDynamicMetrics(descriptor.copy(), context));
            }
        }
    }

    private final class RefreshNetworkStatsTask
    implements Runnable {
        private final EnumMap<ProtocolType, AtomicLong> bytesReceivedPerProtocol = new EnumMap(ProtocolType.class);
        private final EnumMap<ProtocolType, AtomicLong> bytesSentPerProtocol = new EnumMap(ProtocolType.class);

        RefreshNetworkStatsTask() {
            for (ProtocolType type : ProtocolType.valuesAsSet()) {
                this.bytesReceivedPerProtocol.put(type, new AtomicLong());
                this.bytesSentPerProtocol.put(type, new AtomicLong());
            }
        }

        void registerMetrics(MetricsRegistry metricsRegistry) {
            for (ProtocolType type : ProtocolType.valuesAsSet()) {
                metricsRegistry.registerStaticProbe(this, "tcp.bytesReceived." + type.name(), ProbeLevel.INFO, source -> this.bytesReceivedPerProtocol.get((Object)type).get());
                metricsRegistry.registerStaticProbe(this, "tcp.bytesSend." + type.name(), ProbeLevel.INFO, source -> this.bytesSentPerProtocol.get((Object)type).get());
            }
        }

        @Override
        public void run() {
            for (ProtocolType type : ProtocolType.valuesAsSet()) {
                long bytesReceived = 0L;
                long bytesSent = 0L;
                for (TcpServerConnectionManager connectionManager : TcpServer.this.connectionManagers.values()) {
                    connectionManager.refreshNetworkStats();
                    if (type != connectionManager.getEndpointQualifier().getType()) continue;
                    bytesReceived += connectionManager.getNetworkStats().getBytesReceived();
                    bytesSent += connectionManager.getNetworkStats().getBytesSent();
                }
                this.bytesReceivedPerProtocol.get((Object)type).lazySet(bytesReceived);
                this.bytesSentPerProtocol.get((Object)type).lazySet(bytesSent);
            }
        }
    }
}

