/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

public class ClientIcmpPingConfig {
    public static final int DEFAULT_TIMEOUT_MILLISECONDS = 1000;
    public static final int DEFAULT_INTERVAL_MILLISECONDS = 1000;
    public static final int DEFAULT_TTL = 255;
    public static final int DEFAULT_MAX_ATTEMPT = 2;
    private int timeoutMilliseconds = 1000;
    private int intervalMilliseconds = 1000;
    private boolean echoFailFastOnStartup = true;
    private int ttl = 255;
    private int maxAttempts = 2;
    private boolean enabled;

    public ClientIcmpPingConfig() {
    }

    public ClientIcmpPingConfig(ClientIcmpPingConfig config) {
        this.timeoutMilliseconds = config.timeoutMilliseconds;
        this.intervalMilliseconds = config.intervalMilliseconds;
        this.echoFailFastOnStartup = config.echoFailFastOnStartup;
        this.ttl = config.ttl;
        this.maxAttempts = config.maxAttempts;
        this.enabled = config.enabled;
    }

    public int getTimeoutMilliseconds() {
        return this.timeoutMilliseconds;
    }

    public ClientIcmpPingConfig setTimeoutMilliseconds(int timeoutMilliseconds) {
        this.timeoutMilliseconds = timeoutMilliseconds;
        return this;
    }

    public int getIntervalMilliseconds() {
        return this.intervalMilliseconds;
    }

    public ClientIcmpPingConfig setIntervalMilliseconds(int intervalMilliseconds) {
        this.intervalMilliseconds = intervalMilliseconds;
        return this;
    }

    public boolean isEchoFailFastOnStartup() {
        return this.echoFailFastOnStartup;
    }

    public ClientIcmpPingConfig setEchoFailFastOnStartup(boolean echoFailFastOnStartup) {
        this.echoFailFastOnStartup = echoFailFastOnStartup;
        return this;
    }

    public int getTtl() {
        return this.ttl;
    }

    public ClientIcmpPingConfig setTtl(int ttl) {
        this.ttl = ttl;
        return this;
    }

    public int getMaxAttempts() {
        return this.maxAttempts;
    }

    public ClientIcmpPingConfig setMaxAttempts(int maxAttempts) {
        this.maxAttempts = maxAttempts;
        return this;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ClientIcmpPingConfig setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientIcmpPingConfig that = (ClientIcmpPingConfig)o;
        if (this.timeoutMilliseconds != that.timeoutMilliseconds) {
            return false;
        }
        if (this.intervalMilliseconds != that.intervalMilliseconds) {
            return false;
        }
        if (this.echoFailFastOnStartup != that.echoFailFastOnStartup) {
            return false;
        }
        if (this.ttl != that.ttl) {
            return false;
        }
        if (this.maxAttempts != that.maxAttempts) {
            return false;
        }
        return this.enabled == that.enabled;
    }

    public int hashCode() {
        int result = this.timeoutMilliseconds;
        result = 31 * result + this.intervalMilliseconds;
        result = 31 * result + (this.echoFailFastOnStartup ? 1 : 0);
        result = 31 * result + this.ttl;
        result = 31 * result + this.maxAttempts;
        result = 31 * result + (this.enabled ? 1 : 0);
        return result;
    }

    public String toString() {
        return "ClientIcmpPingConfig{enabled=" + this.enabled + ", timeoutMilliseconds=" + this.timeoutMilliseconds + ", intervalMilliseconds=" + this.intervalMilliseconds + ", echoFailFastOnStartup=" + this.echoFailFastOnStartup + ", ttl=" + this.ttl + ", maxAttempts=" + this.maxAttempts + '}';
    }
}

