/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.config.SocketOptions;
import com.hazelcast.client.impl.ClientExtension;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.clientside.HazelcastClientManagedContext;
import com.hazelcast.client.impl.connection.tcp.ClientPlainChannelInitializer;
import com.hazelcast.client.impl.proxy.ClientMapProxy;
import com.hazelcast.client.impl.spi.ClientProxyFactory;
import com.hazelcast.client.map.impl.nearcache.NearCachedClientMapProxy;
import com.hazelcast.config.InstanceTrackingConfig;
import com.hazelcast.config.NearCacheConfig;
import com.hazelcast.config.SSLConfig;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.config.SocketInterceptorConfig;
import com.hazelcast.instance.BuildInfo;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.internal.memory.DefaultMemoryStats;
import com.hazelcast.internal.memory.MemoryStats;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.impl.DefaultNearCacheManager;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.nio.ClassLoaderUtil;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.serialization.impl.DefaultSerializationServiceBuilder;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.InstanceTrackingUtil;
import com.hazelcast.internal.util.JVMUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.nio.SocketInterceptor;
import com.hazelcast.partition.PartitioningStrategy;
import com.hazelcast.partition.strategy.DefaultPartitioningStrategy;
import com.hazelcast.spi.impl.executionservice.TaskScheduler;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.Map;

public class DefaultClientExtension
implements ClientExtension {
    protected static final ILogger LOGGER = Logger.getLogger(ClientExtension.class);
    protected volatile HazelcastClientInstanceImpl client;
    private final MemoryStats memoryStats = new DefaultMemoryStats();

    @Override
    public void beforeStart(HazelcastClientInstanceImpl client) {
        this.client = client;
    }

    @Override
    public void afterStart(HazelcastClientInstanceImpl client) {
    }

    @Override
    public void logInstanceTrackingMetadata() {
        InstanceTrackingConfig trackingConfig = this.client.getClientConfig().getInstanceTrackingConfig();
        if (trackingConfig.isEnabled()) {
            InstanceTrackingUtil.writeInstanceTrackingFile(trackingConfig.getFileName(), trackingConfig.getFormatPattern(), this.getTrackingFileProperties(BuildInfoProvider.getBuildInfo()), LOGGER);
        }
    }

    protected Map<String, Object> getTrackingFileProperties(BuildInfo buildInfo) {
        Map<String, Object> props = MapUtil.createHashMap(6);
        props.put(InstanceTrackingConfig.InstanceTrackingProperties.PRODUCT.getPropertyName(), (Object)InstanceTrackingConfig.InstanceProductName.HAZELCAST_CLIENT);
        props.put(InstanceTrackingConfig.InstanceTrackingProperties.VERSION.getPropertyName(), buildInfo.getVersion());
        props.put(InstanceTrackingConfig.InstanceTrackingProperties.MODE.getPropertyName(), InstanceTrackingConfig.InstanceMode.CLIENT.getModeName());
        props.put(InstanceTrackingConfig.InstanceTrackingProperties.START_TIMESTAMP.getPropertyName(), System.currentTimeMillis());
        props.put(InstanceTrackingConfig.InstanceTrackingProperties.LICENSED.getPropertyName(), 0);
        props.put(InstanceTrackingConfig.InstanceTrackingProperties.PID.getPropertyName(), JVMUtil.getPid());
        return props;
    }

    @Override
    public InternalSerializationService createSerializationService(byte version) {
        try {
            ClientConfig config = this.client.getClientConfig();
            ClassLoader configClassLoader = config.getClassLoader();
            HazelcastClientInstanceImpl hazelcastInstance = this.client;
            PartitioningStrategy partitioningStrategy = this.getPartitioningStrategy(configClassLoader);
            SerializationConfig serializationConfig = config.getSerializationConfig() != null ? config.getSerializationConfig() : new SerializationConfig();
            DefaultSerializationServiceBuilder builder = new DefaultSerializationServiceBuilder();
            if (version > 0) {
                builder.setVersion(version);
            }
            return (InternalSerializationService)builder.setClassLoader(configClassLoader).setConfig(serializationConfig).setManagedContext(new HazelcastClientManagedContext(this.client, config.getManagedContext())).setPartitioningStrategy(partitioningStrategy).setHazelcastInstance(hazelcastInstance).setNotActiveExceptionSupplier(HazelcastClientNotActiveException::new).build();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    protected PartitioningStrategy getPartitioningStrategy(ClassLoader configClassLoader) throws Exception {
        String partitioningStrategyClassName = ClusterProperty.PARTITIONING_STRATEGY_CLASS.getSystemProperty();
        if (partitioningStrategyClassName != null && partitioningStrategyClassName.length() > 0) {
            return (PartitioningStrategy)ClassLoaderUtil.newInstance(configClassLoader, partitioningStrategyClassName);
        }
        return new DefaultPartitioningStrategy();
    }

    @Override
    public SocketInterceptor createSocketInterceptor() {
        LOGGER.warning("SocketInterceptor feature is only available on Hazelcast Enterprise!");
        return null;
    }

    @Override
    public SocketInterceptor createSocketInterceptor(SocketInterceptorConfig socketInterceptorConfig) {
        if (socketInterceptorConfig != null && socketInterceptorConfig.isEnabled()) {
            LOGGER.warning("SocketInterceptor feature is only available on Hazelcast Enterprise!");
        }
        return null;
    }

    @Override
    public ChannelInitializer createChannelInitializer() {
        ClientNetworkConfig networkConfig = this.client.getClientConfig().getNetworkConfig();
        SSLConfig sslConfig = networkConfig.getSSLConfig();
        SocketOptions socketOptions = networkConfig.getSocketOptions();
        return this.createChannelInitializer(sslConfig, socketOptions);
    }

    @Override
    public ChannelInitializer createChannelInitializer(SSLConfig sslConfig, SocketOptions socketOptions) {
        if (sslConfig != null && sslConfig.isEnabled() && !BuildInfoProvider.getBuildInfo().isEnterprise()) {
            throw new IllegalStateException("SSL/TLS requires Hazelcast Enterprise Edition");
        }
        HazelcastProperties properties = this.client.getProperties();
        boolean directBuffer = properties.getBoolean(ClusterProperty.SOCKET_CLIENT_BUFFER_DIRECT);
        return new ClientPlainChannelInitializer(socketOptions, directBuffer);
    }

    @Override
    public <T> ClientProxyFactory createServiceProxyFactory(Class<T> service) {
        if (MapService.class.isAssignableFrom(service)) {
            return this.createClientMapProxyFactory();
        }
        throw new IllegalArgumentException("Proxy factory cannot be created. Unknown service: " + service);
    }

    @Override
    public MemoryStats getMemoryStats() {
        return this.memoryStats;
    }

    private ClientProxyFactory createClientMapProxyFactory() {
        return (id, context) -> {
            ClientConfig clientConfig = this.client.getClientConfig();
            NearCacheConfig nearCacheConfig = clientConfig.getNearCacheConfig(id);
            if (nearCacheConfig != null) {
                ConfigValidator.checkNearCacheConfig(id, nearCacheConfig, clientConfig.getNativeMemoryConfig(), true);
                return new NearCachedClientMapProxy("hz:impl:mapService", id, context);
            }
            return new ClientMapProxy("hz:impl:mapService", id, context);
        };
    }

    @Override
    public NearCacheManager createNearCacheManager() {
        InternalSerializationService ss = this.client.getSerializationService();
        TaskScheduler taskScheduler = this.client.getTaskScheduler();
        ClassLoader classLoader = this.client.getClientConfig().getClassLoader();
        HazelcastProperties properties = this.client.getProperties();
        return new DefaultNearCacheManager(ss, taskScheduler, classLoader, properties);
    }
}

