/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.expression.math.ExpressionMath;
import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.math.BigDecimal;

public final class FloatConverter
extends Converter {
    public static final FloatConverter INSTANCE = new FloatConverter();

    private FloatConverter() {
        super(7, QueryDataTypeFamily.REAL);
    }

    @Override
    public Class<?> getValueClass() {
        return Float.class;
    }

    @Override
    public byte asTinyint(Object val) {
        float casted = this.cast(val);
        if (!Float.isFinite(casted)) {
            throw this.cannotConvert(QueryDataTypeFamily.TINYINT, val);
        }
        byte converted = (byte)casted;
        if (converted != (int)casted) {
            throw this.numericOverflow(QueryDataTypeFamily.TINYINT, val);
        }
        return converted;
    }

    @Override
    public short asSmallint(Object val) {
        float casted = this.cast(val);
        if (!Float.isFinite(casted)) {
            throw this.cannotConvert(QueryDataTypeFamily.SMALLINT, val);
        }
        short converted = (short)casted;
        if (converted != (int)casted) {
            throw this.numericOverflow(QueryDataTypeFamily.SMALLINT, val);
        }
        return converted;
    }

    @Override
    public int asInt(Object val) {
        float casted = this.cast(val);
        if (!Float.isFinite(casted)) {
            throw this.cannotConvert(QueryDataTypeFamily.INTEGER, val);
        }
        int converted = (int)casted;
        if ((long)converted != (long)casted) {
            throw this.numericOverflow(QueryDataTypeFamily.INTEGER, val);
        }
        return converted;
    }

    @Override
    public long asBigint(Object val) {
        float casted = this.cast(val);
        if (!Float.isFinite(casted)) {
            throw this.cannotConvert(QueryDataTypeFamily.BIGINT, val);
        }
        float truncated = (float)((double)casted > 0.0 ? Math.floor(casted) : Math.ceil(casted));
        long converted = (long)truncated;
        if ((float)converted != truncated) {
            throw this.numericOverflow(QueryDataTypeFamily.BIGINT, val);
        }
        return converted;
    }

    @Override
    public BigDecimal asDecimal(Object val) {
        float val0 = this.cast(val);
        if (Float.isInfinite(val0)) {
            throw QueryException.dataException("Cannot convert infinite " + (Object)((Object)QueryDataTypeFamily.REAL) + " value to " + (Object)((Object)QueryDataTypeFamily.DECIMAL));
        }
        if (Float.isNaN(val0)) {
            throw QueryException.dataException("Cannot convert NaN " + (Object)((Object)QueryDataTypeFamily.REAL) + " value to " + (Object)((Object)QueryDataTypeFamily.DECIMAL));
        }
        return new BigDecimal(val0, ExpressionMath.DECIMAL_MATH_CONTEXT);
    }

    @Override
    public float asReal(Object val) {
        return this.cast(val);
    }

    @Override
    public double asDouble(Object val) {
        return this.cast(val);
    }

    @Override
    public String asVarchar(Object val) {
        return Float.toString(this.cast(val));
    }

    @Override
    public Object convertToSelf(Converter valConverter, Object val) {
        return Float.valueOf(valConverter.asReal(val));
    }

    private float cast(Object val) {
        return ((Float)val).floatValue();
    }
}

