/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.config;

import com.hazelcast.config.ConfigRecognizer;
import com.hazelcast.config.ConfigStream;
import com.hazelcast.internal.yaml.YamlException;
import com.hazelcast.internal.yaml.YamlLoader;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;

public abstract class AbstractYamlConfigRootTagRecognizer
implements ConfigRecognizer {
    private final String expectedRootNode;
    private final ILogger logger = Logger.getLogger(AbstractYamlConfigRootTagRecognizer.class);

    public AbstractYamlConfigRootTagRecognizer(String expectedRootNode) {
        this.expectedRootNode = expectedRootNode;
    }

    @Override
    public boolean isRecognized(ConfigStream configStream) {
        try {
            YamlLoader.load(configStream, this.expectedRootNode);
            return true;
        }
        catch (YamlException ex) {
            this.handleParseException(ex);
            return false;
        }
        catch (Exception ex) {
            this.handleUnexpectedException(ex);
            throw ex;
        }
    }

    private void handleParseException(YamlException ex) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("An exception is encountered while processing the provided YAML configuration", ex);
        }
    }

    private void handleUnexpectedException(Exception ex) {
        if (this.logger.isFineEnabled()) {
            this.logger.fine("An unexpected exception is encountered while processing the provided YAML configuration", ex);
        }
    }
}

