/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.portable;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.nio.BufferObjectDataInput;
import com.hazelcast.internal.nio.BufferObjectDataOutput;
import com.hazelcast.internal.serialization.impl.InternalGenericRecord;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.serialization.impl.portable.DefaultPortableReader;
import com.hazelcast.internal.serialization.impl.portable.DefaultPortableWriter;
import com.hazelcast.internal.serialization.impl.portable.MorphingPortableReader;
import com.hazelcast.internal.serialization.impl.portable.PortableContextImpl;
import com.hazelcast.internal.serialization.impl.portable.PortableGenericRecord;
import com.hazelcast.internal.serialization.impl.portable.PortableInternalGenericRecord;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.GenericRecord;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.StreamSerializer;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class PortableSerializer
implements StreamSerializer<Object> {
    private final PortableContextImpl context;
    private final Map<Integer, PortableFactory> factories = new HashMap<Integer, PortableFactory>();

    public PortableSerializer(PortableContextImpl context, Map<Integer, ? extends PortableFactory> portableFactories) {
        this.context = context;
        this.factories.putAll(portableFactories);
    }

    @Override
    public int getTypeId() {
        return -1;
    }

    @Override
    public void write(ObjectDataOutput out, Object o) throws IOException {
        if (o instanceof Portable) {
            Portable p = (Portable)o;
            if (!(out instanceof BufferObjectDataOutput)) {
                throw new IllegalArgumentException("ObjectDataOutput must be instance of BufferObjectDataOutput!");
            }
            if (p.getClassId() == 0) {
                throw new IllegalArgumentException("Portable class ID cannot be zero!");
            }
            out.writeInt(p.getFactoryId());
            out.writeInt(p.getClassId());
            this.writeInternal((BufferObjectDataOutput)out, p);
            return;
        }
        if (o instanceof PortableGenericRecord) {
            this.writePortableGenericRecord(out, (PortableGenericRecord)o);
            return;
        }
        throw new IllegalArgumentException("PortableSerializer can only write Portable and PortableGenericRecord");
    }

    void writeInternal(BufferObjectDataOutput out, Portable p) throws IOException {
        ClassDefinition cd = this.context.lookupOrRegisterClassDefinition(p);
        out.writeInt(cd.getVersion());
        DefaultPortableWriter writer = new DefaultPortableWriter(this, out, cd);
        p.writePortable(writer);
        writer.end();
    }

    @Override
    public Object read(ObjectDataInput in) throws IOException {
        if (!(in instanceof BufferObjectDataInput)) {
            throw new IllegalArgumentException("ObjectDataInput must be instance of BufferObjectDataInput!");
        }
        int factoryId = in.readInt();
        int classId = in.readInt();
        BufferObjectDataInput input = (BufferObjectDataInput)in;
        Portable portable = this.createNewPortableInstance(factoryId, classId);
        if (portable != null) {
            return this.readPortable(input, factoryId, classId, portable);
        }
        GenericRecord genericRecord = (GenericRecord)this.readPortableGenericRecord(input, factoryId, classId);
        assert (genericRecord instanceof PortableGenericRecord);
        return genericRecord;
    }

    private Portable readPortable(BufferObjectDataInput in, int factoryId, int classId, Portable portable) throws IOException {
        int writeVersion = in.readInt();
        int readVersion = this.findPortableVersion(factoryId, classId, portable);
        DefaultPortableReader reader = this.createReader(in, factoryId, classId, writeVersion, readVersion);
        portable.readPortable(reader);
        reader.end();
        return portable;
    }

    private int findPortableVersion(int factoryId, int classId, Portable portable) {
        int currentVersion = this.context.getClassVersion(factoryId, classId);
        if (currentVersion < 0 && (currentVersion = SerializationUtil.getPortableVersion(portable, this.context.getVersion())) > 0) {
            this.context.setClassVersion(factoryId, classId, currentVersion);
        }
        return currentVersion;
    }

    private Portable createNewPortableInstance(int factoryId, int classId) {
        PortableFactory portableFactory = this.factories.get(factoryId);
        if (portableFactory == null) {
            return null;
        }
        return portableFactory.create(classId);
    }

    public InternalGenericRecord readAsInternalGenericRecord(ObjectDataInput in) throws IOException {
        int factoryId = in.readInt();
        int classId = in.readInt();
        int version = in.readInt();
        BufferObjectDataInput input = (BufferObjectDataInput)in;
        ClassDefinition cd = this.setupPositionAndDefinition(input, factoryId, classId, version);
        return new PortableInternalGenericRecord(this, input, cd, true);
    }

    DefaultPortableReader createMorphingReader(BufferObjectDataInput in) throws IOException {
        int factoryId = in.readInt();
        int classId = in.readInt();
        int version = in.readInt();
        Portable portable = this.createNewPortableInstance(factoryId, classId);
        int portableVersion = this.findPortableVersion(factoryId, classId, portable);
        return this.createReader(in, factoryId, classId, version, portableVersion);
    }

    public ClassDefinition setupPositionAndDefinition(BufferObjectDataInput in, int factoryId, int classId, int version) throws IOException {
        ClassDefinition cd;
        int effectiveVersion = version;
        if (effectiveVersion < 0) {
            effectiveVersion = this.context.getVersion();
        }
        if ((cd = this.context.lookupClassDefinition(factoryId, classId, effectiveVersion)) == null) {
            int begin = in.position();
            cd = this.context.readClassDefinition(in, factoryId, classId, effectiveVersion);
            in.position(begin);
        }
        return cd;
    }

    public DefaultPortableReader createReader(BufferObjectDataInput in, int factoryId, int classId, int version, int portableVersion) throws IOException {
        ClassDefinition cd = this.setupPositionAndDefinition(in, factoryId, classId, version);
        DefaultPortableReader reader = portableVersion == cd.getVersion() ? new DefaultPortableReader(this, in, cd) : new MorphingPortableReader(this, in, cd);
        return reader;
    }

    @Override
    public void destroy() {
        this.factories.clear();
    }

    private void writePortableGenericRecord(ObjectDataOutput out, PortableGenericRecord record) throws IOException {
        ClassDefinition existingCd;
        ClassDefinition cd = record.getClassDefinition();
        if (this.context.shouldCheckClassDefinitionErrors() && (existingCd = this.context.lookupClassDefinition(cd.getFactoryId(), cd.getClassId(), cd.getVersion())) != null && !existingCd.equals(cd)) {
            throw new HazelcastSerializationException("Inconsistent class definition found. New class definition : " + cd + ", Existing class definition " + existingCd);
        }
        this.context.registerClassDefinition(cd);
        out.writeInt(cd.getFactoryId());
        out.writeInt(cd.getClassId());
        this.writePortableGenericRecordInternal(out, record);
    }

    void writePortableGenericRecordInternal(ObjectDataOutput out, PortableGenericRecord record) throws IOException {
        ClassDefinition cd = record.getClassDefinition();
        out.writeInt(cd.getVersion());
        BufferObjectDataOutput output = (BufferObjectDataOutput)out;
        DefaultPortableWriter writer = new DefaultPortableWriter(this, output, cd);
        Set<String> fieldNames = cd.getFieldNames();
        block22: for (String fieldName : fieldNames) {
            switch (cd.getFieldType(fieldName)) {
                case PORTABLE: {
                    writer.writeGenericRecord(fieldName, record.readGenericRecord(fieldName));
                    continue block22;
                }
                case BYTE: {
                    writer.writeByte(fieldName, record.readByte(fieldName));
                    continue block22;
                }
                case BOOLEAN: {
                    writer.writeBoolean(fieldName, record.readBoolean(fieldName));
                    continue block22;
                }
                case CHAR: {
                    writer.writeChar(fieldName, record.readChar(fieldName));
                    continue block22;
                }
                case SHORT: {
                    writer.writeShort(fieldName, record.readShort(fieldName));
                    continue block22;
                }
                case INT: {
                    writer.writeInt(fieldName, record.readInt(fieldName));
                    continue block22;
                }
                case LONG: {
                    writer.writeLong(fieldName, record.readLong(fieldName));
                    continue block22;
                }
                case FLOAT: {
                    writer.writeFloat(fieldName, record.readFloat(fieldName));
                    continue block22;
                }
                case DOUBLE: {
                    writer.writeDouble(fieldName, record.readDouble(fieldName));
                    continue block22;
                }
                case UTF: {
                    writer.writeUTF(fieldName, record.readUTF(fieldName));
                    continue block22;
                }
                case PORTABLE_ARRAY: {
                    writer.writeGenericRecordArray(fieldName, record.readGenericRecordArray(fieldName));
                    continue block22;
                }
                case BYTE_ARRAY: {
                    writer.writeByteArray(fieldName, record.readByteArray(fieldName));
                    continue block22;
                }
                case BOOLEAN_ARRAY: {
                    writer.writeBooleanArray(fieldName, record.readBooleanArray(fieldName));
                    continue block22;
                }
                case CHAR_ARRAY: {
                    writer.writeCharArray(fieldName, record.readCharArray(fieldName));
                    continue block22;
                }
                case SHORT_ARRAY: {
                    writer.writeShortArray(fieldName, record.readShortArray(fieldName));
                    continue block22;
                }
                case INT_ARRAY: {
                    writer.writeIntArray(fieldName, record.readIntArray(fieldName));
                    continue block22;
                }
                case LONG_ARRAY: {
                    writer.writeLongArray(fieldName, record.readLongArray(fieldName));
                    continue block22;
                }
                case FLOAT_ARRAY: {
                    writer.writeFloatArray(fieldName, record.readFloatArray(fieldName));
                    continue block22;
                }
                case DOUBLE_ARRAY: {
                    writer.writeDoubleArray(fieldName, record.readDoubleArray(fieldName));
                    continue block22;
                }
                case UTF_ARRAY: {
                    writer.writeUTFArray(fieldName, record.readUTFArray(fieldName));
                    continue block22;
                }
            }
            throw new IllegalStateException("Unexpected field type: " + (Object)((Object)cd.getFieldType(fieldName)));
        }
        writer.end();
    }

    <T> T readAsObject(BufferObjectDataInput in, int factoryId, int classId) throws IOException {
        Portable portable = this.createNewPortableInstance(factoryId, classId);
        if (portable == null) {
            throw new HazelcastSerializationException("Could not find PortableFactory for factory-id: " + factoryId + ", class-id:" + classId);
        }
        this.readPortable(in, factoryId, classId, portable);
        ManagedContext managedContext = this.context.getManagedContext();
        return (T)(managedContext != null ? managedContext.initialize(portable) : portable);
    }

    <T> T readAndInitialize(BufferObjectDataInput in, int factoryId, int classId, boolean readGenericLazy) throws IOException {
        if (readGenericLazy) {
            int version = in.readInt();
            ClassDefinition cd = this.setupPositionAndDefinition(in, factoryId, classId, version);
            PortableInternalGenericRecord reader = new PortableInternalGenericRecord(this, in, cd, true);
            return (T)reader;
        }
        return this.readPortableGenericRecord(in, factoryId, classId);
    }

    private <T> T readPortableGenericRecord(BufferObjectDataInput in, int factoryId, int classId) throws IOException {
        int version = in.readInt();
        ClassDefinition cd = this.setupPositionAndDefinition(in, factoryId, classId, version);
        PortableInternalGenericRecord reader = new PortableInternalGenericRecord(this, in, cd, false);
        GenericRecord.Builder genericRecordBuilder = GenericRecord.Builder.portable(cd);
        block22: for (String fieldName : cd.getFieldNames()) {
            switch (cd.getFieldType(fieldName)) {
                case PORTABLE: {
                    genericRecordBuilder.writeGenericRecord(fieldName, reader.readGenericRecord(fieldName));
                    continue block22;
                }
                case BYTE: {
                    genericRecordBuilder.writeByte(fieldName, reader.readByte(fieldName));
                    continue block22;
                }
                case BOOLEAN: {
                    genericRecordBuilder.writeBoolean(fieldName, reader.readBoolean(fieldName));
                    continue block22;
                }
                case CHAR: {
                    genericRecordBuilder.writeChar(fieldName, reader.readChar(fieldName));
                    continue block22;
                }
                case SHORT: {
                    genericRecordBuilder.writeShort(fieldName, reader.readShort(fieldName));
                    continue block22;
                }
                case INT: {
                    genericRecordBuilder.writeInt(fieldName, reader.readInt(fieldName));
                    continue block22;
                }
                case LONG: {
                    genericRecordBuilder.writeLong(fieldName, reader.readLong(fieldName));
                    continue block22;
                }
                case FLOAT: {
                    genericRecordBuilder.writeFloat(fieldName, reader.readFloat(fieldName));
                    continue block22;
                }
                case DOUBLE: {
                    genericRecordBuilder.writeDouble(fieldName, reader.readDouble(fieldName));
                    continue block22;
                }
                case UTF: {
                    genericRecordBuilder.writeUTF(fieldName, reader.readUTF(fieldName));
                    continue block22;
                }
                case PORTABLE_ARRAY: {
                    genericRecordBuilder.writeGenericRecordArray(fieldName, reader.readGenericRecordArray(fieldName));
                    continue block22;
                }
                case BYTE_ARRAY: {
                    genericRecordBuilder.writeByteArray(fieldName, reader.readByteArray(fieldName));
                    continue block22;
                }
                case BOOLEAN_ARRAY: {
                    genericRecordBuilder.writeBooleanArray(fieldName, reader.readBooleanArray(fieldName));
                    continue block22;
                }
                case CHAR_ARRAY: {
                    genericRecordBuilder.writeCharArray(fieldName, reader.readCharArray(fieldName));
                    continue block22;
                }
                case SHORT_ARRAY: {
                    genericRecordBuilder.writeShortArray(fieldName, reader.readShortArray(fieldName));
                    continue block22;
                }
                case INT_ARRAY: {
                    genericRecordBuilder.writeIntArray(fieldName, reader.readIntArray(fieldName));
                    continue block22;
                }
                case LONG_ARRAY: {
                    genericRecordBuilder.writeLongArray(fieldName, reader.readLongArray(fieldName));
                    continue block22;
                }
                case FLOAT_ARRAY: {
                    genericRecordBuilder.writeFloatArray(fieldName, reader.readFloatArray(fieldName));
                    continue block22;
                }
                case DOUBLE_ARRAY: {
                    genericRecordBuilder.writeDoubleArray(fieldName, reader.readDoubleArray(fieldName));
                    continue block22;
                }
                case UTF_ARRAY: {
                    genericRecordBuilder.writeUTFArray(fieldName, reader.readUTFArray(fieldName));
                    continue block22;
                }
            }
            throw new IllegalStateException("Unexpected value: " + (Object)((Object)cd.getFieldType(fieldName)));
        }
        return (T)genericRecordBuilder.build();
    }
}

