/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.operation;

import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import java.io.IOException;
import java.util.UUID;

public abstract class QueryOperation
implements IdentifiedDataSerializable {
    public static final int PARTITION_ANY = -1;
    private UUID callerId;

    protected QueryOperation() {
    }

    public UUID getCallerId() {
        return this.callerId;
    }

    public void setCallerId(UUID callerId) {
        this.callerId = callerId;
    }

    public int getPartition() {
        return -1;
    }

    protected static int getPartitionForHash(int hash) {
        if (hash == Integer.MIN_VALUE) {
            hash = Integer.MAX_VALUE;
        }
        return Math.abs(hash);
    }

    @Override
    public final int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public final void writeData(ObjectDataOutput out) throws IOException {
        UUIDSerializationUtil.writeUUID(out, this.callerId);
        this.writeInternal0(out);
    }

    @Override
    public final void readData(ObjectDataInput in) throws IOException {
        this.callerId = UUIDSerializationUtil.readUUID(in);
        this.readInternal0(in);
    }

    protected abstract void writeInternal0(ObjectDataOutput var1) throws IOException;

    protected abstract void readInternal0(ObjectDataInput var1) throws IOException;
}

