/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.impl.clientside.ClientLockReferenceIdGenerator;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MultiMapAddEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapAddEntryListenerToKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapClearCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapContainsEntryCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapContainsKeyCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapContainsValueCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapDeleteCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapEntrySetCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapForceUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapGetCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapIsLockedCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapKeySetCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapLockCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapPutCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapRemoveCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapRemoveEntryCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapRemoveEntryListenerCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapSizeCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapTryLockCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapUnlockCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapValueCountCodec;
import com.hazelcast.client.impl.protocol.codec.MultiMapValuesCodec;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.client.impl.spi.EventHandler;
import com.hazelcast.client.impl.spi.impl.ListenerMessageCodec;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryListener;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.map.AbstractIMapEvent;
import com.hazelcast.map.IMapEvent;
import com.hazelcast.map.MapEvent;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.map.impl.ListenerAdapter;
import com.hazelcast.map.impl.ListenerAdapters;
import com.hazelcast.multimap.LocalMultiMapStats;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.spi.impl.UnmodifiableLazyList;
import com.hazelcast.spi.impl.UnmodifiableLazySet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class ClientMultiMapProxy<K, V>
extends ClientProxy
implements MultiMap<K, V> {
    protected static final String NULL_KEY_IS_NOT_ALLOWED = "Null key is not allowed!";
    protected static final String NULL_VALUE_IS_NOT_ALLOWED = "Null value is not allowed!";
    protected static final String NULL_LISTENER_IS_NOT_ALLOWED = "Null listener is not allowed!";
    private ClientLockReferenceIdGenerator lockReferenceIdGenerator;

    public ClientMultiMapProxy(String serviceName, String name, ClientContext context) {
        super(serviceName, name, context);
    }

    @Override
    public boolean put(@Nonnull K key, @Nonnull V value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ClientMessage request = MultiMapPutCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapPutCodec.ResponseParameters resultParameters = MultiMapPutCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    @Nonnull
    public Collection<V> get(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapGetCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapGetCodec.ResponseParameters resultParameters = MultiMapGetCodec.decodeResponse(response);
        return new UnmodifiableLazyList(resultParameters.response, this.getSerializationService());
    }

    @Override
    public boolean remove(@Nonnull Object key, @Nonnull Object value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ClientMessage request = MultiMapRemoveEntryCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapRemoveEntryCodec.ResponseParameters resultParameters = MultiMapRemoveEntryCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    @Nonnull
    public Collection<V> remove(@Nonnull Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapRemoveCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapRemoveCodec.ResponseParameters resultParameters = MultiMapRemoveCodec.decodeResponse(response);
        return new UnmodifiableLazyList(resultParameters.response, this.getSerializationService());
    }

    @Override
    public void delete(@Nonnull Object key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapDeleteCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        this.invoke(request, keyData);
    }

    @Override
    @Nonnull
    public Set<K> localKeySet() {
        throw new UnsupportedOperationException("Locality for client is ambiguous");
    }

    @Override
    @Nonnull
    public Set<K> keySet() {
        ClientMessage request = MultiMapKeySetCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MultiMapKeySetCodec.ResponseParameters resultParameters = MultiMapKeySetCodec.decodeResponse(response);
        return new UnmodifiableLazySet(resultParameters.response, this.getSerializationService());
    }

    @Override
    @Nonnull
    public Collection<V> values() {
        ClientMessage request = MultiMapValuesCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MultiMapValuesCodec.ResponseParameters resultParameters = MultiMapValuesCodec.decodeResponse(response);
        return new UnmodifiableLazyList(resultParameters.response, this.getSerializationService());
    }

    @Override
    @Nonnull
    public Set<Map.Entry<K, V>> entrySet() {
        ClientMessage request = MultiMapEntrySetCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MultiMapEntrySetCodec.ResponseParameters resultParameters = MultiMapEntrySetCodec.decodeResponse(response);
        return new UnmodifiableLazySet(resultParameters.response, this.getSerializationService());
    }

    @Override
    public boolean containsKey(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapContainsKeyCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapContainsKeyCodec.ResponseParameters resultParameters = MultiMapContainsKeyCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean containsValue(@Nonnull Object value) {
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyValue = this.toData(value);
        ClientMessage request = MultiMapContainsValueCodec.encodeRequest(this.name, keyValue);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MultiMapContainsValueCodec.ResponseParameters resultParameters = MultiMapContainsValueCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean containsEntry(@Nonnull K key, @Nonnull V value) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(value, NULL_VALUE_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        Data valueData = this.toData(value);
        ClientMessage request = MultiMapContainsEntryCodec.encodeRequest(this.name, keyData, valueData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapContainsEntryCodec.ResponseParameters resultParameters = MultiMapContainsEntryCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public int size() {
        ClientMessage request = MultiMapSizeCodec.encodeRequest(this.name);
        ClientMessage response = (ClientMessage)this.invoke(request);
        MultiMapSizeCodec.ResponseParameters resultParameters = MultiMapSizeCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public void clear() {
        ClientMessage request = MultiMapClearCodec.encodeRequest(this.name);
        this.invoke(request);
    }

    @Override
    public int valueCount(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapValueCountCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapValueCountCodec.ResponseParameters resultParameters = MultiMapValueCountCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    @Nonnull
    public UUID addLocalEntryListener(@Nonnull EntryListener<K, V> listener) {
        throw new UnsupportedOperationException("Locality for client is ambiguous");
    }

    @Override
    @Nonnull
    public UUID addEntryListener(@Nonnull EntryListener<K, V> listener, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        ListenerAdapter listenerAdaptor = ListenerAdapters.createListenerAdapter(listener);
        ClientMultiMapEventHandler handler = new ClientMultiMapEventHandler(listenerAdaptor);
        return this.registerListener(this.createEntryListenerCodec(includeValue), handler);
    }

    private ListenerMessageCodec createEntryListenerCodec(final boolean includeValue) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MultiMapAddEntryListenerCodec.encodeRequest(ClientMultiMapProxy.this.name, includeValue, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return MultiMapAddEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return MultiMapRemoveEntryListenerCodec.encodeRequest(ClientMultiMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MultiMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public boolean removeEntryListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "Registration ID should not be null!");
        return this.deregisterListener(registrationId);
    }

    @Override
    @Nonnull
    public UUID addEntryListener(@Nonnull EntryListener<K, V> listener, @Nonnull K key, boolean includeValue) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ListenerAdapter listenerAdapter = ListenerAdapters.createListenerAdapter(listener);
        ClientMultiMapToKeyEventHandler handler = new ClientMultiMapToKeyEventHandler(listenerAdapter);
        return this.registerListener(this.createEntryListenerToKeyCodec(includeValue, keyData), handler);
    }

    private ListenerMessageCodec createEntryListenerToKeyCodec(final boolean includeValue, final Data keyData) {
        return new ListenerMessageCodec(){

            @Override
            public ClientMessage encodeAddRequest(boolean localOnly) {
                return MultiMapAddEntryListenerToKeyCodec.encodeRequest(ClientMultiMapProxy.this.name, keyData, includeValue, localOnly);
            }

            @Override
            public UUID decodeAddResponse(ClientMessage clientMessage) {
                return MultiMapAddEntryListenerToKeyCodec.decodeResponse((ClientMessage)clientMessage).response;
            }

            @Override
            public ClientMessage encodeRemoveRequest(UUID realRegistrationId) {
                return MultiMapRemoveEntryListenerCodec.encodeRequest(ClientMultiMapProxy.this.name, realRegistrationId);
            }

            @Override
            public boolean decodeRemoveResponse(ClientMessage clientMessage) {
                return MultiMapRemoveEntryListenerCodec.decodeResponse((ClientMessage)clientMessage).response;
            }
        };
    }

    @Override
    public void lock(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapLockCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId(), -1L, this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData);
    }

    @Override
    public void lock(@Nonnull K key, long leaseTime, @Nonnull TimeUnit timeUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Preconditions.checkNotNull(timeUnit, "Null timeUnit is not allowed!");
        Preconditions.checkPositive(leaseTime, "leaseTime should be positive");
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapLockCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId(), this.getTimeInMillis(leaseTime, timeUnit), this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData);
    }

    @Override
    public boolean isLocked(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapIsLockedCodec.encodeRequest(this.name, keyData);
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapIsLockedCodec.ResponseParameters resultParameters = MultiMapIsLockedCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public boolean tryLock(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        try {
            return this.tryLock(key, 0L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    @Override
    public boolean tryLock(@Nonnull K key, long time, @Nullable TimeUnit timeunit) throws InterruptedException {
        return this.tryLock(key, time, timeunit, Long.MAX_VALUE, null);
    }

    @Override
    public boolean tryLock(@Nonnull K key, long time, @Nullable TimeUnit timeunit, long leaseTime, @Nullable TimeUnit leaseUnit) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        long timeoutInMillis = this.getTimeInMillis(time, timeunit);
        long leaseTimeInMillis = this.getTimeInMillis(leaseTime, leaseUnit);
        long threadId = ThreadUtil.getThreadId();
        ClientMessage request = MultiMapTryLockCodec.encodeRequest(this.name, keyData, threadId, leaseTimeInMillis, timeoutInMillis, this.lockReferenceIdGenerator.getNextReferenceId());
        ClientMessage response = (ClientMessage)this.invoke(request, keyData);
        MultiMapTryLockCodec.ResponseParameters resultParameters = MultiMapTryLockCodec.decodeResponse(response);
        return resultParameters.response;
    }

    @Override
    public void unlock(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapUnlockCodec.encodeRequest(this.name, keyData, ThreadUtil.getThreadId(), this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData);
    }

    @Override
    public void forceUnlock(@Nonnull K key) {
        Preconditions.checkNotNull(key, NULL_KEY_IS_NOT_ALLOWED);
        Data keyData = this.toData(key);
        ClientMessage request = MultiMapForceUnlockCodec.encodeRequest(this.name, keyData, this.lockReferenceIdGenerator.getNextReferenceId());
        this.invoke(request, keyData);
    }

    @Override
    @Nonnull
    public LocalMultiMapStats getLocalMultiMapStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    public String toString() {
        return "MultiMap{name='" + this.name + '\'' + '}';
    }

    @Override
    protected void onDestroy() {
    }

    protected long getTimeInMillis(long time, TimeUnit timeunit) {
        return timeunit != null ? timeunit.toMillis(time) : time;
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        this.lockReferenceIdGenerator = this.getClient().getLockReferenceIdGenerator();
    }

    private abstract class AbstractClientMultiMapEventHandler
    implements EventHandler<ClientMessage> {
        private final ListenerAdapter listenerAdapter;

        AbstractClientMultiMapEventHandler(ListenerAdapter listenerAdapter) {
            this.listenerAdapter = listenerAdapter;
        }

        public void handleEntryEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, UUID uuid, int numberOfAffectedEntries) {
            Member member = ClientMultiMapProxy.this.getContext().getClusterService().getMember(uuid);
            IMapEvent iMapEvent = this.createIMapEvent(key, value, oldValue, mergingValue, eventType, numberOfAffectedEntries, member);
            this.listenerAdapter.onEvent(iMapEvent);
        }

        private IMapEvent createIMapEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, int numberOfAffectedEntries, Member member) {
            AbstractIMapEvent iMapEvent;
            EntryEventType entryEventType = EntryEventType.getByType(eventType);
            switch (entryEventType) {
                case ADDED: 
                case REMOVED: 
                case UPDATED: 
                case EVICTED: 
                case MERGED: {
                    iMapEvent = this.createEntryEvent(key, value, oldValue, mergingValue, eventType, member);
                    break;
                }
                case EVICT_ALL: 
                case CLEAR_ALL: {
                    iMapEvent = this.createMapEvent(eventType, numberOfAffectedEntries, member);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Not a known event type " + (Object)((Object)entryEventType));
                }
            }
            return iMapEvent;
        }

        private MapEvent createMapEvent(int eventType, int numberOfAffectedEntries, Member member) {
            return new MapEvent(ClientMultiMapProxy.this.name, member, eventType, numberOfAffectedEntries);
        }

        private EntryEvent<K, V> createEntryEvent(Data keyData, Data valueData, Data oldValueData, Data mergingValueData, int eventType, Member member) {
            return new DataAwareEntryEvent(member, eventType, ClientMultiMapProxy.this.name, keyData, valueData, oldValueData, mergingValueData, ClientMultiMapProxy.this.getSerializationService());
        }
    }

    private class ClientMultiMapToKeyEventHandler
    extends AbstractClientMultiMapEventHandler {
        private MultiMapAddEntryListenerToKeyCodec.AbstractEventHandler handler;

        ClientMultiMapToKeyEventHandler(ListenerAdapter listenerAdapter) {
            super(listenerAdapter);
            this.handler = new MultiMapAddEntryListenerToKeyCodec.AbstractEventHandler(){

                @Override
                public void handleEntryEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, UUID uuid, int numberOfAffectedEntries) {
                    ClientMultiMapToKeyEventHandler.super.handleEntryEvent(key, value, oldValue, mergingValue, eventType, uuid, numberOfAffectedEntries);
                }
            };
        }

        @Override
        public void handle(ClientMessage clientMessage) {
            this.handler.handle(clientMessage);
        }
    }

    private class ClientMultiMapEventHandler
    extends AbstractClientMultiMapEventHandler {
        private MultiMapAddEntryListenerCodec.AbstractEventHandler handler;

        ClientMultiMapEventHandler(ListenerAdapter listenerAdapter) {
            super(listenerAdapter);
            this.handler = new MultiMapAddEntryListenerCodec.AbstractEventHandler(){

                @Override
                public void handleEntryEvent(Data key, Data value, Data oldValue, Data mergingValue, int eventType, UUID uuid, int numberOfAffectedEntries) {
                    ClientMultiMapEventHandler.this.handleEntryEvent(key, value, oldValue, mergingValue, eventType, uuid, numberOfAffectedEntries);
                }
            };
        }

        @Override
        public void handle(ClientMessage event) {
            this.handler.handle(event);
        }
    }
}

