/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.apache.camel.spi.Resource;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.function.ThrowingSupplier;

public class DefaultResource
implements Resource {
    private final String location;
    private final ThrowingSupplier<InputStream, IOException> inputStreamSupplier;

    public DefaultResource(String location, ThrowingSupplier<InputStream, IOException> inputStreamSupplier) {
        this.location = (String)ObjectHelper.notNull((Object)location, (String)"location");
        this.inputStreamSupplier = (ThrowingSupplier)ObjectHelper.notNull(inputStreamSupplier, (String)"inputStreamSupplier");
    }

    public String getLocation() {
        return this.location;
    }

    public InputStream getInputStream() throws IOException {
        return (InputStream)this.inputStreamSupplier.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)o;
        return this.getLocation().equals(resource.getLocation());
    }

    public int hashCode() {
        return Objects.hash(this.getLocation());
    }

    public String toString() {
        return "DefaultResource{location='" + this.location + '\'' + '}';
    }
}

