/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.server.tcp;

import com.hazelcast.internal.networking.HandlerStatus;
import com.hazelcast.internal.networking.OutboundHandler;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.server.ServerConnection;
import com.hazelcast.internal.server.tcp.TcpServerConnection;
import com.hazelcast.internal.util.StringUtil;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.nio.ByteBuffer;

public class MemberProtocolEncoder
extends OutboundHandler<Void, ByteBuffer> {
    private final OutboundHandler[] outboundHandlers;
    private volatile boolean mustWriteProtocol;
    private boolean clusterProtocolBuffered;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public MemberProtocolEncoder(OutboundHandler[] next) {
        this.outboundHandlers = next;
    }

    @Override
    public void handlerAdded() {
        this.initDstBuffer(3);
        if (this.channel.isClientMode()) {
            this.mustWriteProtocol = true;
        }
    }

    @Override
    public HandlerStatus onWrite() {
        IOUtil.compactOrClear((ByteBuffer)this.dst);
        try {
            if (!this.mustWriteProtocol) {
                HandlerStatus handlerStatus = HandlerStatus.CLEAN;
                return handlerStatus;
            }
            if (!this.clusterProtocolBuffered) {
                this.clusterProtocolBuffered = true;
                ((ByteBuffer)this.dst).put(StringUtil.stringToBytes("HZC"));
                HandlerStatus handlerStatus = HandlerStatus.DIRTY;
                return handlerStatus;
            }
            if (!this.isProtocolBufferDrained()) {
                HandlerStatus handlerStatus = HandlerStatus.DIRTY;
                return handlerStatus;
            }
            TcpServerConnection connection = (TcpServerConnection)this.channel.attributeMap().get(ServerConnection.class);
            connection.setConnectionType("MEMBER");
            this.channel.outboundPipeline().replace(this, this.outboundHandlers);
            HandlerStatus handlerStatus = HandlerStatus.CLEAN;
            return handlerStatus;
        }
        finally {
            ((ByteBuffer)this.dst).flip();
        }
    }

    public void signalProtocolLoaded() {
        assert (!this.channel.isClientMode()) : "Signal protocol should only be made on channel in serverMode";
        this.mustWriteProtocol = true;
        this.channel.outboundPipeline().wakeup();
    }

    private boolean isProtocolBufferDrained() {
        return ((ByteBuffer)this.dst).position() == 0;
    }
}

