/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache.invalidation;

import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.eventservice.EventFilter;
import java.io.IOException;
import java.util.UUID;

public class UuidFilter
implements EventFilter,
IdentifiedDataSerializable {
    private UUID uuid;

    public UuidFilter() {
    }

    public UuidFilter(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public boolean eval(Object suppliedUuid) {
        assert (suppliedUuid instanceof UUID);
        return this.uuid.equals(suppliedUuid);
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        UUIDSerializationUtil.writeUUID(out, this.uuid);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.uuid = UUIDSerializationUtil.readUUID(in);
    }

    public String toString() {
        return "UuidFilter{uuid='" + this.uuid + '\'' + '}';
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 100;
    }
}

