/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.managementcenter;

import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricTarget;
import com.hazelcast.internal.metrics.MetricsPublisher;
import com.hazelcast.internal.metrics.impl.MetricsCompressor;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import java.util.function.ObjLongConsumer;
import javax.annotation.Nonnull;

public class ManagementCenterPublisher
implements MetricsPublisher {
    private final ILogger logger;
    private final ObjLongConsumer<byte[]> consumer;
    private final MetricsCompressor compressor;

    public ManagementCenterPublisher(@Nonnull LoggingService loggingService, @Nonnull ObjLongConsumer<byte[]> writeFn) {
        this.consumer = writeFn;
        this.logger = loggingService.getLogger(this.getClass());
        this.compressor = new MetricsCompressor();
    }

    @Override
    public String name() {
        return "Management Center Publisher";
    }

    @Override
    public void publishLong(MetricDescriptor descriptor, long value) {
        if (descriptor.isTargetIncluded(MetricTarget.MANAGEMENT_CENTER)) {
            this.compressor.addLong(descriptor, value);
        }
    }

    @Override
    public void publishDouble(MetricDescriptor descriptor, double value) {
        if (descriptor.isTargetIncluded(MetricTarget.MANAGEMENT_CENTER)) {
            this.compressor.addDouble(descriptor, value);
        }
    }

    @Override
    public void whenComplete() {
        int count = this.compressor.count();
        byte[] blob = this.compressor.getBlobAndReset();
        this.consumer.accept(blob, System.currentTimeMillis());
        this.logger.finest(String.format("Collected %,d metrics, %,d bytes", count, blob.length));
    }

    public int getCount() {
        return this.compressor.count();
    }
}

