/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.plan.node;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.sql.impl.SqlDataSerializerHook;
import com.hazelcast.sql.impl.expression.Expression;
import com.hazelcast.sql.impl.plan.node.PlanNode;
import com.hazelcast.sql.impl.plan.node.PlanNodeVisitor;
import com.hazelcast.sql.impl.plan.node.UniInputPlanNode;
import java.io.IOException;
import java.util.Objects;

public class FetchPlanNode
extends UniInputPlanNode
implements IdentifiedDataSerializable {
    private Expression fetch;
    private Expression offset;

    public FetchPlanNode() {
    }

    public FetchPlanNode(int id, PlanNode upstream, Expression fetch, Expression offset) {
        super(id, upstream);
        this.fetch = fetch;
        this.offset = offset;
    }

    public Expression getFetch() {
        return this.fetch;
    }

    public Expression getOffset() {
        return this.offset;
    }

    @Override
    public void visit0(PlanNodeVisitor visitor) {
        visitor.onFetchNode(this);
    }

    @Override
    public void writeData1(ObjectDataOutput out) throws IOException {
        out.writeObject(this.fetch);
        out.writeObject(this.offset);
    }

    @Override
    public void readData1(ObjectDataInput in) throws IOException {
        this.fetch = (Expression)in.readObject();
        this.offset = (Expression)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return SqlDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 63;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.fetch, this.offset, this.upstream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FetchPlanNode that = (FetchPlanNode)o;
        return this.id == that.id && Objects.equals(this.fetch, that.fetch) && Objects.equals(this.offset, that.offset) && this.upstream.equals(that.upstream);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.id + ", fetch=" + this.fetch + ", offset=" + this.offset + ", upstream=" + this.upstream + '}';
    }
}

