/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.proxyservice.impl.operations;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.SpiDataSerializerHook;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.proxyservice.impl.ProxyServiceImpl;
import java.io.IOException;

public class DistributedObjectDestroyOperation
extends Operation
implements IdentifiedDataSerializable {
    private String serviceName;
    private String name;

    public DistributedObjectDestroyOperation() {
    }

    public DistributedObjectDestroyOperation(String serviceName, String name) {
        this.serviceName = serviceName;
        this.name = name;
    }

    @Override
    public void run() throws Exception {
        ProxyServiceImpl proxyService = (ProxyServiceImpl)this.getNodeEngine().getService("hz:core:proxyService");
        proxyService.destroyLocalDistributedObject(this.serviceName, this.name, this.getCallerUuid(), false);
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.serviceName);
        out.writeUTF(this.name);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.serviceName = in.readUTF();
        this.name = in.readUTF();
    }

    @Override
    public int getFactoryId() {
        return SpiDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 15;
    }
}

