/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.internal.serialization.impl.AbstractCollectionStreamSerializer;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Comparator;
import java.util.Set;
import java.util.TreeSet;

public class TreeSetStreamSerializer<E>
extends AbstractCollectionStreamSerializer<Set<E>> {
    @Override
    public int getTypeId() {
        return -38;
    }

    @Override
    @SuppressFBWarnings(value={"BC_BAD_CAST_TO_CONCRETE_COLLECTION"}, justification="The map is guaranteed to be of type TreeSet when this nethod is called.")
    public void write(ObjectDataOutput out, Set<E> collection) throws IOException {
        out.writeObject(((TreeSet)collection).comparator());
        super.write(out, collection);
    }

    @Override
    public Set<E> read(ObjectDataInput in) throws IOException {
        Comparator comparator = (Comparator)in.readObject();
        TreeSet collection = new TreeSet(comparator);
        int size = in.readInt();
        return this.deserializeEntries(in, size, collection);
    }
}

