/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cluster.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.impl.AbstractMember;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.version.MemberVersion;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;

public final class MemberImpl
extends AbstractMember
implements Member,
HazelcastInstanceAware,
IdentifiedDataSerializable {
    public static final int NA_MEMBER_LIST_JOIN_VERSION = -1;
    private boolean localMember;
    private volatile int memberListJoinVersion = -1;
    private volatile HazelcastInstanceImpl instance;
    private volatile ILogger logger;

    public MemberImpl() {
    }

    public MemberImpl(Address address, MemberVersion version, boolean localMember) {
        this(Collections.singletonMap(EndpointQualifier.MEMBER, address), version, localMember, null, null, false, -1, null);
    }

    public MemberImpl(Address address, MemberVersion version, boolean localMember, UUID uuid) {
        this(Collections.singletonMap(EndpointQualifier.MEMBER, address), version, localMember, uuid, null, false, -1, null);
    }

    public MemberImpl(MemberImpl member) {
        super(member);
        this.localMember = member.localMember;
        this.memberListJoinVersion = member.memberListJoinVersion;
        this.instance = member.instance;
    }

    private MemberImpl(Map<EndpointQualifier, Address> addresses, MemberVersion version, boolean localMember, UUID uuid, Map<String, String> attributes, boolean liteMember, int memberListJoinVersion, HazelcastInstanceImpl instance) {
        super(addresses, version, uuid, attributes, liteMember);
        this.memberListJoinVersion = memberListJoinVersion;
        this.localMember = localMember;
        this.instance = instance;
    }

    @Override
    protected ILogger getLogger() {
        return this.logger;
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        if (hazelcastInstance instanceof HazelcastInstanceImpl) {
            this.instance = (HazelcastInstanceImpl)hazelcastInstance;
            this.localMember = this.instance.node.address.equals(this.address);
            this.logger = this.instance.node.getLogger(this.getClass().getName());
        }
    }

    @Override
    public boolean localMember() {
        return this.localMember;
    }

    @Override
    public String getAttribute(String key) {
        return (String)this.attributes.get(key);
    }

    public void setMemberListJoinVersion(int memberListJoinVersion) {
        this.memberListJoinVersion = memberListJoinVersion;
    }

    public int getMemberListJoinVersion() {
        return this.memberListJoinVersion;
    }

    private void ensureLocalMember() {
        if (!this.localMember) {
            throw new UnsupportedOperationException("Attributes on remote members must not be changed");
        }
    }

    public void setAttribute(String key, String value) {
        this.ensureLocalMember();
        if (this.instance != null && this.instance.node.clusterService.isJoined()) {
            throw new UnsupportedOperationException("Attributes can not be changed after instance has started");
        }
        Preconditions.isNotNull(key, "key");
        Preconditions.isNotNull(value, "value");
        this.attributes.put(key, value);
    }

    @Override
    public int getFactoryId() {
        return 0;
    }

    @Override
    public int getClassId() {
        return 2;
    }

    public static class Builder {
        private final Map<EndpointQualifier, Address> addressMap;
        private Map<String, String> attributes;
        private boolean localMember;
        private UUID uuid;
        private boolean liteMember;
        private MemberVersion version;
        private int memberListJoinVersion = -1;
        private HazelcastInstanceImpl instance;

        public Builder(Address address) {
            Preconditions.isNotNull(address, "address");
            this.addressMap = Collections.singletonMap(EndpointQualifier.MEMBER, address);
        }

        public Builder(Map<EndpointQualifier, Address> addresses) {
            Preconditions.isNotNull(addresses, "addresses");
            Preconditions.isNotNull(addresses.get(EndpointQualifier.MEMBER), "addresses.get(MEMBER)");
            this.addressMap = addresses;
        }

        public Builder localMember(boolean localMember) {
            this.localMember = localMember;
            return this;
        }

        public Builder version(MemberVersion memberVersion) {
            this.version = memberVersion;
            return this;
        }

        public Builder uuid(UUID uuid) {
            this.uuid = uuid;
            return this;
        }

        public Builder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder memberListJoinVersion(int memberListJoinVersion) {
            this.memberListJoinVersion = memberListJoinVersion;
            return this;
        }

        public Builder liteMember(boolean liteMember) {
            this.liteMember = liteMember;
            return this;
        }

        public Builder instance(HazelcastInstanceImpl hazelcastInstanceImpl) {
            this.instance = hazelcastInstanceImpl;
            return this;
        }

        public MemberImpl build() {
            return new MemberImpl(this.addressMap, this.version, this.localMember, this.uuid, this.attributes, this.liteMember, this.memberListJoinVersion, this.instance);
        }
    }
}

