/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.CustomTypeFactory;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.config.MerkleTreeConfig;

public final class MerkleTreeConfigCodec {
    private static final int ENABLED_FIELD_OFFSET = 0;
    private static final int DEPTH_FIELD_OFFSET = 1;
    private static final int INITIAL_FRAME_SIZE = 5;

    private MerkleTreeConfigCodec() {
    }

    public static void encode(ClientMessage clientMessage, MerkleTreeConfig merkleTreeConfig) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[5]);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 0, merkleTreeConfig.isEnabled());
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 1, merkleTreeConfig.getDepth());
        clientMessage.add(initialFrame);
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static MerkleTreeConfig decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        boolean enabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 0);
        int depth = FixedSizeTypesCodec.decodeInt(initialFrame.content, 1);
        CodecUtil.fastForwardToEndFrame(iterator);
        return CustomTypeFactory.createMerkleTreeConfig(enabled, depth);
    }
}

