/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public final class ListIntegerCodec {
    private ListIntegerCodec() {
    }

    public static void encode(ClientMessage clientMessage, Collection<Integer> collection) {
        int itemCount = collection.size();
        ClientMessage.Frame frame = new ClientMessage.Frame(new byte[itemCount * 4]);
        Iterator<Integer> iterator = collection.iterator();
        for (int i = 0; i < itemCount; ++i) {
            FixedSizeTypesCodec.encodeInteger(frame.content, i * 4, iterator.next());
        }
        clientMessage.add(frame);
    }

    public static List<Integer> decode(ClientMessage.ForwardFrameIterator iterator) {
        return ListIntegerCodec.decode(iterator.next());
    }

    public static List<Integer> decode(ClientMessage.Frame frame) {
        int itemCount = frame.content == null ? 0 : frame.content.length / 4;
        ArrayList<Integer> result = new ArrayList<Integer>(itemCount);
        for (int i = 0; i < itemCount; ++i) {
            result.add(FixedSizeTypesCodec.decodeInteger(frame.content, i * 4));
        }
        return result;
    }
}

