/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config.impl;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.XmlClientConfigBuilder;
import com.hazelcast.client.config.impl.ClientFailoverConfigSections;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.internal.config.AbstractDomConfigProcessor;
import com.hazelcast.internal.config.DomConfigHelper;
import java.io.IOException;
import org.w3c.dom.Node;

public class ClientFailoverDomConfigProcessor
extends AbstractDomConfigProcessor {
    protected final ClientFailoverConfig clientFailoverConfig;

    public ClientFailoverDomConfigProcessor(boolean domLevel3, ClientFailoverConfig clientFailoverConfig) {
        super(domLevel3);
        this.clientFailoverConfig = clientFailoverConfig;
    }

    @Override
    public void buildConfig(Node rootNode) {
        for (Node node : DomConfigHelper.childElements(rootNode)) {
            String nodeName = DomConfigHelper.cleanNodeName(node);
            if (this.occurrenceSet.contains(nodeName)) {
                throw new InvalidConfigurationException("Duplicate '" + nodeName + "' definition found in the configuration");
            }
            this.handleNode(node, nodeName);
            if (ClientFailoverConfigSections.canOccurMultipleTimes(nodeName)) continue;
            this.occurrenceSet.add(nodeName);
        }
    }

    private void handleNode(Node node, String nodeName) {
        if (ClientFailoverConfigSections.CLIENTS.isEqual(nodeName)) {
            this.handleClients(node);
        } else if (ClientFailoverConfigSections.TRY_COUNT.isEqual(nodeName)) {
            this.handleTryCount(node);
        }
    }

    protected void handleClients(Node node) {
        for (Node child : DomConfigHelper.childElements(node)) {
            if (!"client".equals(DomConfigHelper.cleanNodeName(child))) continue;
            String clientPath = this.getTextContent(child);
            try {
                ClientConfig config = new XmlClientConfigBuilder(clientPath).build();
                this.clientFailoverConfig.addClientConfig(config);
            }
            catch (IOException e) {
                throw new InvalidConfigurationException("Could not create the config from given path : " + clientPath, e);
            }
        }
    }

    private void handleTryCount(Node node) {
        int tryCount = Integer.parseInt(this.getTextContent(node));
        this.clientFailoverConfig.setTryCount(tryCount);
    }
}

