/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.config;

import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.impl.ClientFailoverConfigSections;
import com.hazelcast.client.config.impl.ClientFailoverDomConfigProcessor;
import com.hazelcast.client.config.impl.XmlClientFailoverConfigLocator;
import com.hazelcast.config.AbstractXmlConfigBuilder;
import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.internal.config.ConfigLoader;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.spi.annotation.PrivateApi;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XmlClientFailoverConfigBuilder
extends AbstractXmlConfigBuilder {
    private static final ILogger LOGGER = Logger.getLogger(XmlClientFailoverConfigBuilder.class);
    private final InputStream in;

    public XmlClientFailoverConfigBuilder(String resource) throws IOException {
        URL url = ConfigLoader.locateConfig(resource);
        Preconditions.checkTrue(url != null, "Could not load " + resource);
        this.in = url.openStream();
    }

    public XmlClientFailoverConfigBuilder(File file) throws IOException {
        Preconditions.checkNotNull(file, "File is null!");
        this.in = new FileInputStream(file);
    }

    public XmlClientFailoverConfigBuilder(URL url) throws IOException {
        Preconditions.checkNotNull(url, "URL is null!");
        this.in = url.openStream();
    }

    public XmlClientFailoverConfigBuilder(InputStream in) {
        this.in = in;
    }

    public XmlClientFailoverConfigBuilder() {
        this((XmlClientFailoverConfigLocator)null);
    }

    @PrivateApi
    public XmlClientFailoverConfigBuilder(XmlClientFailoverConfigLocator locator) {
        boolean located;
        if (locator == null) {
            locator = new XmlClientFailoverConfigLocator();
            locator.locateEverywhere();
        }
        if (!(located = locator.isConfigPresent())) {
            throw new HazelcastException("Failed to load ClientFailoverConfig");
        }
        this.in = locator.getIn();
    }

    @Override
    protected Document parse(InputStream inputStream) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        try {
            Document document = builder.parse(inputStream);
            return document;
        }
        catch (Exception e) {
            String msg = "Failed to parse Failover Config Stream" + StringUtil.LINE_SEPARATOR + "Exception: " + e.getMessage() + StringUtil.LINE_SEPARATOR + "HazelcastClient startup interrupted.";
            LOGGER.severe(msg);
            throw new InvalidConfigurationException(e.getMessage(), e);
        }
        finally {
            IOUtil.closeResource(inputStream);
        }
    }

    @Override
    protected AbstractXmlConfigBuilder.ConfigType getConfigType() {
        return AbstractXmlConfigBuilder.ConfigType.CLIENT_FAILOVER;
    }

    public ClientFailoverConfig build() {
        return this.build(new ClientFailoverConfig());
    }

    public ClientFailoverConfig build(ClientFailoverConfig clientFailoverConfig) {
        try {
            this.parseAndBuildConfig(clientFailoverConfig);
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        finally {
            IOUtil.closeResource(this.in);
        }
        return clientFailoverConfig;
    }

    private void parseAndBuildConfig(ClientFailoverConfig clientFailoverConfig) throws Exception {
        Document doc = this.parse(this.in);
        Element root = doc.getDocumentElement();
        this.checkRootElement(root);
        try {
            root.getTextContent();
        }
        catch (Throwable e) {
            this.domLevel3 = false;
        }
        this.process(root);
        this.schemaValidation(root.getOwnerDocument());
        new ClientFailoverDomConfigProcessor(this.domLevel3, clientFailoverConfig).buildConfig(root);
    }

    private void checkRootElement(Element root) {
        String rootNodeName = root.getNodeName();
        if (!ClientFailoverConfigSections.CLIENT_FAILOVER.isEqual(rootNodeName)) {
            throw new InvalidConfigurationException("Invalid root element in xml configuration! Expected: <hazelcast-client-failover>, Actual: <" + rootNodeName + ">.");
        }
    }

    public XmlClientFailoverConfigBuilder setProperties(Properties properties) {
        this.setPropertiesInternal(properties);
        return this;
    }
}

