/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.operation.CacheOperation;
import com.hazelcast.cache.impl.operation.CachePutAllBackupOperation;
import com.hazelcast.cache.impl.operation.MutableOperation;
import com.hazelcast.cache.impl.record.CacheRecord;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupAwareOperation;
import com.hazelcast.spi.impl.operationservice.MutatingOperation;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.cache.expiry.ExpiryPolicy;

public class CachePutAllOperation
extends CacheOperation
implements BackupAwareOperation,
MutableOperation,
MutatingOperation {
    private List<Map.Entry<Data, Data>> entries;
    private ExpiryPolicy expiryPolicy;
    private int completionId;
    private transient Map<Data, CacheRecord> backupRecords;

    public CachePutAllOperation() {
    }

    public CachePutAllOperation(String cacheNameWithPrefix, List<Map.Entry<Data, Data>> entries, ExpiryPolicy expiryPolicy, int completionId) {
        super(cacheNameWithPrefix);
        this.entries = entries;
        this.expiryPolicy = expiryPolicy;
        this.completionId = completionId;
    }

    @Override
    public int getCompletionId() {
        return this.completionId;
    }

    @Override
    public void setCompletionId(int completionId) {
        this.completionId = completionId;
    }

    @Override
    public void run() throws Exception {
        UUID callerUuid = this.getCallerUuid();
        this.backupRecords = MapUtil.createHashMap(this.entries.size());
        for (Map.Entry<Data, Data> entry : this.entries) {
            Data value;
            Data key = entry.getKey();
            CacheRecord backupRecord = this.recordStore.put(key, value = entry.getValue(), this.expiryPolicy, callerUuid, this.completionId);
            if (backupRecord == null) continue;
            this.backupRecords.put(key, backupRecord);
            this.publishWanUpdate(key, backupRecord);
        }
    }

    @Override
    public boolean shouldBackup() {
        return !this.backupRecords.isEmpty();
    }

    @Override
    public Operation getBackupOperation() {
        return new CachePutAllBackupOperation(this.name, this.backupRecords);
    }

    @Override
    public int getClassId() {
        return 36;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.expiryPolicy);
        out.writeInt(this.completionId);
        out.writeInt(this.entries.size());
        for (Map.Entry<Data, Data> entry : this.entries) {
            IOUtil.writeData(out, entry.getKey());
            IOUtil.writeData(out, entry.getValue());
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.expiryPolicy = (ExpiryPolicy)in.readObject();
        this.completionId = in.readInt();
        int size = in.readInt();
        this.entries = new ArrayList<Map.Entry<Data, Data>>(size);
        for (int i = 0; i < size; ++i) {
            Data key = IOUtil.readData(in);
            Data value = IOUtil.readData(in);
            this.entries.add(new AbstractMap.SimpleImmutableEntry<Data, Data>(key, value));
        }
    }
}

