/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.AggregationStrategy;
import org.apache.camel.BeanScope;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Expression;
import org.apache.camel.LoggingLevel;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.DataFormatClause;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.EnrichClause;
import org.apache.camel.builder.ExpressionBuilder;
import org.apache.camel.builder.ExpressionClause;
import org.apache.camel.builder.ProcessClause;
import org.apache.camel.model.AdviceWithDefinition;
import org.apache.camel.model.AggregateDefinition;
import org.apache.camel.model.BeanDefinition;
import org.apache.camel.model.Block;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.CircuitBreakerDefinition;
import org.apache.camel.model.ClaimCheckDefinition;
import org.apache.camel.model.ClaimCheckOperation;
import org.apache.camel.model.ConvertBodyDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.DelayDefinition;
import org.apache.camel.model.DescriptionDefinition;
import org.apache.camel.model.DynamicRouterDefinition;
import org.apache.camel.model.EnrichDefinition;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.ExpressionNodeHelper;
import org.apache.camel.model.FilterDefinition;
import org.apache.camel.model.IdempotentConsumerDefinition;
import org.apache.camel.model.LoadBalanceDefinition;
import org.apache.camel.model.LogDefinition;
import org.apache.camel.model.LoopDefinition;
import org.apache.camel.model.MarshalDefinition;
import org.apache.camel.model.MulticastDefinition;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.OptionalIdentifiedDefinition;
import org.apache.camel.model.OtherwiseDefinition;
import org.apache.camel.model.OutputNode;
import org.apache.camel.model.PipelineDefinition;
import org.apache.camel.model.PolicyDefinition;
import org.apache.camel.model.PollEnrichDefinition;
import org.apache.camel.model.ProcessDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.RecipientListDefinition;
import org.apache.camel.model.RemoveHeaderDefinition;
import org.apache.camel.model.RemoveHeadersDefinition;
import org.apache.camel.model.RemovePropertiesDefinition;
import org.apache.camel.model.RemovePropertyDefinition;
import org.apache.camel.model.ResequenceDefinition;
import org.apache.camel.model.RollbackDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RoutingSlipDefinition;
import org.apache.camel.model.SagaDefinition;
import org.apache.camel.model.SamplingDefinition;
import org.apache.camel.model.ScriptDefinition;
import org.apache.camel.model.SetBodyDefinition;
import org.apache.camel.model.SetExchangePatternDefinition;
import org.apache.camel.model.SetHeaderDefinition;
import org.apache.camel.model.SetPropertyDefinition;
import org.apache.camel.model.SortDefinition;
import org.apache.camel.model.SplitDefinition;
import org.apache.camel.model.StepDefinition;
import org.apache.camel.model.StopDefinition;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.camel.model.ThrottleDefinition;
import org.apache.camel.model.ThrowExceptionDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.ToDynamicDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.apache.camel.model.TransformDefinition;
import org.apache.camel.model.TryDefinition;
import org.apache.camel.model.UnmarshalDefinition;
import org.apache.camel.model.ValidateDefinition;
import org.apache.camel.model.WhenDefinition;
import org.apache.camel.model.WireTapDefinition;
import org.apache.camel.model.cloud.ServiceCallDefinition;
import org.apache.camel.model.dataformat.CustomDataFormat;
import org.apache.camel.model.language.ConstantExpression;
import org.apache.camel.model.language.ExpressionDefinition;
import org.apache.camel.model.language.LanguageExpression;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.processor.loadbalancer.LoadBalancer;
import org.apache.camel.spi.AsEndpointUri;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.IdempotentRepository;
import org.apache.camel.spi.InterceptStrategy;
import org.apache.camel.spi.Policy;
import org.apache.camel.support.ExpressionAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlAccessorType(value=XmlAccessType.FIELD)
public abstract class ProcessorDefinition<Type extends ProcessorDefinition<Type>>
extends OptionalIdentifiedDefinition<Type>
implements Block {
    @XmlTransient
    private static final AtomicInteger COUNTER = new AtomicInteger();
    @XmlTransient
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    @XmlAttribute
    protected Boolean inheritErrorHandler;
    @XmlTransient
    private final LinkedList<Block> blocks = new LinkedList();
    @XmlTransient
    private ProcessorDefinition<?> parent;
    @XmlTransient
    private final List<InterceptStrategy> interceptStrategies = new ArrayList<InterceptStrategy>();
    @XmlTransient
    private final int index = COUNTER.getAndIncrement();

    protected ProcessorDefinition() {
    }

    private static <T extends ExpressionNode> ExpressionClause<T> createAndSetExpression(T result) {
        ExpressionClause<T> clause = new ExpressionClause<T>(result);
        result.setExpression(clause);
        return clause;
    }

    public int getIndex() {
        return this.index;
    }

    public abstract List<ProcessorDefinition<?>> getOutputs();

    public boolean isTopLevelOnly() {
        return false;
    }

    public boolean isAbstract() {
        return false;
    }

    public boolean isWrappingEntireOutput() {
        return false;
    }

    @Override
    public void addOutput(ProcessorDefinition<?> output) {
        boolean parentIsRoute;
        if (!(this instanceof OutputNode)) {
            this.getParent().addOutput(output);
            return;
        }
        if (!this.blocks.isEmpty()) {
            Block block = this.blocks.getLast();
            block.addOutput(output);
            return;
        }
        boolean bl = parentIsRoute = RouteDefinition.class.isAssignableFrom(this.getClass()) || AdviceWithDefinition.class.isAssignableFrom(this.getClass());
        if (output.isTopLevelOnly() && !parentIsRoute) {
            throw new IllegalArgumentException("The output must be added as top-level on the route. Try moving " + output + " to the top of route.");
        }
        output.setParent(this);
        this.configureChild(output);
        this.getOutputs().add(output);
    }

    public void clearOutput() {
        this.getOutputs().clear();
        this.blocks.clear();
    }

    public void preCreateProcessor() {
    }

    public void configureChild(ProcessorDefinition<?> output) {
    }

    public Type to(@AsEndpointUri String uri) {
        this.addOutput(new ToDefinition(uri));
        return this.asType();
    }

    public ToDynamicDefinition toD() {
        ToDynamicDefinition answer = new ToDynamicDefinition();
        this.addOutput(answer);
        return answer;
    }

    public Type toD(@AsEndpointUri String uri) {
        ToDynamicDefinition answer = new ToDynamicDefinition();
        answer.setUri(uri);
        this.addOutput(answer);
        return this.asType();
    }

    public Type toD(@AsEndpointUri EndpointProducerBuilder endpointProducerBuilder) {
        ToDynamicDefinition answer = new ToDynamicDefinition();
        answer.setEndpointProducerBuilder(endpointProducerBuilder);
        this.addOutput(answer);
        return this.asType();
    }

    public Type toD(@AsEndpointUri String uri, int cacheSize) {
        ToDynamicDefinition answer = new ToDynamicDefinition();
        answer.setUri(uri);
        answer.setCacheSize(Integer.toString(cacheSize));
        this.addOutput(answer);
        return this.asType();
    }

    public Type toD(@AsEndpointUri EndpointProducerBuilder endpointProducerBuilder, int cacheSize) {
        ToDynamicDefinition answer = new ToDynamicDefinition();
        answer.setEndpointProducerBuilder(endpointProducerBuilder);
        answer.setCacheSize(Integer.toString(cacheSize));
        this.addOutput(answer);
        return this.asType();
    }

    public Type toD(@AsEndpointUri String uri, boolean ignoreInvalidEndpoint) {
        ToDynamicDefinition answer = new ToDynamicDefinition();
        answer.setUri(uri);
        answer.setIgnoreInvalidEndpoint(Boolean.toString(ignoreInvalidEndpoint));
        this.addOutput(answer);
        return this.asType();
    }

    public Type toD(@AsEndpointUri EndpointProducerBuilder endpointProducerBuilder, boolean ignoreInvalidEndpoint) {
        ToDynamicDefinition answer = new ToDynamicDefinition();
        answer.setEndpointProducerBuilder(endpointProducerBuilder);
        answer.setIgnoreInvalidEndpoint(Boolean.toString(ignoreInvalidEndpoint));
        this.addOutput(answer);
        return this.asType();
    }

    public Type toF(@AsEndpointUri String uri, Object ... args) {
        this.addOutput(new ToDefinition(String.format(uri, args)));
        return this.asType();
    }

    public ServiceCallDefinition serviceCall() {
        ServiceCallDefinition answer = new ServiceCallDefinition();
        this.addOutput(answer);
        return answer;
    }

    public Type serviceCall(String name) {
        ServiceCallDefinition answer = new ServiceCallDefinition();
        answer.setName(name);
        this.addOutput(answer);
        return this.asType();
    }

    public Type serviceCall(String name, @AsEndpointUri String uri) {
        ServiceCallDefinition answer = new ServiceCallDefinition();
        answer.setName(name);
        answer.setUri(uri);
        this.addOutput(answer);
        return this.asType();
    }

    public Type to(Endpoint endpoint) {
        this.addOutput(new ToDefinition(endpoint));
        return this.asType();
    }

    public Type to(@AsEndpointUri EndpointProducerBuilder endpoint) {
        this.addOutput(new ToDefinition(endpoint));
        return this.asType();
    }

    public Type to(ExchangePattern pattern, @AsEndpointUri String uri) {
        this.addOutput(new ToDefinition(uri, pattern));
        return this.asType();
    }

    public Type to(ExchangePattern pattern, Endpoint endpoint) {
        this.addOutput(new ToDefinition(endpoint, pattern));
        return this.asType();
    }

    public Type to(ExchangePattern pattern, EndpointProducerBuilder endpoint) {
        this.addOutput(new ToDefinition(endpoint, pattern));
        return this.asType();
    }

    public Type to(String ... uris) {
        for (String uri : uris) {
            this.addOutput(new ToDefinition(uri));
        }
        return this.asType();
    }

    public Type to(Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint));
        }
        return this.asType();
    }

    @Deprecated
    public Type to(Iterable<Endpoint> endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint));
        }
        return this.asType();
    }

    public Type to(EndpointProducerBuilder ... endpoints) {
        for (EndpointProducerBuilder endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint));
        }
        return this.asType();
    }

    public Type to(ExchangePattern pattern, String ... uris) {
        for (String uri : uris) {
            this.addOutput(new ToDefinition(uri, pattern));
        }
        return this.asType();
    }

    public Type to(ExchangePattern pattern, Endpoint ... endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint, pattern));
        }
        return this.asType();
    }

    @Deprecated
    public Type to(ExchangePattern pattern, Iterable<Endpoint> endpoints) {
        for (Endpoint endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint, pattern));
        }
        return this.asType();
    }

    public Type to(ExchangePattern pattern, EndpointProducerBuilder ... endpoints) {
        for (EndpointProducerBuilder endpoint : endpoints) {
            this.addOutput(new ToDefinition(endpoint, pattern));
        }
        return this.asType();
    }

    public Type setExchangePattern(ExchangePattern exchangePattern) {
        this.addOutput(new SetExchangePatternDefinition(exchangePattern));
        return this.asType();
    }

    @Deprecated
    public Type inOnly(@AsEndpointUri String uri) {
        return this.to(ExchangePattern.InOnly, uri);
    }

    @Deprecated
    public Type inOnly(Endpoint endpoint) {
        return this.to(ExchangePattern.InOnly, endpoint);
    }

    @Deprecated
    public Type inOnly(String ... uris) {
        return this.to(ExchangePattern.InOnly, uris);
    }

    @Deprecated
    public Type inOnly(Endpoint ... endpoints) {
        return this.to(ExchangePattern.InOnly, endpoints);
    }

    @Deprecated
    public Type inOnly(Iterable<Endpoint> endpoints) {
        return this.to(ExchangePattern.InOnly, endpoints);
    }

    @Deprecated
    public Type inOut(@AsEndpointUri String uri) {
        return this.to(ExchangePattern.InOut, uri);
    }

    @Deprecated
    public Type inOut(Endpoint endpoint) {
        return this.to(ExchangePattern.InOut, endpoint);
    }

    @Deprecated
    public Type inOut(String ... uris) {
        return this.to(ExchangePattern.InOut, uris);
    }

    @Deprecated
    public Type inOut(Endpoint ... endpoints) {
        return this.to(ExchangePattern.InOut, endpoints);
    }

    @Deprecated
    public Type inOut(Iterable<Endpoint> endpoints) {
        return this.to(ExchangePattern.InOut, endpoints);
    }

    @Override
    public Type id(String id) {
        if (this instanceof OutputNode && this.getOutputs().isEmpty()) {
            this.setId(id);
        } else {
            ProcessorDefinition block;
            List<ProcessorDefinition<?>> outputs = this.getOutputs();
            if (!this.blocks.isEmpty() && this.blocks.getLast() instanceof ProcessorDefinition && !(block = (ProcessorDefinition)this.blocks.getLast()).getOutputs().isEmpty()) {
                outputs = block.getOutputs();
            }
            if (!this.getOutputs().isEmpty()) {
                outputs.get(outputs.size() - 1).setId(id);
            } else {
                this.setId(id);
            }
        }
        return this.asType();
    }

    public Type routeId(String id) {
        ProcessorDefinition def = this;
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(def);
        if (route != null) {
            if (route.hasCustomIdAssigned()) {
                throw new IllegalArgumentException("You can only set routeId one time per route.");
            }
            route.setId(id);
        }
        return this.asType();
    }

    public Type routeGroup(String group) {
        ProcessorDefinition def = this;
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(def);
        if (route != null) {
            route.setGroup(group);
        }
        return this.asType();
    }

    public Type routeDescription(String description) {
        ProcessorDefinition def = this;
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(def);
        if (route != null) {
            DescriptionDefinition desc = new DescriptionDefinition();
            desc.setText(description);
            route.setDescription(desc);
        }
        return this.asType();
    }

    public MulticastDefinition multicast() {
        MulticastDefinition answer = new MulticastDefinition();
        this.addOutput(answer);
        return answer;
    }

    public MulticastDefinition multicast(AggregationStrategy aggregationStrategy, boolean parallelProcessing) {
        MulticastDefinition answer = new MulticastDefinition();
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        answer.setParallelProcessing(Boolean.toString(parallelProcessing));
        return answer;
    }

    public MulticastDefinition multicast(AggregationStrategy aggregationStrategy) {
        MulticastDefinition answer = new MulticastDefinition();
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        return answer;
    }

    public StepDefinition step() {
        StepDefinition answer = new StepDefinition();
        this.addOutput(answer);
        return answer;
    }

    public StepDefinition step(String id) {
        StepDefinition answer = new StepDefinition();
        answer.setId(id);
        this.addOutput(answer);
        return answer;
    }

    public PipelineDefinition pipeline() {
        PipelineDefinition answer = new PipelineDefinition();
        this.addOutput(answer);
        return answer;
    }

    public Type pipeline(String ... uris) {
        PipelineDefinition answer = new PipelineDefinition();
        this.addOutput(answer);
        answer.to(uris);
        return this.asType();
    }

    public Type pipeline(Endpoint ... endpoints) {
        PipelineDefinition answer = new PipelineDefinition();
        this.addOutput(answer);
        answer.to(endpoints);
        return this.asType();
    }

    @Deprecated
    public Type pipeline(Collection<Endpoint> endpoints) {
        PipelineDefinition answer = new PipelineDefinition();
        for (Endpoint endpoint : endpoints) {
            answer.addOutput(new ToDefinition(endpoint));
        }
        this.addOutput(answer);
        return this.asType();
    }

    public ThreadsDefinition threads() {
        ThreadsDefinition answer = new ThreadsDefinition();
        this.addOutput(answer);
        return answer;
    }

    public ThreadsDefinition threads(int poolSize) {
        ThreadsDefinition answer = new ThreadsDefinition();
        answer.setPoolSize(Integer.toString(poolSize));
        this.addOutput(answer);
        return answer;
    }

    public ThreadsDefinition threads(int poolSize, int maxPoolSize) {
        ThreadsDefinition answer = new ThreadsDefinition();
        answer.setPoolSize(Integer.toString(poolSize));
        answer.setMaxPoolSize(Integer.toString(maxPoolSize));
        this.addOutput(answer);
        return answer;
    }

    public ThreadsDefinition threads(int poolSize, int maxPoolSize, String threadName) {
        ThreadsDefinition answer = new ThreadsDefinition();
        answer.setPoolSize(Integer.toString(poolSize));
        answer.setMaxPoolSize(Integer.toString(maxPoolSize));
        answer.setThreadName(threadName);
        this.addOutput(answer);
        return answer;
    }

    public ProcessorDefinition<?> end() {
        ProcessorDefinition defn = this;
        if (defn instanceof TryDefinition || defn instanceof ChoiceDefinition) {
            this.popBlock();
        }
        if (this.blocks.isEmpty()) {
            if (this.parent == null) {
                return this.endParent();
            }
            return this.parent.endParent();
        }
        this.popBlock();
        return this.endParent();
    }

    public ProcessorDefinition<?> endParent() {
        return this;
    }

    public ChoiceDefinition endChoice() {
        ProcessorDefinition<?> def = this;
        if (def.getParent() instanceof WhenDefinition) {
            return (ChoiceDefinition)def.getParent().getParent();
        }
        if (def instanceof ChoiceDefinition) {
            return (ChoiceDefinition)def;
        }
        def = this.end();
        if (def instanceof WhenDefinition) {
            return (ChoiceDefinition)def.getParent();
        }
        if (def instanceof OtherwiseDefinition) {
            return (ChoiceDefinition)def.getParent();
        }
        return (ChoiceDefinition)def;
    }

    public RestDefinition endRest() {
        ProcessorDefinition def = this;
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(def);
        if (route != null) {
            return route.getRestDefinition();
        }
        throw new IllegalArgumentException("Cannot find RouteDefinition to allow endRest");
    }

    public TryDefinition endDoTry() {
        ProcessorDefinition<?> def = this;
        if (def instanceof TryDefinition) {
            return (TryDefinition)def;
        }
        def = this.end();
        return (TryDefinition)def;
    }

    public CircuitBreakerDefinition endCircuitBreaker() {
        ProcessorDefinition<?> def = this;
        if (def instanceof CircuitBreakerDefinition) {
            return (CircuitBreakerDefinition)def;
        }
        def = this.end();
        return (CircuitBreakerDefinition)def;
    }

    public ExpressionClause<IdempotentConsumerDefinition> idempotentConsumer() {
        IdempotentConsumerDefinition answer = new IdempotentConsumerDefinition();
        this.addOutput(answer);
        return ProcessorDefinition.createAndSetExpression(answer);
    }

    public IdempotentConsumerDefinition idempotentConsumer(Expression messageIdExpression) {
        IdempotentConsumerDefinition answer = new IdempotentConsumerDefinition();
        answer.setExpression(ExpressionNodeHelper.toExpressionDefinition(messageIdExpression));
        this.addOutput(answer);
        return answer;
    }

    public IdempotentConsumerDefinition idempotentConsumer(Expression messageIdExpression, IdempotentRepository idempotentRepository) {
        IdempotentConsumerDefinition answer = new IdempotentConsumerDefinition(messageIdExpression, idempotentRepository);
        this.addOutput(answer);
        return answer;
    }

    @AsPredicate
    public ExpressionClause<? extends FilterDefinition> filter() {
        FilterDefinition filter = new FilterDefinition();
        this.addOutput(filter);
        return ProcessorDefinition.createAndSetExpression(filter);
    }

    public FilterDefinition filter(@AsPredicate Predicate predicate) {
        FilterDefinition filter = new FilterDefinition(predicate);
        this.addOutput(filter);
        return filter;
    }

    public FilterDefinition filter(@AsPredicate ExpressionDefinition expression) {
        FilterDefinition filter = new FilterDefinition(expression);
        this.addOutput(filter);
        return filter;
    }

    public FilterDefinition filter(String language, @AsPredicate String expression) {
        return this.filter(new LanguageExpression(language, expression));
    }

    public ValidateDefinition validate(@AsPredicate Expression expression) {
        ValidateDefinition answer = new ValidateDefinition(expression);
        this.addOutput(answer);
        return answer;
    }

    public ValidateDefinition validate(@AsPredicate Predicate predicate) {
        ValidateDefinition answer = new ValidateDefinition(predicate);
        this.addOutput(answer);
        return answer;
    }

    @AsPredicate
    public ExpressionClause<ValidateDefinition> validate() {
        ValidateDefinition answer = new ValidateDefinition();
        this.addOutput(answer);
        return ProcessorDefinition.createAndSetExpression(answer);
    }

    public CircuitBreakerDefinition circuitBreaker() {
        CircuitBreakerDefinition answer = new CircuitBreakerDefinition();
        this.addOutput(answer);
        return answer;
    }

    public LoadBalanceDefinition loadBalance() {
        LoadBalanceDefinition answer = new LoadBalanceDefinition();
        this.addOutput(answer);
        return answer;
    }

    public LoadBalanceDefinition loadBalance(LoadBalancer loadBalancer) {
        LoadBalanceDefinition answer = new LoadBalanceDefinition();
        this.addOutput(answer);
        return answer.loadBalance(loadBalancer);
    }

    public Type log(String message) {
        LogDefinition answer = new LogDefinition(message);
        this.addOutput(answer);
        return this.asType();
    }

    public Type log(LoggingLevel loggingLevel, String message) {
        LogDefinition answer = new LogDefinition(message);
        answer.setLoggingLevel(loggingLevel.name());
        this.addOutput(answer);
        return this.asType();
    }

    public Type log(LoggingLevel loggingLevel, String logName, String message) {
        LogDefinition answer = new LogDefinition(message);
        answer.setLoggingLevel(loggingLevel.name());
        answer.setLogName(logName);
        this.addOutput(answer);
        return this.asType();
    }

    public Type log(LoggingLevel loggingLevel, Logger logger, String message) {
        LogDefinition answer = new LogDefinition(message);
        answer.setLoggingLevel(loggingLevel.name());
        answer.setLogger(logger);
        this.addOutput(answer);
        return this.asType();
    }

    public Type log(LoggingLevel loggingLevel, String logName, String marker, String message) {
        LogDefinition answer = new LogDefinition(message);
        answer.setLoggingLevel(loggingLevel.name());
        answer.setLogName(logName);
        answer.setMarker(marker);
        this.addOutput(answer);
        return this.asType();
    }

    public Type log(LoggingLevel loggingLevel, Logger logger, String marker, String message) {
        LogDefinition answer = new LogDefinition(message);
        answer.setLoggingLevel(loggingLevel.name());
        answer.setLogger(logger);
        answer.setMarker(marker);
        this.addOutput(answer);
        return this.asType();
    }

    public ChoiceDefinition choice() {
        ChoiceDefinition answer = new ChoiceDefinition();
        this.addOutput(answer);
        return answer;
    }

    public TryDefinition doTry() {
        TryDefinition answer = new TryDefinition();
        this.addOutput(answer);
        return answer;
    }

    public RecipientListDefinition<Type> recipientList(@AsEndpointUri Expression recipients) {
        RecipientListDefinition answer = new RecipientListDefinition(recipients);
        this.addOutput(answer);
        return answer;
    }

    public RecipientListDefinition<Type> recipientList(@AsEndpointUri Expression recipients, String delimiter) {
        RecipientListDefinition answer = new RecipientListDefinition(recipients);
        answer.setDelimiter(delimiter);
        this.addOutput(answer);
        return answer;
    }

    @AsEndpointUri
    public ExpressionClause<RecipientListDefinition<Type>> recipientList(String delimiter) {
        RecipientListDefinition answer = new RecipientListDefinition();
        answer.setDelimiter(delimiter);
        this.addOutput(answer);
        return ProcessorDefinition.createAndSetExpression(answer);
    }

    @AsEndpointUri
    public ExpressionClause<RecipientListDefinition<Type>> recipientList() {
        RecipientListDefinition answer = new RecipientListDefinition();
        this.addOutput(answer);
        return ProcessorDefinition.createAndSetExpression(answer);
    }

    public RoutingSlipDefinition<Type> routingSlip(@AsEndpointUri Expression expression, String uriDelimiter) {
        RoutingSlipDefinition answer = new RoutingSlipDefinition(expression, uriDelimiter);
        this.addOutput(answer);
        return answer;
    }

    public RoutingSlipDefinition<Type> routingSlip(@AsEndpointUri Expression expression) {
        RoutingSlipDefinition answer = new RoutingSlipDefinition(expression);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<RoutingSlipDefinition<Type>> routingSlip() {
        RoutingSlipDefinition answer = new RoutingSlipDefinition();
        this.addOutput(answer);
        return ProcessorDefinition.createAndSetExpression(answer);
    }

    public DynamicRouterDefinition<Type> dynamicRouter(@AsEndpointUri Expression expression) {
        DynamicRouterDefinition answer = new DynamicRouterDefinition(expression);
        this.addOutput(answer);
        return answer;
    }

    @AsEndpointUri
    public ExpressionClause<DynamicRouterDefinition<Type>> dynamicRouter() {
        DynamicRouterDefinition answer = new DynamicRouterDefinition();
        this.addOutput(answer);
        return ProcessorDefinition.createAndSetExpression(answer);
    }

    public SamplingDefinition sample() {
        return this.sample(1L, TimeUnit.SECONDS);
    }

    public SamplingDefinition sample(long samplePeriod, TimeUnit unit) {
        SamplingDefinition answer = new SamplingDefinition(samplePeriod, unit);
        this.addOutput(answer);
        return answer;
    }

    public SamplingDefinition sample(long messageFrequency) {
        SamplingDefinition answer = new SamplingDefinition(messageFrequency);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<SplitDefinition> split() {
        SplitDefinition answer = new SplitDefinition();
        this.addOutput(answer);
        return ProcessorDefinition.createAndSetExpression(answer);
    }

    public SplitDefinition split(Expression expression) {
        SplitDefinition answer = new SplitDefinition(expression);
        this.addOutput(answer);
        return answer;
    }

    public SplitDefinition split(Expression expression, AggregationStrategy aggregationStrategy) {
        SplitDefinition answer = new SplitDefinition(expression);
        this.addOutput(answer);
        answer.setAggregationStrategy(aggregationStrategy);
        return answer;
    }

    public ExpressionClause<ResequenceDefinition> resequence() {
        ResequenceDefinition answer = new ResequenceDefinition();
        ExpressionClause<ResequenceDefinition> clause = new ExpressionClause<ResequenceDefinition>(answer);
        answer.setExpression(clause);
        this.addOutput(answer);
        return clause;
    }

    public ResequenceDefinition resequence(Expression expression) {
        ResequenceDefinition answer = new ResequenceDefinition(expression);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<AggregateDefinition> aggregate() {
        AggregateDefinition answer = new AggregateDefinition();
        ExpressionClause<AggregateDefinition> clause = new ExpressionClause<AggregateDefinition>(answer);
        answer.setExpression(clause);
        this.addOutput(answer);
        return clause;
    }

    public ExpressionClause<AggregateDefinition> aggregate(AggregationStrategy aggregationStrategy) {
        AggregateDefinition answer = new AggregateDefinition();
        ExpressionClause<AggregateDefinition> clause = new ExpressionClause<AggregateDefinition>(answer);
        answer.setExpression(clause);
        answer.setAggregationStrategy(aggregationStrategy);
        this.addOutput(answer);
        return clause;
    }

    public AggregateDefinition aggregate(Expression correlationExpression) {
        AggregateDefinition answer = new AggregateDefinition(correlationExpression);
        this.addOutput(answer);
        return answer;
    }

    public AggregateDefinition aggregate(Expression correlationExpression, AggregationStrategy aggregationStrategy) {
        AggregateDefinition answer = new AggregateDefinition(correlationExpression, aggregationStrategy);
        this.addOutput(answer);
        return answer;
    }

    public DelayDefinition delay(Expression delay) {
        DelayDefinition answer = new DelayDefinition(delay);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<DelayDefinition> delay() {
        DelayDefinition answer = new DelayDefinition();
        this.addOutput(answer);
        return ProcessorDefinition.createAndSetExpression(answer);
    }

    public DelayDefinition delay(long delay) {
        return this.delay(ExpressionBuilder.constantExpression((Object)delay));
    }

    public ExpressionClause<ThrottleDefinition> throttle() {
        ThrottleDefinition answer = new ThrottleDefinition();
        this.addOutput(answer);
        return ProcessorDefinition.createAndSetExpression(answer);
    }

    public ThrottleDefinition throttle(long maximumRequestCount) {
        return this.throttle(ExpressionBuilder.constantExpression((Object)maximumRequestCount));
    }

    public ThrottleDefinition throttle(Expression maximumRequestCount) {
        ThrottleDefinition answer = new ThrottleDefinition(maximumRequestCount);
        this.addOutput(answer);
        return answer;
    }

    public ThrottleDefinition throttle(Expression maximumRequestCount, long correlationExpressionKey) {
        ThrottleDefinition answer = new ThrottleDefinition(maximumRequestCount, ExpressionBuilder.constantExpression((Object)correlationExpressionKey));
        this.addOutput(answer);
        return answer;
    }

    public ThrottleDefinition throttle(Expression maximumRequestCount, Expression correlationExpressionKey) {
        ThrottleDefinition answer = new ThrottleDefinition(maximumRequestCount, correlationExpressionKey);
        this.addOutput(answer);
        return answer;
    }

    public ExpressionClause<LoopDefinition> loop() {
        LoopDefinition loop = new LoopDefinition();
        this.addOutput(loop);
        return ProcessorDefinition.createAndSetExpression(loop);
    }

    public LoopDefinition loop(Expression expression) {
        LoopDefinition loop = new LoopDefinition(expression);
        this.addOutput(loop);
        return loop;
    }

    public LoopDefinition loopDoWhile(@AsPredicate Predicate predicate) {
        LoopDefinition loop = new LoopDefinition(predicate);
        this.addOutput(loop);
        return loop;
    }

    public ExpressionClause<LoopDefinition> loopDoWhile() {
        LoopDefinition loop = new LoopDefinition();
        loop.setDoWhile(Boolean.toString(true));
        this.addOutput(loop);
        return ProcessorDefinition.createAndSetExpression(loop);
    }

    public LoopDefinition loop(int count) {
        LoopDefinition loop = new LoopDefinition(new ConstantExpression(Integer.toString(count)));
        this.addOutput(loop);
        return loop;
    }

    public Type throwException(Exception exception) {
        ThrowExceptionDefinition answer = new ThrowExceptionDefinition();
        answer.setException(exception);
        this.addOutput(answer);
        return this.asType();
    }

    public Type throwException(Class<? extends Exception> type, String message) {
        ThrowExceptionDefinition answer = new ThrowExceptionDefinition();
        answer.setExceptionClass(type);
        answer.setMessage(message);
        this.addOutput(answer);
        return this.asType();
    }

    public Type markRollbackOnly() {
        RollbackDefinition answer = new RollbackDefinition();
        answer.setMarkRollbackOnly(Boolean.toString(true));
        this.addOutput(answer);
        return this.asType();
    }

    public Type markRollbackOnlyLast() {
        RollbackDefinition answer = new RollbackDefinition();
        answer.setMarkRollbackOnlyLast(Boolean.toString(true));
        this.addOutput(answer);
        return this.asType();
    }

    public Type rollback() {
        return this.rollback(null);
    }

    public Type rollback(String message) {
        RollbackDefinition answer = new RollbackDefinition(message);
        this.addOutput(answer);
        return this.asType();
    }

    public WireTapDefinition<Type> wireTap(Endpoint endpoint) {
        WireTapDefinition answer = new WireTapDefinition();
        answer.setUri(endpoint.getEndpointUri());
        this.addOutput(answer);
        return answer;
    }

    public WireTapDefinition<Type> wireTap(@AsEndpointUri EndpointProducerBuilder endpoint) {
        WireTapDefinition answer = new WireTapDefinition();
        answer.setEndpointProducerBuilder(endpoint);
        this.addOutput(answer);
        return answer;
    }

    public WireTapDefinition<Type> wireTap(@AsEndpointUri String uri) {
        WireTapDefinition answer = new WireTapDefinition();
        answer.setUri(uri);
        this.addOutput(answer);
        return answer;
    }

    void pushBlock(Block block) {
        this.blocks.add(block);
    }

    Block popBlock() {
        return this.blocks.isEmpty() ? null : this.blocks.removeLast();
    }

    public Type startupOrder(int startupOrder) {
        ProcessorDefinition def = this;
        RouteDefinition route = ProcessorDefinitionHelper.getRoute(def);
        if (route != null) {
            route.startupOrder(startupOrder);
        }
        return this.asType();
    }

    public Type stop() {
        StopDefinition stop = new StopDefinition();
        this.addOutput(stop);
        return this.asType();
    }

    public OnExceptionDefinition onException(Class<? extends Throwable> exceptionType) {
        OnExceptionDefinition answer = new OnExceptionDefinition(exceptionType);
        this.addOutput(answer);
        return answer;
    }

    public OnExceptionDefinition onException(Class<? extends Throwable> ... exceptions) {
        OnExceptionDefinition answer = new OnExceptionDefinition(Arrays.asList(exceptions));
        this.addOutput(answer);
        return answer;
    }

    public PolicyDefinition policy(Policy policy) {
        PolicyDefinition answer = new PolicyDefinition(policy);
        this.addOutput(answer);
        return answer;
    }

    public PolicyDefinition policy(String ref) {
        PolicyDefinition answer = new PolicyDefinition();
        answer.setRef(ref);
        this.addOutput(answer);
        return answer;
    }

    public TransactedDefinition transacted() {
        TransactedDefinition answer = new TransactedDefinition();
        this.addOutput(answer);
        return answer;
    }

    public TransactedDefinition transacted(String ref) {
        TransactedDefinition answer = new TransactedDefinition();
        answer.setRef(ref);
        this.addOutput(answer);
        return answer;
    }

    public SagaDefinition saga() {
        SagaDefinition answer = new SagaDefinition();
        this.addOutput(answer);
        return answer;
    }

    public Type process(Processor processor) {
        ProcessDefinition answer = new ProcessDefinition(processor);
        this.addOutput(answer);
        return this.asType();
    }

    public Type process(String ref) {
        ProcessDefinition answer = new ProcessDefinition();
        answer.setRef(ref);
        this.addOutput(answer);
        return this.asType();
    }

    public ProcessClause<ProcessorDefinition<Type>> process() {
        ProcessClause<ProcessorDefinition<Type>> clause = new ProcessClause<ProcessorDefinition<Type>>(this);
        ProcessDefinition answer = new ProcessDefinition(clause);
        this.addOutput(answer);
        return clause;
    }

    public Type bean(Object bean) {
        BeanDefinition answer = new BeanDefinition();
        if (bean instanceof String) {
            answer.setRef((String)bean);
        } else {
            answer.setBean(bean);
        }
        this.addOutput(answer);
        return this.asType();
    }

    public Type bean(Supplier<Object> bean) {
        return this.bean(bean.get());
    }

    public Type bean(Object bean, String method) {
        BeanDefinition answer = new BeanDefinition();
        if (bean instanceof String) {
            answer.setRef((String)bean);
        } else {
            answer.setBean(bean);
        }
        answer.setMethod(method);
        this.addOutput(answer);
        return this.asType();
    }

    public Type bean(Supplier<Object> bean, String method) {
        return this.bean(bean.get(), method);
    }

    public Type bean(Supplier<Object> bean, String method, BeanScope scope) {
        return this.bean(bean.get(), method, scope);
    }

    public Type bean(Object bean, BeanScope scope) {
        BeanDefinition answer = new BeanDefinition();
        if (bean instanceof String) {
            answer.setRef((String)bean);
        } else {
            answer.setBean(bean);
        }
        answer.setScope(scope);
        this.addOutput(answer);
        return this.asType();
    }

    public Type bean(Object bean, String method, BeanScope scope) {
        BeanDefinition answer = new BeanDefinition();
        if (bean instanceof String) {
            answer.setRef((String)bean);
        } else {
            answer.setBean(bean);
        }
        answer.setMethod(method);
        answer.setScope(scope);
        this.addOutput(answer);
        return this.asType();
    }

    public Type bean(Class<?> beanType) {
        BeanDefinition answer = new BeanDefinition();
        answer.setBeanType(beanType);
        this.addOutput(answer);
        return this.asType();
    }

    public Type bean(Class<?> beanType, BeanScope scope) {
        BeanDefinition answer = new BeanDefinition();
        answer.setBeanType(beanType);
        answer.setScope(scope);
        this.addOutput(answer);
        return this.asType();
    }

    public Type bean(Class<?> beanType, String method) {
        BeanDefinition answer = new BeanDefinition();
        answer.setBeanType(beanType);
        answer.setMethod(method);
        this.addOutput(answer);
        return this.asType();
    }

    public Type bean(Class<?> beanType, String method, BeanScope scope) {
        BeanDefinition answer = new BeanDefinition();
        answer.setBeanType(beanType);
        answer.setMethod(method);
        answer.setScope(scope);
        this.addOutput(answer);
        return this.asType();
    }

    public ExpressionClause<ProcessorDefinition<Type>> setBody() {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        SetBodyDefinition answer = new SetBodyDefinition(clause);
        this.addOutput(answer);
        return clause;
    }

    public Type setBody(Expression expression) {
        SetBodyDefinition answer = new SetBodyDefinition(expression);
        this.addOutput(answer);
        return this.asType();
    }

    public <Result> Type setBody(final Function<Exchange, Result> function) {
        SetBodyDefinition answer = new SetBodyDefinition((Expression)new ExpressionAdapter(){

            public Result evaluate(Exchange exchange) {
                return function.apply(exchange);
            }
        });
        this.addOutput(answer);
        return this.asType();
    }

    public Type transform(Expression expression) {
        TransformDefinition answer = new TransformDefinition(expression);
        this.addOutput(answer);
        return this.asType();
    }

    public ExpressionClause<ProcessorDefinition<Type>> transform() {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        TransformDefinition answer = new TransformDefinition(clause);
        this.addOutput(answer);
        return clause;
    }

    public Type script(Expression expression) {
        ScriptDefinition answer = new ScriptDefinition(expression);
        this.addOutput(answer);
        return this.asType();
    }

    public ExpressionClause<ProcessorDefinition<Type>> script() {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        ScriptDefinition answer = new ScriptDefinition(clause);
        this.addOutput(answer);
        return clause;
    }

    public ExpressionClause<ProcessorDefinition<Type>> setHeader(String name) {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        SetHeaderDefinition answer = new SetHeaderDefinition(name, clause);
        this.addOutput(answer);
        return clause;
    }

    public Type setHeader(String name, Expression expression) {
        SetHeaderDefinition answer = new SetHeaderDefinition(name, expression);
        this.addOutput(answer);
        return this.asType();
    }

    public Type setHeader(String name, final Supplier<Object> supplier) {
        SetHeaderDefinition answer = new SetHeaderDefinition(name, (Expression)new ExpressionAdapter(){

            public Object evaluate(Exchange exchange) {
                return supplier.get();
            }
        });
        this.addOutput(answer);
        return this.asType();
    }

    public Type setProperty(String name, Expression expression) {
        SetPropertyDefinition answer = new SetPropertyDefinition(name, expression);
        this.addOutput(answer);
        return this.asType();
    }

    public ExpressionClause<ProcessorDefinition<Type>> setProperty(String name) {
        ExpressionClause<ProcessorDefinition<Type>> clause = new ExpressionClause<ProcessorDefinition<Type>>(this);
        SetPropertyDefinition answer = new SetPropertyDefinition(name, clause);
        this.addOutput(answer);
        return clause;
    }

    public Type removeHeader(String name) {
        RemoveHeaderDefinition answer = new RemoveHeaderDefinition(name);
        this.addOutput(answer);
        return this.asType();
    }

    public Type removeHeaders(String pattern) {
        RemoveHeadersDefinition answer = new RemoveHeadersDefinition(pattern);
        this.addOutput(answer);
        return this.asType();
    }

    public Type removeHeaders(String pattern, String ... excludePatterns) {
        RemoveHeadersDefinition answer = new RemoveHeadersDefinition(pattern, excludePatterns);
        this.addOutput(answer);
        return this.asType();
    }

    public Type removeProperty(String name) {
        RemovePropertyDefinition answer = new RemovePropertyDefinition(name);
        this.addOutput(answer);
        return this.asType();
    }

    public Type removeProperties(String pattern) {
        RemovePropertiesDefinition answer = new RemovePropertiesDefinition(pattern);
        this.addOutput(answer);
        return this.asType();
    }

    public Type removeProperties(String pattern, String ... excludePatterns) {
        RemovePropertiesDefinition answer = new RemovePropertiesDefinition(pattern, excludePatterns);
        this.addOutput(answer);
        return this.asType();
    }

    public Type convertBodyTo(Class<?> type) {
        this.addOutput(new ConvertBodyDefinition(type));
        return this.asType();
    }

    public Type convertBodyTo(Class<?> type, String charset) {
        this.addOutput(new ConvertBodyDefinition(type, charset));
        return this.asType();
    }

    public Type sort(Expression expression) {
        return this.sort(expression, null);
    }

    public <T> Type sort(Expression expression, Comparator<T> comparator) {
        this.addOutput(new SortDefinition<T>(expression, comparator));
        return this.asType();
    }

    public <T> ExpressionClause<SortDefinition<T>> sort() {
        SortDefinition answer = new SortDefinition();
        this.addOutput(answer);
        return ProcessorDefinition.createAndSetExpression(answer);
    }

    public ClaimCheckDefinition claimCheck() {
        ClaimCheckDefinition answer = new ClaimCheckDefinition();
        this.addOutput(answer);
        return answer;
    }

    public Type claimCheck(ClaimCheckOperation operation) {
        ClaimCheckDefinition answer = new ClaimCheckDefinition();
        answer.setOperation(operation.name());
        this.addOutput(answer);
        return this.asType();
    }

    public Type claimCheck(ClaimCheckOperation operation, String key) {
        return this.claimCheck(operation, key, null);
    }

    public Type claimCheck(ClaimCheckOperation operation, String key, String filter) {
        ClaimCheckDefinition answer = new ClaimCheckDefinition();
        answer.setOperation(operation.name());
        answer.setKey(key);
        answer.setFilter(filter);
        this.addOutput(answer);
        return this.asType();
    }

    public Type enrich(@AsEndpointUri String resourceUri) {
        return this.enrich(resourceUri, null);
    }

    public Type enrich(@AsEndpointUri String resourceUri, AggregationStrategy aggregationStrategy) {
        return this.enrich(resourceUri, aggregationStrategy, false);
    }

    public Type enrich(@AsEndpointUri EndpointProducerBuilder resourceUri) {
        return this.enrich(resourceUri, null);
    }

    public Type enrich(@AsEndpointUri EndpointProducerBuilder resourceUri, AggregationStrategy aggregationStrategy) {
        return this.enrich(resourceUri, aggregationStrategy, false);
    }

    public EnrichClause<ProcessorDefinition<Type>> enrichWith(@AsEndpointUri String resourceUri) {
        EnrichClause<ProcessorDefinition<Type>> clause = new EnrichClause<ProcessorDefinition<Type>>(this);
        this.enrich(resourceUri, clause);
        return clause;
    }

    public EnrichClause<ProcessorDefinition<Type>> enrichWith(@AsEndpointUri String resourceUri, boolean aggregateOnException) {
        EnrichClause<ProcessorDefinition<Type>> clause = new EnrichClause<ProcessorDefinition<Type>>(this);
        this.enrich(resourceUri, clause, aggregateOnException, false);
        return clause;
    }

    public EnrichClause<ProcessorDefinition<Type>> enrichWith(@AsEndpointUri String resourceUri, boolean aggregateOnException, boolean shareUnitOfWork) {
        EnrichClause<ProcessorDefinition<Type>> clause = new EnrichClause<ProcessorDefinition<Type>>(this);
        this.enrich(resourceUri, clause, aggregateOnException, shareUnitOfWork);
        return clause;
    }

    public EnrichClause<ProcessorDefinition<Type>> enrichWith(@AsEndpointUri EndpointProducerBuilder resourceUri) {
        return this.enrichWith(resourceUri.getUri());
    }

    public EnrichClause<ProcessorDefinition<Type>> enrichWith(@AsEndpointUri EndpointProducerBuilder resourceUri, boolean aggregateOnException) {
        EnrichClause<ProcessorDefinition<Type>> clause = new EnrichClause<ProcessorDefinition<Type>>(this);
        this.enrich(resourceUri, clause, aggregateOnException, false);
        return clause;
    }

    public EnrichClause<ProcessorDefinition<Type>> enrichWith(@AsEndpointUri EndpointProducerBuilder resourceUri, boolean aggregateOnException, boolean shareUnitOfWork) {
        EnrichClause<ProcessorDefinition<Type>> clause = new EnrichClause<ProcessorDefinition<Type>>(this);
        this.enrich(resourceUri, clause, aggregateOnException, shareUnitOfWork);
        return clause;
    }

    public Type enrich(@AsEndpointUri String resourceUri, AggregationStrategy aggregationStrategy, boolean aggregateOnException) {
        return this.enrich(resourceUri, aggregationStrategy, aggregateOnException, false);
    }

    public Type enrich(@AsEndpointUri String resourceUri, AggregationStrategy aggregationStrategy, boolean aggregateOnException, boolean shareUnitOfWork) {
        EnrichDefinition answer = new EnrichDefinition();
        answer.setExpression(new ConstantExpression(resourceUri));
        answer.setAggregationStrategy(aggregationStrategy);
        answer.setAggregateOnException(Boolean.toString(aggregateOnException));
        answer.setShareUnitOfWork(Boolean.toString(shareUnitOfWork));
        this.addOutput(answer);
        return this.asType();
    }

    public Type enrich(@AsEndpointUri EndpointProducerBuilder resourceUri, AggregationStrategy aggregationStrategy, boolean aggregateOnException) {
        return this.enrich(resourceUri, aggregationStrategy, aggregateOnException, false);
    }

    public Type enrich(@AsEndpointUri EndpointProducerBuilder resourceUri, AggregationStrategy aggregationStrategy, boolean aggregateOnException, boolean shareUnitOfWork) {
        EnrichDefinition answer = new EnrichDefinition();
        answer.setExpression(resourceUri.expr());
        answer.setAggregationStrategy(aggregationStrategy);
        answer.setAggregateOnException(Boolean.toString(aggregateOnException));
        answer.setShareUnitOfWork(Boolean.toString(shareUnitOfWork));
        this.addOutput(answer);
        return this.asType();
    }

    @AsEndpointUri
    public ExpressionClause<EnrichDefinition> enrich() {
        EnrichDefinition answer = new EnrichDefinition();
        this.addOutput(answer);
        return ProcessorDefinition.createAndSetExpression(answer);
    }

    public Type pollEnrich(@AsEndpointUri String resourceUri) {
        return this.pollEnrich(resourceUri, null);
    }

    public Type pollEnrich(@AsEndpointUri String resourceUri, AggregationStrategy aggregationStrategy) {
        return this.pollEnrich(resourceUri, -1L, aggregationStrategy);
    }

    public Type pollEnrich(@AsEndpointUri String resourceUri, long timeout, AggregationStrategy aggregationStrategy) {
        return this.pollEnrich(resourceUri, timeout, aggregationStrategy, false);
    }

    public Type pollEnrich(@AsEndpointUri String resourceUri, long timeout, String aggregationStrategyRef) {
        return this.pollEnrich(resourceUri, timeout, aggregationStrategyRef, false);
    }

    public Type pollEnrich(EndpointProducerBuilder resourceUri) {
        return this.pollEnrich(resourceUri.getUri());
    }

    public Type pollEnrich(EndpointProducerBuilder resourceUri, AggregationStrategy aggregationStrategy) {
        return this.pollEnrich(resourceUri, -1L, aggregationStrategy);
    }

    public Type pollEnrich(EndpointProducerBuilder resourceUri, long timeout, AggregationStrategy aggregationStrategy) {
        return this.pollEnrich(resourceUri, timeout, aggregationStrategy, false);
    }

    public Type pollEnrich(EndpointProducerBuilder resourceUri, long timeout, String aggregationStrategyRef) {
        return this.pollEnrich(resourceUri, timeout, aggregationStrategyRef, false);
    }

    public EnrichClause<ProcessorDefinition<Type>> pollEnrichWith(@AsEndpointUri String resourceUri) {
        return this.pollEnrichWith(resourceUri, -1L);
    }

    public EnrichClause<ProcessorDefinition<Type>> pollEnrichWith(@AsEndpointUri String resourceUri, long timeout) {
        return this.pollEnrichWith(resourceUri, timeout, false);
    }

    public EnrichClause<ProcessorDefinition<Type>> pollEnrichWith(@AsEndpointUri String resourceUri, long timeout, boolean aggregateOnException) {
        EnrichClause<ProcessorDefinition<Type>> clause = new EnrichClause<ProcessorDefinition<Type>>(this);
        this.pollEnrich(resourceUri, timeout, clause, aggregateOnException);
        return clause;
    }

    public EnrichClause<ProcessorDefinition<Type>> pollEnrichWith(EndpointProducerBuilder resourceUri) {
        return this.pollEnrichWith(resourceUri, -1L);
    }

    public EnrichClause<ProcessorDefinition<Type>> pollEnrichWith(EndpointProducerBuilder resourceUri, long timeout) {
        return this.pollEnrichWith(resourceUri, timeout, false);
    }

    public EnrichClause<ProcessorDefinition<Type>> pollEnrichWith(EndpointProducerBuilder resourceUri, long timeout, boolean aggregateOnException) {
        EnrichClause<ProcessorDefinition<Type>> clause = new EnrichClause<ProcessorDefinition<Type>>(this);
        this.pollEnrich(resourceUri, timeout, clause, aggregateOnException);
        return clause;
    }

    public Type pollEnrich(@AsEndpointUri String resourceUri, long timeout, AggregationStrategy aggregationStrategy, boolean aggregateOnException) {
        return this.pollEnrich((Expression)new ConstantExpression(resourceUri), timeout, aggregationStrategy, aggregateOnException);
    }

    public Type pollEnrich(@AsEndpointUri String resourceUri, long timeout, String aggregationStrategyRef, boolean aggregateOnException) {
        return this.pollEnrich((Expression)new ConstantExpression(resourceUri), timeout, aggregationStrategyRef, aggregateOnException);
    }

    public Type pollEnrich(@AsEndpointUri String resourceUri, long timeout) {
        return this.pollEnrich(resourceUri, timeout, (String)null);
    }

    public Type pollEnrich(@AsEndpointUri EndpointProducerBuilder resourceUri, long timeout, AggregationStrategy aggregationStrategy, boolean aggregateOnException) {
        return this.pollEnrich(resourceUri.expr(), timeout, aggregationStrategy, aggregateOnException);
    }

    public Type pollEnrich(@AsEndpointUri EndpointProducerBuilder resourceUri, long timeout, String aggregationStrategyRef, boolean aggregateOnException) {
        return this.pollEnrich(resourceUri.expr(), timeout, aggregationStrategyRef, aggregateOnException);
    }

    public Type pollEnrich(@AsEndpointUri EndpointProducerBuilder resourceUri, long timeout) {
        return this.pollEnrich(resourceUri, timeout, (String)null);
    }

    public Type pollEnrich(@AsEndpointUri Expression expression, long timeout, String aggregationStrategyRef, boolean aggregateOnException) {
        PollEnrichDefinition pollEnrich = new PollEnrichDefinition();
        pollEnrich.setExpression(expression);
        pollEnrich.setTimeout(Long.toString(timeout));
        pollEnrich.setAggregationStrategyRef(aggregationStrategyRef);
        pollEnrich.setAggregateOnException(Boolean.toString(aggregateOnException));
        this.addOutput(pollEnrich);
        return this.asType();
    }

    public Type pollEnrich(@AsEndpointUri Expression expression, long timeout, AggregationStrategy aggregationStrategy, boolean aggregateOnException) {
        PollEnrichDefinition pollEnrich = new PollEnrichDefinition();
        pollEnrich.setExpression(expression);
        pollEnrich.setTimeout(Long.toString(timeout));
        pollEnrich.setAggregationStrategy(aggregationStrategy);
        pollEnrich.setAggregateOnException(Boolean.toString(aggregateOnException));
        this.addOutput(pollEnrich);
        return this.asType();
    }

    @AsEndpointUri
    public ExpressionClause<PollEnrichDefinition> pollEnrich() {
        PollEnrichDefinition answer = new PollEnrichDefinition();
        this.addOutput(answer);
        return ProcessorDefinition.createAndSetExpression(answer);
    }

    public OnCompletionDefinition onCompletion() {
        OnCompletionDefinition answer = new OnCompletionDefinition();
        answer.removeAllOnCompletionDefinition(this);
        this.popBlock();
        this.addOutput(answer);
        this.pushBlock(answer);
        return answer;
    }

    public DataFormatClause<ProcessorDefinition<Type>> unmarshal() {
        return new DataFormatClause<ProcessorDefinition<Type>>(this, DataFormatClause.Operation.Unmarshal);
    }

    public Type unmarshal(DataFormatDefinition dataFormatType) {
        this.addOutput(new UnmarshalDefinition(dataFormatType));
        return this.asType();
    }

    public Type unmarshal(DataFormat dataFormat) {
        return this.unmarshal(new DataFormatDefinition(dataFormat));
    }

    public Type unmarshal(String dataTypeRef) {
        return this.unmarshal(new CustomDataFormat(dataTypeRef));
    }

    public DataFormatClause<ProcessorDefinition<Type>> marshal() {
        return new DataFormatClause<ProcessorDefinition<Type>>(this, DataFormatClause.Operation.Marshal);
    }

    public Type marshal(DataFormatDefinition dataFormatType) {
        this.addOutput(new MarshalDefinition(dataFormatType));
        return this.asType();
    }

    public Type marshal(DataFormat dataFormat) {
        return this.marshal(new DataFormatDefinition(dataFormat));
    }

    public Type marshal(String dataTypeRef) {
        this.addOutput(new MarshalDefinition(new CustomDataFormat(dataTypeRef)));
        return this.asType();
    }

    public Type inheritErrorHandler(boolean inheritErrorHandler) {
        int size = this.getOutputs().size();
        if (size == 0) {
            this.setInheritErrorHandler(inheritErrorHandler);
        } else {
            ProcessorDefinition<?> output = this.getOutputs().get(size - 1);
            if (output != null) {
                output.setInheritErrorHandler(inheritErrorHandler);
            }
        }
        return this.asType();
    }

    Type asType() {
        return (Type)this;
    }

    @Override
    public ProcessorDefinition<?> getParent() {
        return this.parent;
    }

    public void setParent(ProcessorDefinition<?> parent) {
        this.parent = parent;
    }

    public List<InterceptStrategy> getInterceptStrategies() {
        return this.interceptStrategies;
    }

    public void addInterceptStrategy(InterceptStrategy strategy) {
        this.interceptStrategies.add(strategy);
    }

    public Boolean isInheritErrorHandler() {
        return this.inheritErrorHandler;
    }

    public void setInheritErrorHandler(Boolean inheritErrorHandler) {
        this.inheritErrorHandler = inheritErrorHandler;
    }

    public String getLabel() {
        return "";
    }
}

