/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.management;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.MCGetCPMembersCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAsyncMessageTask;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.CPSubsystemManagementService;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.nio.Connection;
import java.security.Permission;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class GetCPMembersMessageTask
extends AbstractAsyncMessageTask<MCGetCPMembersCodec.RequestParameters, List<AbstractMap.SimpleEntry<UUID, UUID>>> {
    public GetCPMembersMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected CompletableFuture<List<AbstractMap.SimpleEntry<UUID, UUID>>> processInternal() {
        CPSubsystemManagementService cpService = this.nodeEngine.getHazelcastInstance().getCPSubsystem().getCPSubsystemManagementService();
        ClusterService clusterService = this.nodeEngine.getClusterService();
        return cpService.getCPMembers().toCompletableFuture().thenApply(cpMembers -> {
            ArrayList<AbstractMap.SimpleEntry<UUID, UUID>> result = new ArrayList<AbstractMap.SimpleEntry<UUID, UUID>>(cpMembers.size());
            for (CPMember cpMember : cpMembers) {
                UUID apUuid = clusterService.getMember(cpMember.getAddress()).getUuid();
                result.add(new AbstractMap.SimpleEntry<UUID, UUID>(cpMember.getUuid(), apUuid));
            }
            return result;
        });
    }

    @Override
    protected MCGetCPMembersCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return MCGetCPMembersCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return MCGetCPMembersCodec.encodeResponse((List)response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:managementCenterService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return "getCPMembers";
    }

    @Override
    public Object[] getParameters() {
        return new Object[0];
    }
}

