/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.recordstore;

import com.hazelcast.cluster.Address;
import com.hazelcast.config.InMemoryFormat;
import com.hazelcast.config.NativeMemoryConfig;
import com.hazelcast.core.EntryEventType;
import com.hazelcast.internal.iteration.IterationPointer;
import com.hazelcast.internal.locksupport.LockSupportService;
import com.hazelcast.internal.partition.IPartition;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.EntryLoader;
import com.hazelcast.map.impl.ExpirationTimeSetter;
import com.hazelcast.map.impl.InterceptorRegistry;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapEntries;
import com.hazelcast.map.impl.MapKeyLoader;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.event.EntryEventData;
import com.hazelcast.map.impl.iterator.MapEntriesWithCursor;
import com.hazelcast.map.impl.iterator.MapKeysWithCursor;
import com.hazelcast.map.impl.mapstore.MapDataStore;
import com.hazelcast.map.impl.mapstore.MapDataStores;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindQueue;
import com.hazelcast.map.impl.mapstore.writebehind.WriteBehindStore;
import com.hazelcast.map.impl.mapstore.writebehind.entry.DelayedEntry;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.publisher.MapPublisherRegistry;
import com.hazelcast.map.impl.querycache.publisher.PublisherContext;
import com.hazelcast.map.impl.querycache.publisher.PublisherRegistry;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.AbstractEvictableRecordStore;
import com.hazelcast.map.impl.recordstore.RecordStore;
import com.hazelcast.map.impl.recordstore.RecordStoreLoader;
import com.hazelcast.spi.exception.RetryableHazelcastException;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.merge.MergingValueFactory;
import com.hazelcast.spi.merge.SplitBrainMergePolicy;
import com.hazelcast.spi.merge.SplitBrainMergeTypes;
import com.hazelcast.wan.impl.CallerProvenance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultRecordStore
extends AbstractEvictableRecordStore {
    protected final ILogger logger;
    protected final RecordStoreLoader recordStoreLoader;
    protected final MapKeyLoader keyLoader;
    protected final Collection<Future> loadingFutures = new ConcurrentLinkedQueue<Future>();
    private boolean loadedOnCreate;
    private boolean loadedOnPreMigration;
    private final IPartitionService partitionService;
    private final InterceptorRegistry interceptorRegistry;

    public DefaultRecordStore(MapContainer mapContainer, int partitionId, MapKeyLoader keyLoader, ILogger logger) {
        super(mapContainer, partitionId);
        this.logger = logger;
        this.keyLoader = keyLoader;
        this.recordStoreLoader = this.createRecordStoreLoader(this.mapStoreContext);
        this.partitionService = this.mapServiceContext.getNodeEngine().getPartitionService();
        this.interceptorRegistry = mapContainer.getInterceptorRegistry();
    }

    @Override
    public MapDataStore<Data, Object> getMapDataStore() {
        return this.mapDataStore;
    }

    @Override
    public long softFlush() {
        this.updateStoreStats();
        return this.mapDataStore.softFlush();
    }

    private void flush(ArrayList<Data> dataKeys, ArrayList<Record> records, boolean backup) {
        if (this.mapDataStore == MapDataStores.EMPTY_MAP_DATA_STORE) {
            return;
        }
        for (int i = 0; i < dataKeys.size(); ++i) {
            this.mapDataStore.flush(dataKeys.get(i), records.get(i).getValue(), backup);
        }
    }

    @Override
    public Record getRecord(Data key) {
        return (Record)this.storage.get(key);
    }

    @Override
    public Record putReplicatedRecord(Data dataKey, Record replicatedRecord, long nowInMillis, boolean populateIndexes) {
        Record newRecord = this.createRecord(dataKey, replicatedRecord, nowInMillis);
        this.markRecordStoreExpirable(replicatedRecord.getTtl(), replicatedRecord.getMaxIdle());
        this.storage.put(dataKey, newRecord);
        this.mutationObserver.onReplicationPutRecord(dataKey, newRecord, populateIndexes);
        this.updateStatsOnPut(replicatedRecord.getHits(), nowInMillis);
        return newRecord;
    }

    @Override
    public Record putBackup(Data dataKey, Record newRecord, boolean putTransient, CallerProvenance provenance) {
        return this.putBackupInternal(dataKey, newRecord.getValue(), newRecord.getTtl(), newRecord.getMaxIdle(), putTransient, provenance, null);
    }

    @Override
    public Record putBackupTxn(Data dataKey, Record newRecord, boolean putTransient, CallerProvenance provenance, UUID transactionId) {
        return this.putBackupInternal(dataKey, newRecord.getValue(), newRecord.getTtl(), newRecord.getMaxIdle(), putTransient, provenance, transactionId);
    }

    @Override
    public Record putBackup(Data key, Object value, long ttl, long maxIdle, CallerProvenance provenance) {
        return this.putBackupInternal(key, value, ttl, maxIdle, false, provenance, null);
    }

    private Record putBackupInternal(Data key, Object value, long ttl, long maxIdle, boolean putTransient, CallerProvenance provenance, UUID transactionId) {
        long now = DefaultRecordStore.getNow();
        this.markRecordStoreExpirable(ttl, maxIdle);
        Record record = this.getRecordOrNull(key, now, true);
        if (record == null) {
            record = this.createRecord(key, value, ttl, maxIdle, now);
            this.storage.put(key, record);
            this.mutationObserver.onPutRecord(key, record, null, true);
        } else {
            this.updateRecord(key, record, record.getValue(), value, now, true, ttl, maxIdle, false, transactionId, true);
        }
        if (this.persistenceEnabledFor(provenance)) {
            if (putTransient) {
                this.mapDataStore.addTransient(key, now);
            } else {
                this.mapDataStore.addBackup(key, value, record.getExpirationTime(), now, transactionId);
            }
        }
        return record;
    }

    @Override
    public void forEach(BiConsumer<Data, Record> consumer, boolean backup) {
        this.forEach(consumer, backup, false);
    }

    @Override
    public void forEach(BiConsumer<Data, Record> consumer, boolean backup, boolean includeExpiredRecords) {
        long now = Clock.currentTimeMillis();
        Iterator entries = this.storage.mutationTolerantIterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            Data key = entry.getKey();
            Record record = (Record)entry.getValue();
            if (!includeExpiredRecords && this.isExpired(record, now, backup)) continue;
            consumer.accept(key, record);
        }
    }

    @Override
    public Iterator<Map.Entry<Data, Record>> iterator() {
        return this.storage.mutationTolerantIterator();
    }

    @Override
    public void forEachAfterLoad(BiConsumer<Data, Record> consumer, boolean backup) {
        this.checkIfLoaded();
        this.forEach(consumer, backup);
    }

    @Override
    public MapKeysWithCursor fetchKeys(IterationPointer[] pointers, int size) {
        return this.storage.fetchKeys(pointers, size);
    }

    @Override
    public MapEntriesWithCursor fetchEntries(IterationPointer[] pointers, int size) {
        return this.storage.fetchEntries(pointers, size);
    }

    @Override
    public int size() {
        return this.storage.size();
    }

    @Override
    public boolean isEmpty() {
        this.checkIfLoaded();
        return this.storage.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        this.checkIfLoaded();
        long now = DefaultRecordStore.getNow();
        if (this.storage.isEmpty()) {
            return false;
        }
        value = this.inMemoryFormat == InMemoryFormat.OBJECT ? this.serializationService.toObject(value) : this.serializationService.toData(value);
        Iterator entryIterator = this.storage.mutationTolerantIterator();
        while (entryIterator.hasNext()) {
            Record record;
            Map.Entry entry = entryIterator.next();
            Data key = entry.getKey();
            if (this.getOrNullIfExpired(key, record = (Record)entry.getValue(), now, false) == null || !this.valueComparator.isEqual(value, record.getValue(), this.serializationService)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean txnLock(Data key, UUID caller, long threadId, long referenceId, long ttl, boolean blockReads) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.txnLock(key, caller, threadId, referenceId, ttl, blockReads);
    }

    @Override
    public boolean extendLock(Data key, UUID caller, long threadId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.extendLeaseTime(key, caller, threadId, ttl);
    }

    @Override
    public boolean localLock(Data key, UUID caller, long threadId, long referenceId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.localLock(key, caller, threadId, referenceId, ttl);
    }

    @Override
    public boolean unlock(Data key, UUID caller, long threadId, long referenceId) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.unlock(key, caller, threadId, referenceId);
    }

    @Override
    public boolean lock(Data key, UUID caller, long threadId, long referenceId, long ttl) {
        this.checkIfLoaded();
        return this.lockStore != null && this.lockStore.lock(key, caller, threadId, referenceId, ttl);
    }

    @Override
    public boolean forceUnlock(Data dataKey) {
        return this.lockStore != null && this.lockStore.forceUnlock(dataKey);
    }

    @Override
    public boolean isLocked(Data dataKey) {
        return this.lockStore != null && this.lockStore.isLocked(dataKey);
    }

    @Override
    public boolean isTransactionallyLocked(Data key) {
        return this.lockStore != null && this.lockStore.shouldBlockReads(key);
    }

    @Override
    public boolean canAcquireLock(Data key, UUID caller, long threadId) {
        return this.lockStore == null || this.lockStore.canAcquireLock(key, caller, threadId);
    }

    @Override
    public boolean isLockedBy(Data key, UUID caller, long threadId) {
        return this.lockStore != null && this.lockStore.isLockedBy(key, caller, threadId);
    }

    @Override
    public String getLockOwnerInfo(Data key) {
        return this.lockStore != null ? this.lockStore.getOwnerInfo(key) : null;
    }

    private Object loadValueOf(Data key) {
        Object value = this.mapDataStore.load(key);
        if (value == null) {
            return null;
        }
        if (this.mapDataStore.isWithExpirationTime()) {
            EntryLoader.MetadataAwareValue loaderEntry = (EntryLoader.MetadataAwareValue)value;
            long proposedTtl = this.expirationTimeToTtl(loaderEntry.getExpirationTime());
            if (proposedTtl <= 0L) {
                return null;
            }
            value = loaderEntry.getValue();
        }
        return value;
    }

    @Override
    public Record loadRecordOrNull(Data key, boolean backup, Address callerAddress) {
        Object value = this.mapDataStore.load(key);
        if (value == null) {
            return null;
        }
        long ttl = -1L;
        if (this.mapDataStore.isWithExpirationTime()) {
            EntryLoader.MetadataAwareValue loaderEntry = (EntryLoader.MetadataAwareValue)value;
            long proposedTtl = this.expirationTimeToTtl(loaderEntry.getExpirationTime());
            if (proposedTtl <= 0L) {
                return null;
            }
            value = loaderEntry.getValue();
            ttl = proposedTtl;
        }
        Record record = this.createRecord(key, value, ttl, -1L, DefaultRecordStore.getNow());
        this.markRecordStoreExpirable(ttl, -1L);
        this.storage.put(key, record);
        this.mutationObserver.onLoadRecord(key, record, backup);
        if (!backup) {
            this.mapEventPublisher.publishEvent(callerAddress, this.name, EntryEventType.LOADED, key, null, value, null);
        }
        this.evictEntries(key);
        if (!backup && this.hasQueryCache()) {
            this.addEventToQueryCache(key, record);
        }
        return record;
    }

    protected long expirationTimeToTtl(long definedExpirationTime) {
        return definedExpirationTime - System.currentTimeMillis();
    }

    protected int removeBulk(ArrayList<Data> dataKeys, ArrayList<Record> records) {
        return this.removeOrEvictEntries(dataKeys, records, false);
    }

    protected int evictBulk(ArrayList<Data> dataKeys, ArrayList<Record> records) {
        return this.removeOrEvictEntries(dataKeys, records, true);
    }

    private int removeOrEvictEntries(ArrayList<Data> dataKeys, ArrayList<Record> records, boolean eviction) {
        for (int i = 0; i < dataKeys.size(); ++i) {
            Data dataKey = dataKeys.get(i);
            Record record = records.get(i);
            this.removeOrEvictEntry(dataKey, record, eviction);
        }
        return dataKeys.size();
    }

    private void removeOrEvictEntry(Data dataKey, Record record, boolean eviction) {
        if (eviction) {
            this.mutationObserver.onEvictRecord(dataKey, record);
        } else {
            this.mutationObserver.onRemoveRecord(dataKey, record);
        }
        this.storage.removeRecord(dataKey, record);
    }

    @Override
    public Object evict(Data key, boolean backup) {
        Record record = (Record)this.storage.get(key);
        Object value = null;
        if (record != null) {
            value = record.getValue();
            this.mapDataStore.flush(key, value, backup);
            this.mutationObserver.onEvictRecord(key, record);
            this.storage.removeRecord(key, record);
            if (!backup) {
                this.mapServiceContext.interceptRemove(this.interceptorRegistry, value);
            }
        }
        return value;
    }

    @Override
    public void removeBackup(Data key, CallerProvenance provenance) {
        this.removeBackupInternal(key, provenance, null);
    }

    @Override
    public void removeBackupTxn(Data key, CallerProvenance provenance, UUID transactionId) {
        this.removeBackupInternal(key, provenance, transactionId);
    }

    private void removeBackupInternal(Data key, CallerProvenance provenance, UUID transactionId) {
        long now = DefaultRecordStore.getNow();
        Record record = this.getRecordOrNull(key, now, true);
        if (record == null) {
            return;
        }
        this.mutationObserver.onRemoveRecord(key, record);
        this.storage.removeRecord(key, record);
        if (this.persistenceEnabledFor(provenance)) {
            this.mapDataStore.removeBackup(key, now, transactionId);
        }
    }

    @Override
    public boolean delete(Data key, CallerProvenance provenance) {
        this.checkIfLoaded();
        long now = DefaultRecordStore.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            if (this.persistenceEnabledFor(provenance)) {
                this.mapDataStore.remove(key, now, null);
            }
        } else {
            return this.removeRecord(key, record, now, provenance, null) != null;
        }
        return false;
    }

    @Override
    public Object removeTxn(Data dataKey, CallerProvenance callerProvenance, UUID transactionId) {
        return this.removeInternal(dataKey, callerProvenance, transactionId);
    }

    @Override
    public Object remove(Data key, CallerProvenance callerProvenance) {
        return this.removeInternal(key, callerProvenance, null);
    }

    private Object removeInternal(Data key, CallerProvenance provenance, UUID transactionId) {
        Object oldValue;
        this.checkIfLoaded();
        long now = DefaultRecordStore.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            oldValue = this.loadValueOf(key);
            if (oldValue != null && this.persistenceEnabledFor(provenance)) {
                this.mapDataStore.remove(key, now, transactionId);
            }
        } else {
            oldValue = this.removeRecord(key, record, now, provenance, transactionId);
        }
        return oldValue;
    }

    @Override
    public boolean remove(Data key, Object testValue) {
        Object oldValue;
        this.checkIfLoaded();
        long now = DefaultRecordStore.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        boolean removed = false;
        if (record == null) {
            oldValue = this.loadValueOf(key);
            if (oldValue == null) {
                return false;
            }
        } else {
            oldValue = record.getValue();
        }
        if (this.valueComparator.isEqual(testValue, oldValue, this.serializationService)) {
            this.mapServiceContext.interceptRemove(this.interceptorRegistry, oldValue);
            this.mapDataStore.remove(key, now, null);
            if (record != null) {
                this.onStore(record);
                this.mutationObserver.onRemoveRecord(key, record);
                this.storage.removeRecord(key, record);
            }
            removed = true;
        }
        return removed;
    }

    @Override
    public Object get(Data key, boolean backup, Address callerAddress, boolean touch) {
        this.checkIfLoaded();
        long now = DefaultRecordStore.getNow();
        Record record = this.getRecordOrNull(key, now, backup);
        if (record == null) {
            record = this.loadRecordOrNull(key, backup, callerAddress);
            record = this.getOrNullIfExpired(key, record, now, backup);
        } else if (touch) {
            this.accessRecord(record, now);
        }
        Object value = record == null ? null : (Object)record.getValue();
        value = this.mapServiceContext.interceptGet(this.interceptorRegistry, value);
        return value;
    }

    @Override
    public Data readBackupData(Data key) {
        Record record = this.getRecord(key);
        if (record == null) {
            return null;
        }
        if (this.partitionService.isPartitionOwner(this.partitionId)) {
            record.setLastAccessTime(Clock.currentTimeMillis());
        }
        Object value = record.getValue();
        this.mapServiceContext.interceptAfterGet(this.interceptorRegistry, value);
        return this.mapServiceContext.toData(value);
    }

    @Override
    public MapEntries getAll(Set<Data> keys, Address callerAddress) {
        this.checkIfLoaded();
        long now = DefaultRecordStore.getNow();
        MapEntries mapEntries = new MapEntries(keys.size());
        Iterator<Data> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Data key = iterator.next();
            Record record = this.getRecordOrNull(key, now, false);
            if (record == null) continue;
            this.addToMapEntrySet(key, record.getValue(), mapEntries);
            this.accessRecord(record, now);
            iterator.remove();
        }
        if (this.mapDataStore != MapDataStores.EMPTY_MAP_DATA_STORE && !keys.isEmpty()) {
            Map<Object, Object> loadedEntries = this.loadEntries(keys, callerAddress);
            this.addToMapEntrySet(loadedEntries, mapEntries);
        }
        return mapEntries;
    }

    private Map<Data, Object> loadEntries(Set<Data> keys, Address callerAddress) {
        Map loadedEntries = this.mapDataStore.loadAll(keys);
        if (MapUtil.isNullOrEmpty(loadedEntries)) {
            return Collections.emptyMap();
        }
        Map<Data, Object> resultMap = MapUtil.createHashMap(loadedEntries.size());
        Set entrySet = loadedEntries.entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry object;
            Map.Entry entry = object = iterator.next();
            Data key = this.toData(entry.getKey());
            Object value = entry.getValue();
            if (this.mapDataStore.isWithExpirationTime()) {
                EntryLoader.MetadataAwareValue loaderEntry = (EntryLoader.MetadataAwareValue)value;
                if (this.expirationTimeToTtl(loaderEntry.getExpirationTime()) > 0L) {
                    resultMap.put(key, loaderEntry.getValue());
                }
                this.putFromLoad(key, loaderEntry.getValue(), loaderEntry.getExpirationTime(), callerAddress);
                continue;
            }
            resultMap.put(key, value);
            this.putFromLoad(key, value, callerAddress);
        }
        if (this.hasQueryCache()) {
            for (Data key : resultMap.keySet()) {
                Record record = (Record)this.storage.get(key);
                this.addEventToQueryCache(key, record);
            }
        }
        return resultMap;
    }

    protected void addToMapEntrySet(Object key, Object value, MapEntries mapEntries) {
        if (key == null || value == null) {
            return;
        }
        value = this.mapServiceContext.interceptGet(this.interceptorRegistry, value);
        Data dataKey = this.mapServiceContext.toData(key);
        Data dataValue = this.mapServiceContext.toData(value);
        mapEntries.add(dataKey, dataValue);
    }

    protected void addToMapEntrySet(Map<Object, Object> entries, MapEntries mapEntries) {
        for (Map.Entry<Object, Object> entry : entries.entrySet()) {
            this.addToMapEntrySet(entry.getKey(), entry.getValue(), mapEntries);
        }
    }

    @Override
    public boolean existInMemory(Data key) {
        return this.storage.containsKey(key);
    }

    @Override
    public boolean containsKey(Data key, Address callerAddress) {
        boolean contains;
        this.checkIfLoaded();
        long now = DefaultRecordStore.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            record = this.loadRecordOrNull(key, false, callerAddress);
        }
        boolean bl = contains = record != null;
        if (contains) {
            this.accessRecord(record, now);
        }
        return contains;
    }

    @Override
    public boolean hasQueryCache() {
        QueryCacheContext queryCacheContext = this.mapServiceContext.getQueryCacheContext();
        PublisherContext publisherContext = queryCacheContext.getPublisherContext();
        MapPublisherRegistry mapPublisherRegistry = publisherContext.getMapPublisherRegistry();
        PublisherRegistry publisherRegistry = mapPublisherRegistry.getOrNull(this.name);
        return publisherRegistry != null;
    }

    private void addEventToQueryCache(Data dataKey, Record record) {
        EntryEventData eventData = new EntryEventData(this.thisAddress.toString(), this.name, this.thisAddress, dataKey, this.mapServiceContext.toData(record.getValue()), null, null, EntryEventType.ADDED.getType());
        this.mapEventPublisher.addEventToQueryCache(eventData);
    }

    @Override
    public boolean setTtl(Data key, long ttl, boolean backup) {
        Object existingValue;
        long now = DefaultRecordStore.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        Object object = existingValue = record == null ? this.loadValueOf(key) : record.getValue();
        if (existingValue == null) {
            return false;
        }
        if (record == null) {
            this.createRecord(key, existingValue, ttl, -1L, now);
            this.mutationObserver.onPutRecord(key, null, existingValue, false);
        } else {
            this.updateRecord(key, record, existingValue, existingValue, now, true, ttl, -1L, true, null, backup);
        }
        this.markRecordStoreExpirable(ttl, -1L);
        return true;
    }

    @Override
    public Object set(Data dataKey, Object value, long ttl, long maxIdle) {
        return this.putInternal(dataKey, value, ttl, maxIdle, null, false, true);
    }

    @Override
    public Object setTxn(Data dataKey, Object value, long ttl, long maxIdle, UUID transactionId) {
        return this.putInternal(dataKey, value, ttl, maxIdle, transactionId, false, true);
    }

    @Override
    public Object put(Data key, Object value, long ttl, long maxIdle) {
        return this.putInternal(key, value, ttl, maxIdle, null, true, true);
    }

    protected Object putInternal(Data key, Object newValue, long ttl, long maxIdle, @Nullable UUID transactionId, boolean loadFromStore, boolean countAsAccess) {
        this.checkIfLoaded();
        long now = DefaultRecordStore.getNow();
        this.markRecordStoreExpirable(ttl, maxIdle);
        Record record = this.getRecordOrNull(key, now, false);
        Object oldValue = record == null ? (loadFromStore ? this.loadValueOf(key) : null) : record.getValue();
        newValue = this.mapServiceContext.interceptPut(this.interceptorRegistry, oldValue, newValue);
        this.onStore(record);
        if (record == null) {
            this.putNewRecord(key, oldValue, newValue, ttl, maxIdle, now, transactionId);
        } else {
            this.updateRecord(key, record, oldValue, newValue, now, countAsAccess, ttl, maxIdle, true, transactionId, false);
        }
        return oldValue;
    }

    @Override
    public boolean merge(SplitBrainMergeTypes.MapMergeTypes<Object, Object> mergingEntry, SplitBrainMergePolicy<Object, SplitBrainMergeTypes.MapMergeTypes<Object, Object>, Object> mergePolicy) {
        return this.merge(mergingEntry, mergePolicy, CallerProvenance.NOT_WAN);
    }

    @Override
    public boolean merge(SplitBrainMergeTypes.MapMergeTypes<Object, Object> mergingEntry, SplitBrainMergePolicy<Object, SplitBrainMergeTypes.MapMergeTypes<Object, Object>, Object> mergePolicy, CallerProvenance provenance) {
        Object newValue;
        this.checkIfLoaded();
        long now = DefaultRecordStore.getNow();
        mergingEntry = (SplitBrainMergeTypes.MapMergeTypes)this.serializationService.getManagedContext().initialize(mergingEntry);
        mergePolicy = (SplitBrainMergePolicy)this.serializationService.getManagedContext().initialize(mergePolicy);
        Data key = (Data)mergingEntry.getRawKey();
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            newValue = mergePolicy.merge(mergingEntry, null);
            if (newValue == null) {
                return false;
            }
            record = this.createRecord(key, newValue, -1L, -1L, now);
            this.mergeRecordExpiration(record, mergingEntry);
            if (this.persistenceEnabledFor(provenance)) {
                this.putIntoMapStore(record, key, newValue, now, null);
            }
            this.storage.put(key, record);
            this.mutationObserver.onPutRecord(key, record, null, false);
        } else {
            Object oldValue = record.getValue();
            SplitBrainMergeTypes.MapMergeTypes existingEntry = MergingValueFactory.createMergingEntry(this.serializationService, key, record);
            newValue = mergePolicy.merge(mergingEntry, existingEntry);
            if (newValue == null) {
                if (this.persistenceEnabledFor(provenance)) {
                    this.mapDataStore.remove(key, now, null);
                }
                this.onStore(record);
                this.mutationObserver.onRemoveRecord(key, record);
                this.storage.removeRecord(key, record);
                return true;
            }
            if (this.valueComparator.isEqual(newValue, oldValue, this.serializationService)) {
                this.mergeRecordExpiration(record, mergingEntry);
                return true;
            }
            newValue = this.persistenceEnabledFor(provenance) ? this.mapDataStore.add(key, newValue, record.getExpirationTime(), now, null) : newValue;
            this.onStore(record);
            this.storage.updateRecordValue(key, record, newValue);
            this.mutationObserver.onUpdateRecord(key, record, oldValue, newValue, false);
        }
        return newValue != null;
    }

    @Override
    public Object replace(Data key, Object update) {
        this.checkIfLoaded();
        long now = DefaultRecordStore.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        Object oldValue = record == null ? this.loadValueOf(key) : record.getValue();
        if (oldValue == null) {
            return null;
        }
        update = this.mapServiceContext.interceptPut(this.interceptorRegistry, oldValue, update);
        if (record == null) {
            record = this.putNewRecord(key, oldValue, update, -1L, -1L, now, null);
        } else {
            this.updateRecord(key, record, oldValue, update, now, true, -1L, -1L, true, null, false);
        }
        this.onStore(record);
        return oldValue;
    }

    @Override
    public boolean replace(Data key, Object expect, Object update) {
        this.checkIfLoaded();
        long now = DefaultRecordStore.getNow();
        Record record = this.getRecordOrNull(key, now, false);
        Object current = record == null ? this.loadValueOf(key) : record.getValue();
        if (current == null) {
            return false;
        }
        if (!this.valueComparator.isEqual(expect, current, this.serializationService)) {
            return false;
        }
        update = this.mapServiceContext.interceptPut(this.interceptorRegistry, current, update);
        if (record == null) {
            record = this.putNewRecord(key, current, update, -1L, -1L, now, null);
        } else {
            this.updateRecord(key, record, current, update, now, true, -1L, -1L, true, null, false);
        }
        this.onStore(record);
        ExpirationTimeSetter.setExpirationTimes(record.getTtl(), record.getMaxIdle(), record, this.mapContainer.getMapConfig(), false);
        return true;
    }

    @Override
    public Object putTransient(Data key, Object value, long ttl, long maxIdle) {
        this.checkIfLoaded();
        long now = DefaultRecordStore.getNow();
        this.markRecordStoreExpirable(ttl, maxIdle);
        Record record = this.getRecordOrNull(key, now, false);
        Object oldValue = null;
        if (record == null) {
            value = this.mapServiceContext.interceptPut(this.interceptorRegistry, null, value);
            record = this.createRecord(key, value, ttl, maxIdle, now);
            this.storage.put(key, record);
            this.mutationObserver.onPutRecord(key, record, null, false);
        } else {
            oldValue = record.getValue();
            value = this.mapServiceContext.interceptPut(this.interceptorRegistry, oldValue, value);
            this.updateRecord(key, record, oldValue, value, now, true, -1L, -1L, false, null, false);
            ExpirationTimeSetter.setExpirationTimes(ttl, maxIdle, record, this.mapContainer.getMapConfig(), false);
        }
        this.mapDataStore.addTransient(key, now);
        return oldValue;
    }

    @Override
    public Object putFromLoad(Data key, Object value, Address callerAddress) {
        return this.putFromLoadInternal(key, value, -1L, -1L, false, callerAddress);
    }

    @Override
    public Object putFromLoad(Data key, Object value, long expirationTime, Address callerAddress) {
        if (expirationTime == Long.MAX_VALUE) {
            return this.putFromLoad(key, value, callerAddress);
        }
        long ttl = this.expirationTimeToTtl(expirationTime);
        if (ttl <= 0L) {
            return null;
        }
        return this.putFromLoadInternal(key, value, ttl, -1L, false, callerAddress);
    }

    @Override
    public Object putFromLoadBackup(Data key, Object value) {
        return this.putFromLoadInternal(key, value, -1L, -1L, true, null);
    }

    @Override
    public Object putFromLoadBackup(Data key, Object value, long expirationTime) {
        if (expirationTime == Long.MAX_VALUE) {
            return this.putFromLoadBackup(key, value);
        }
        long ttl = this.expirationTimeToTtl(expirationTime);
        if (ttl <= 0L) {
            return null;
        }
        return this.putFromLoadInternal(key, value, ttl, -1L, true, null);
    }

    private Object putFromLoadInternal(Data key, Object value, long ttl, long maxIdle, boolean backup, Address callerAddress) {
        EntryEventType entryEventType;
        this.checkKeyAndValue(key, value);
        long now = DefaultRecordStore.getNow();
        if (this.shouldEvict()) {
            return null;
        }
        this.markRecordStoreExpirable(ttl, maxIdle);
        Record record = this.getRecordOrNull(key, now, backup);
        Object oldValue = null;
        if (record == null) {
            value = this.mapServiceContext.interceptPut(this.interceptorRegistry, null, value);
            record = this.createRecord(key, value, ttl, maxIdle, now);
            this.storage.put(key, record);
            this.mutationObserver.onLoadRecord(key, record, backup);
            entryEventType = EntryEventType.LOADED;
        } else {
            oldValue = record.getValue();
            value = this.mapServiceContext.interceptPut(this.interceptorRegistry, oldValue, value);
            this.updateRecord(key, record, oldValue, value, now, true, ttl, maxIdle, false, null, backup);
            entryEventType = EntryEventType.UPDATED;
        }
        if (!backup) {
            this.mapEventPublisher.publishEvent(callerAddress, this.name, entryEventType, key, oldValue, value);
        }
        return oldValue;
    }

    private void checkKeyAndValue(Data key, Object value) {
        if (key == null || value == null) {
            String msg = String.format("Neither key nor value can be loaded as null.[mapName: %s, key: %s, value: %s]", this.name, this.serializationService.toObject(key), this.serializationService.toObject(value));
            throw new NullPointerException(msg);
        }
        if (this.partitionService.getPartitionId(key) != this.partitionId) {
            throw new IllegalStateException("MapLoader loaded an item belongs to a different partition");
        }
    }

    @Override
    public boolean setWithUncountedAccess(Data dataKey, Object value, long ttl, long maxIdle) {
        Object oldValue = this.putInternal(dataKey, value, ttl, maxIdle, null, false, false);
        return oldValue == null;
    }

    @Override
    public Object putIfAbsent(Data key, Object value, long ttl, long maxIdle, Address callerAddress) {
        Object oldValue;
        this.checkIfLoaded();
        long now = DefaultRecordStore.getNow();
        this.markRecordStoreExpirable(ttl, maxIdle);
        Record record = this.getRecordOrNull(key, now, false);
        if (record == null) {
            Record loadedRecord = this.loadRecordOrNull(key, false, callerAddress);
            oldValue = loadedRecord != null ? loadedRecord.getValue() : null;
        } else {
            this.accessRecord(record, now);
            oldValue = record.getValue();
        }
        if (oldValue == null) {
            value = this.mapServiceContext.interceptPut(this.interceptorRegistry, null, value);
            this.onStore(record);
            this.putNewRecord(key, null, value, ttl, maxIdle, now, null);
        }
        return oldValue;
    }

    protected Object removeRecord(Data key, @Nonnull Record record, long now, CallerProvenance provenance, UUID transactionId) {
        Object oldValue = record.getValue();
        if ((oldValue = this.mapServiceContext.interceptRemove(this.interceptorRegistry, oldValue)) != null) {
            if (this.persistenceEnabledFor(provenance)) {
                this.mapDataStore.remove(key, now, transactionId);
            }
            this.onStore(record);
        }
        this.mutationObserver.onRemoveRecord(key, record);
        this.storage.removeRecord(key, record);
        return oldValue;
    }

    @Override
    public Record getRecordOrNull(Data key) {
        long now = DefaultRecordStore.getNow();
        return this.getRecordOrNull(key, now, false);
    }

    protected Record getRecordOrNull(Data key, long now, boolean backup) {
        Record record = (Record)this.storage.get(key);
        if (record == null) {
            return null;
        }
        return this.getOrNullIfExpired(key, record, now, backup);
    }

    protected void onStore(Record record) {
        if (record == null || this.mapDataStore == MapDataStores.EMPTY_MAP_DATA_STORE) {
            return;
        }
        record.onStore();
    }

    private void updateStoreStats() {
        if (!(this.mapDataStore instanceof WriteBehindStore) || !this.mapContainer.getMapConfig().isStatisticsEnabled()) {
            return;
        }
        long now = Clock.currentTimeMillis();
        WriteBehindQueue<DelayedEntry> writeBehindQueue = ((WriteBehindStore)this.mapDataStore).getWriteBehindQueue();
        List<DelayedEntry> delayedEntries = writeBehindQueue.asList();
        for (DelayedEntry delayedEntry : delayedEntries) {
            Record record = this.getRecordOrNull(this.toData(delayedEntry.getKey()), now, false);
            this.onStore(record);
        }
    }

    @Override
    public boolean isKeyLoadFinished() {
        return this.keyLoader.isKeyLoadFinished();
    }

    @Override
    public void checkIfLoaded() {
        if (this.loadingFutures.isEmpty()) {
            return;
        }
        if (FutureUtil.allDone(this.loadingFutures)) {
            List<Future> doneFutures = null;
            try {
                doneFutures = FutureUtil.getAllDone(this.loadingFutures);
                FutureUtil.checkAllDone(doneFutures);
            }
            catch (Exception e) {
                this.logger.severe("Exception while loading map " + this.name, e);
                throw ExceptionUtil.rethrow(e);
            }
            finally {
                this.loadingFutures.removeAll(doneFutures);
            }
        } else {
            this.keyLoader.triggerLoadingWithDelay();
            throw new RetryableHazelcastException("Map " + this.getName() + " is still loading data from external store");
        }
    }

    @Override
    public boolean isLoaded() {
        boolean result = FutureUtil.allDone(this.loadingFutures);
        if (result) {
            this.loadingFutures.removeAll(FutureUtil.getAllDone(this.loadingFutures));
        }
        return result;
    }

    public Collection<Future> getLoadingFutures() {
        return this.loadingFutures;
    }

    @Override
    public void startLoading() {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("StartLoading invoked " + this.getStateMessage());
        }
        if (this.mapStoreContext.isMapLoader() && !this.loadedOnCreate) {
            if (!this.loadedOnPreMigration) {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Triggering load " + this.getStateMessage());
                }
                this.loadedOnCreate = true;
                this.loadingFutures.add(this.keyLoader.startInitialLoad(this.mapStoreContext, this.partitionId));
            } else {
                if (this.logger.isFinestEnabled()) {
                    this.logger.finest("Promoting to loaded on migration " + this.getStateMessage());
                }
                this.keyLoader.promoteToLoadedOnMigration();
            }
        }
    }

    @Override
    public void setPreMigrationLoadedStatus(boolean loaded) {
        this.loadedOnPreMigration = loaded;
    }

    @Override
    public void loadAll(boolean replaceExistingValues) {
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("loadAll invoked " + this.getStateMessage());
        }
        this.logger.info("Starting to load all keys for map " + this.name + " on partitionId=" + this.partitionId);
        Future<?> loadingKeysFuture = this.keyLoader.startLoading(this.mapStoreContext, replaceExistingValues);
        this.loadingFutures.add(loadingKeysFuture);
    }

    @Override
    public void loadAllFromStore(List<Data> keys, boolean replaceExistingValues) {
        if (!keys.isEmpty()) {
            Future<?> f = this.recordStoreLoader.loadValues(keys, replaceExistingValues);
            this.loadingFutures.add(f);
        }
    }

    @Override
    public void updateLoadStatus(boolean lastBatch, Throwable exception) {
        this.keyLoader.trackLoading(lastBatch, exception);
        if (lastBatch) {
            this.logger.finest("Completed loading map " + this.name + " on partitionId=" + this.partitionId);
        }
    }

    @Override
    public void maybeDoInitialLoad() {
        if (this.keyLoader.shouldDoInitialLoad()) {
            this.loadAll(false);
        }
    }

    private String getStateMessage() {
        return "on partitionId=" + this.partitionId + " on " + this.mapServiceContext.getNodeEngine().getThisAddress() + " loadedOnCreate=" + this.loadedOnCreate + " loadedOnPreMigration=" + this.loadedOnPreMigration + " isLoaded=" + this.isLoaded();
    }

    @Override
    public int evictAll(boolean backup) {
        this.checkIfLoaded();
        final ArrayList<Data> keys = new ArrayList<Data>();
        final ArrayList<Record> records = new ArrayList<Record>();
        this.forEach(new BiConsumer<Data, Record>(){
            Set<Data> lockedKeySet;
            {
                this.lockedKeySet = DefaultRecordStore.this.lockStore.getLockedKeys();
            }

            @Override
            public void accept(Data dataKey, Record record) {
                if (this.lockedKeySet != null && !this.lockedKeySet.contains(dataKey)) {
                    keys.add(dataKey);
                    records.add(record);
                }
            }
        }, true);
        this.flush(keys, records, backup);
        return this.evictBulk(keys, records);
    }

    @Override
    public int clear() {
        this.checkIfLoaded();
        final ArrayList<Data> keys = new ArrayList<Data>();
        final ArrayList<Record> records = new ArrayList<Record>();
        this.forEach(new BiConsumer<Data, Record>(){
            Set<Data> lockedKeySet;
            {
                this.lockedKeySet = DefaultRecordStore.this.lockStore.getLockedKeys();
            }

            @Override
            public void accept(Data dataKey, Record record) {
                if (this.lockedKeySet != null && !this.lockedKeySet.contains(dataKey)) {
                    keys.add(dataKey);
                    records.add(record);
                }
            }
        }, this.isBackup(this));
        this.mapDataStore.removeAll(keys);
        this.mapDataStore.reset();
        return this.removeBulk(keys, records);
    }

    private boolean isBackup(RecordStore recordStore) {
        int partitionId = recordStore.getPartitionId();
        IPartition partition = this.partitionService.getPartition(partitionId, false);
        return !partition.isLocal();
    }

    @Override
    public void reset() {
        try {
            this.mutationObserver.onReset();
        }
        finally {
            this.mapDataStore.reset();
            this.storage.clear(false);
            this.stats.reset();
        }
    }

    @Override
    public void destroy() {
        this.clearPartition(false, true);
    }

    @Override
    public void clearPartition(boolean onShutdown, boolean onStorageDestroy) {
        this.clearLockStore();
        this.mapDataStore.reset();
        if (onShutdown) {
            if (this.hasPooledMemoryAllocator()) {
                this.destroyStorageImmediate(true, true);
            } else {
                this.destroyStorageAfterClear(true, true);
            }
        } else if (onStorageDestroy) {
            this.destroyStorageAfterClear(false, false);
        } else {
            this.clearStorage(false);
        }
    }

    private boolean hasPooledMemoryAllocator() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        NativeMemoryConfig nativeMemoryConfig = nodeEngine.getConfig().getNativeMemoryConfig();
        return nativeMemoryConfig != null && nativeMemoryConfig.getAllocatorType() == NativeMemoryConfig.MemoryAllocatorType.POOLED;
    }

    private void destroyStorageImmediate(boolean isDuringShutdown, boolean internal) {
        this.mutationObserver.onDestroy(isDuringShutdown, internal);
        this.storage.destroy(isDuringShutdown);
    }

    public void destroyStorageAfterClear(boolean isDuringShutdown, boolean internal) {
        this.clearStorage(isDuringShutdown);
        this.destroyStorageImmediate(isDuringShutdown, internal);
    }

    private void clearStorage(boolean isDuringShutdown) {
        try {
            this.mutationObserver.onClear();
        }
        finally {
            this.storage.clear(isDuringShutdown);
        }
    }

    private void clearLockStore() {
        NodeEngine nodeEngine = this.mapServiceContext.getNodeEngine();
        LockSupportService lockService = (LockSupportService)nodeEngine.getServiceOrNull("hz:impl:lockService");
        if (lockService != null) {
            ObjectNamespace namespace = MapService.getObjectNamespace(this.name);
            lockService.clearLockStore(this.partitionId, namespace);
        }
    }
}

