/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config;

import com.hazelcast.config.InvalidConfigurationException;
import com.hazelcast.config.NamedConfig;
import com.hazelcast.internal.config.ConfigDataSerializerHook;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class PNCounterConfig
implements IdentifiedDataSerializable,
NamedConfig {
    public static final int DEFAULT_REPLICA_COUNT = Integer.MAX_VALUE;
    public static final boolean DEFAULT_STATISTICS_ENABLED = true;
    private String name = "default";
    private int replicaCount = Integer.MAX_VALUE;
    private String splitBrainProtectionName;
    private boolean statisticsEnabled = true;

    public PNCounterConfig() {
    }

    public PNCounterConfig(String name, int replicaCount, String splitBrainProtectionName, boolean statisticsEnabled) {
        this.name = name;
        this.replicaCount = replicaCount;
        this.splitBrainProtectionName = splitBrainProtectionName;
        this.statisticsEnabled = statisticsEnabled;
    }

    public PNCounterConfig(String name) {
        this.name = name;
    }

    public PNCounterConfig(PNCounterConfig config) {
        this(config.getName(), config.getReplicaCount(), config.getSplitBrainProtectionName(), config.isStatisticsEnabled());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public PNCounterConfig setName(String name) {
        Preconditions.checkNotNull(name);
        this.name = name;
        return this;
    }

    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    public PNCounterConfig setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
        return this;
    }

    public int getReplicaCount() {
        return this.replicaCount;
    }

    public PNCounterConfig setReplicaCount(int replicaCount) {
        if (replicaCount < 1) {
            throw new InvalidConfigurationException("Replica count must be greater or equal to 1");
        }
        this.replicaCount = replicaCount;
        return this;
    }

    public String getSplitBrainProtectionName() {
        return this.splitBrainProtectionName;
    }

    public PNCounterConfig setSplitBrainProtectionName(String splitBrainProtectionName) {
        this.splitBrainProtectionName = splitBrainProtectionName;
        return this;
    }

    @Override
    public int getFactoryId() {
        return ConfigDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 49;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.replicaCount);
        out.writeBoolean(this.statisticsEnabled);
        out.writeUTF(this.splitBrainProtectionName);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.name = in.readUTF();
        this.replicaCount = in.readInt();
        this.statisticsEnabled = in.readBoolean();
        this.splitBrainProtectionName = in.readUTF();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PNCounterConfig that = (PNCounterConfig)o;
        if (this.replicaCount != that.replicaCount) {
            return false;
        }
        if (this.statisticsEnabled != that.statisticsEnabled) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        return this.splitBrainProtectionName != null ? this.splitBrainProtectionName.equals(that.splitBrainProtectionName) : that.splitBrainProtectionName == null;
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.replicaCount;
        result = 31 * result + (this.splitBrainProtectionName != null ? this.splitBrainProtectionName.hashCode() : 0);
        result = 31 * result + (this.statisticsEnabled ? 1 : 0);
        return result;
    }
}

