/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.security;

import com.hazelcast.internal.util.StringUtil;

public enum LdapSearchScope {
    OBJECT("object", 0),
    ONE_LEVEL("one-level", 1),
    SUBTREE("subtree", 2);

    private static final LdapSearchScope DEFAULT;
    private final String valueString;
    private final int searchControlValue;

    private LdapSearchScope(String valueString, int searchControlValue) {
        this.valueString = valueString;
        this.searchControlValue = searchControlValue;
    }

    public String toString() {
        return this.valueString;
    }

    public int toSearchControlValue() {
        return this.searchControlValue;
    }

    public static LdapSearchScope getSearchScope(String label) {
        if ((label = StringUtil.trim(label)) == null) {
            return DEFAULT;
        }
        for (LdapSearchScope scope : LdapSearchScope.values()) {
            if (!scope.toString().equals(label)) continue;
            return scope;
        }
        return DEFAULT;
    }

    static {
        DEFAULT = SUBTREE;
    }
}

