/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.builtin;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.ByteArrayCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListLongCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class EntryListLongByteArrayCodec {
    private EntryListLongByteArrayCodec() {
    }

    public static void encode(ClientMessage clientMessage, Collection<Map.Entry<Long, byte[]>> collection) {
        ArrayList<Long> valueList = new ArrayList<Long>(collection.size());
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        for (Map.Entry<Long, byte[]> entry : collection) {
            valueList.add(entry.getKey());
            ByteArrayCodec.encode(clientMessage, entry.getValue());
        }
        clientMessage.add(ClientMessage.END_FRAME.copy());
        ListLongCodec.encode(clientMessage, valueList);
    }

    public static List<Map.Entry<Long, byte[]>> decode(ClientMessage.ForwardFrameIterator iterator) {
        List<byte[]> listV = ListMultiFrameCodec.decode(iterator, ByteArrayCodec::decode);
        List<Long> listK = ListLongCodec.decode(iterator);
        ArrayList<Map.Entry<Long, byte[]>> result = new ArrayList<Map.Entry<Long, byte[]>>(listK.size());
        for (int i = 0; i < listK.size(); ++i) {
            result.add(new AbstractMap.SimpleEntry<Long, byte[]>(listK.get(i), listV.get(i)));
        }
        return result;
    }
}

