/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl.engine;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.camel.CamelContextAware;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.NonManagedService;
import org.apache.camel.impl.engine.BasePackageScanResolver;
import org.apache.camel.spi.PackageScanResourceResolver;
import org.apache.camel.spi.Resource;
import org.apache.camel.spi.ResourceLoader;
import org.apache.camel.support.ResourceHelper;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;

public class DefaultPackageScanResourceResolver
extends BasePackageScanResolver
implements PackageScanResourceResolver,
NonManagedService,
CamelContextAware {
    private static final AntPathMatcher PATH_MATCHER = AntPathMatcher.INSTANCE;

    public Collection<Resource> findResources(String location) throws Exception {
        HashSet<Resource> answer = new HashSet<Resource>();
        this.doFindResources(location, answer);
        return answer;
    }

    protected void doFindResources(String location, Set<Resource> resources) throws Exception {
        if (PATH_MATCHER.isPattern(location)) {
            String root = PATH_MATCHER.determineRootDir(location);
            String subPattern = location.substring(root.length());
            String scheme = ResourceHelper.getScheme((String)location);
            if ("file:".equals(scheme)) {
                root = root.substring(scheme.length());
                this.findInFileSystem(new File(root), resources, subPattern);
            } else {
                if ("classpath:".equals(scheme)) {
                    root = root.substring(scheme.length());
                }
                this.findInClasspath(root, resources, subPattern);
            }
        } else {
            ExtendedCamelContext ecc = (ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class);
            ResourceLoader loader = ecc.getResourceLoader();
            resources.add(loader.resolveResource(location));
        }
    }

    protected void findInFileSystem(File dir, Set<Resource> resources, String subPattern) throws Exception {
        ExtendedCamelContext ecc = (ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class);
        ResourceLoader loader = ecc.getResourceLoader();
        for (Path path : ResourceHelper.findInFileSystem((Path)dir.toPath(), (String)subPattern)) {
            resources.add(loader.resolveResource("file:" + path.toString()));
        }
    }

    protected void findInClasspath(String packageName, Set<Resource> resources, String subPattern) {
        if (!(packageName = packageName.replace('.', '/')).endsWith("/")) {
            packageName = packageName + "/";
        }
        Set<ClassLoader> set = this.getClassLoaders();
        for (ClassLoader classLoader : set) {
            this.doFind(packageName, classLoader, resources, subPattern);
        }
    }

    protected void doFind(String packageName, ClassLoader classLoader, Set<Resource> resources, String subPattern) {
        Enumeration<URL> urls;
        try {
            urls = this.getResources(classLoader, packageName);
            if (!urls.hasMoreElements()) {
                this.log.trace("No URLs returned by classloader");
            }
        }
        catch (IOException ioe) {
            this.log.warn("Cannot read package: {}", (Object)packageName, (Object)ioe);
            return;
        }
        while (urls.hasMoreElements()) {
            URL url = null;
            try {
                InputStream stream;
                url = urls.nextElement();
                this.log.trace("URL from classloader: {}", (Object)url);
                url = this.customResourceLocator(url);
                String urlPath = url.getFile();
                urlPath = URLDecoder.decode(urlPath, "UTF-8");
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Decoded urlPath: {} with protocol: {}", (Object)urlPath, (Object)url.getProtocol());
                }
                if (urlPath.startsWith("file:")) {
                    try {
                        urlPath = new URI(url.getFile()).getPath();
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                    if (urlPath.startsWith("file:")) {
                        urlPath = urlPath.substring(5);
                    }
                }
                if (url.toString().startsWith("bundle:") || urlPath.startsWith("bundle:")) {
                    this.log.trace("Skipping OSGi bundle: {}", (Object)url);
                    continue;
                }
                if (url.toString().startsWith("bundleresource:") || urlPath.startsWith("bundleresource:")) {
                    this.log.trace("Skipping bundleresource: {}", (Object)url);
                    continue;
                }
                if (urlPath.indexOf(33) > 0) {
                    urlPath = urlPath.substring(0, urlPath.indexOf(33));
                }
                this.log.trace("Scanning for resources in: {} matching pattern: {}", (Object)urlPath, (Object)subPattern);
                File file = new File(urlPath);
                if (file.isDirectory()) {
                    this.log.trace("Loading from directory using file: {}", (Object)file);
                    this.loadImplementationsInDirectory(subPattern, packageName, file, resources);
                    continue;
                }
                if (urlPath.startsWith("http:") || urlPath.startsWith("https:") || urlPath.startsWith("sonicfs:") || this.isAcceptableScheme(urlPath)) {
                    this.log.trace("Loading from jar using url: {}", (Object)urlPath);
                    URL urlStream = new URL(urlPath);
                    URLConnection con = urlStream.openConnection();
                    con.setUseCaches(false);
                    stream = con.getInputStream();
                } else {
                    this.log.trace("Loading from jar using file: {}", (Object)file);
                    stream = new FileInputStream(file);
                }
                this.loadImplementationsInJar(packageName, subPattern, stream, urlPath, resources);
            }
            catch (IOException e) {
                this.log.debug("Cannot read entries in url: {}", (Object)url, (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImplementationsInJar(String packageName, String subPattern, InputStream stream, String urlPath, Set<Resource> resources) {
        ArrayList<String> entries = new ArrayList<String>();
        JarInputStream jarStream = null;
        try {
            JarEntry entry;
            jarStream = new JarInputStream(stream);
            while ((entry = jarStream.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (name == null) continue;
                name = name.trim();
                if (entry.isDirectory() || name.endsWith(".class") || !name.startsWith(packageName)) continue;
                entries.add(name);
            }
        }
        catch (IOException ioe) {
            this.log.warn("Cannot search jar file '" + urlPath + " due to an IOException: " + ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            IOHelper.close((Closeable)jarStream, (String)urlPath, (Logger)this.log);
        }
        for (String name : entries) {
            String shortName = name.substring(packageName.length());
            boolean match = PATH_MATCHER.match(subPattern, shortName);
            this.log.debug("Found resource: {} matching pattern: {} -> {}", new Object[]{shortName, subPattern, match});
            if (!match) continue;
            ExtendedCamelContext ecc = (ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class);
            ResourceLoader loader = ecc.getResourceLoader();
            resources.add(loader.resolveResource(name));
        }
    }

    private void loadImplementationsInDirectory(String subPattern, String parent, File location, Set<Resource> resources) throws FileNotFoundException {
        File[] files = location.listFiles();
        if (files == null || files.length == 0) {
            return;
        }
        for (File file : files) {
            String packageOrClass;
            StringBuilder builder = new StringBuilder(100);
            String name = file.getName();
            name = name.trim();
            builder.append(parent).append("/").append(name);
            String string = packageOrClass = parent == null ? name : builder.toString();
            if (file.isDirectory()) {
                this.loadImplementationsInDirectory(subPattern, packageOrClass, file, resources);
                continue;
            }
            if (!file.isFile() || !file.exists() || name.endsWith(".class")) continue;
            boolean match = PATH_MATCHER.match(subPattern, name);
            this.log.debug("Found resource: {} matching pattern: {} -> {}", new Object[]{name, subPattern, match});
            if (!match) continue;
            ExtendedCamelContext ecc = (ExtendedCamelContext)this.getCamelContext().adapt(ExtendedCamelContext.class);
            ResourceLoader loader = ecc.getResourceLoader();
            resources.add(loader.resolveResource("file:" + file.getPath()));
        }
    }

    protected void doInit() throws Exception {
        ObjectHelper.notNull((Object)this.getCamelContext(), (String)"CamelContext", (Object)((Object)this));
    }

    protected void doStop() throws Exception {
    }
}

