/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.dataformat;

import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.ProtobufDataFormat;
import org.apache.camel.model.dataformat.ProtobufLibrary;
import org.apache.camel.reifier.dataformat.DataFormatReifier;

public class ProtobufDataFormatReifier
extends DataFormatReifier<ProtobufDataFormat> {
    public ProtobufDataFormatReifier(CamelContext camelContext, DataFormatDefinition definition) {
        super(camelContext, (ProtobufDataFormat)definition);
    }

    @Override
    protected void prepareDataFormatConfig(Map<String, Object> properties) {
        if (((ProtobufDataFormat)this.definition).getLibrary() == ProtobufLibrary.GoogleProtobuf) {
            if (((ProtobufDataFormat)this.definition).getInstanceClass() == null) {
                if (((ProtobufDataFormat)this.definition).getUnmarshalType() != null) {
                    properties.put("instanceClass", ((ProtobufDataFormat)this.definition).getUnmarshalType().getName());
                } else if (((ProtobufDataFormat)this.definition).getUnmarshalTypeName() != null) {
                    properties.put("instanceClass", ((ProtobufDataFormat)this.definition).getUnmarshalTypeName());
                }
            } else {
                properties.put("instanceClass", ((ProtobufDataFormat)this.definition).getInstanceClass());
            }
            properties.put("contentTypeFormat", ((ProtobufDataFormat)this.definition).getContentTypeFormat());
            properties.put("defaultInstance", ((ProtobufDataFormat)this.definition).getDefaultInstance());
        } else if (((ProtobufDataFormat)this.definition).getLibrary() == ProtobufLibrary.Jackson) {
            properties.put("objectMapper", this.asRef(((ProtobufDataFormat)this.definition).getObjectMapper()));
            if (((ProtobufDataFormat)this.definition).getUseDefaultObjectMapper() == null) {
                properties.put("useDefaultObjectMapper", "true");
            } else {
                properties.put("useDefaultObjectMapper", ((ProtobufDataFormat)this.definition).getUseDefaultObjectMapper());
            }
            properties.put("autoDiscoverObjectMapper", ((ProtobufDataFormat)this.definition).getAutoDiscoverObjectMapper());
            if (((ProtobufDataFormat)this.definition).getJsonView() != null) {
                properties.put("jsonViewTypeName", this.asTypeName(((ProtobufDataFormat)this.definition).getJsonView()));
            } else {
                properties.put("jsonViewTypeName", ((ProtobufDataFormat)this.definition).getJsonViewTypeName());
            }
            if (((ProtobufDataFormat)this.definition).getUnmarshalType() != null) {
                properties.put("unmarshalTypeName", this.asTypeName(((ProtobufDataFormat)this.definition).getUnmarshalType()));
            } else if (((ProtobufDataFormat)this.definition).getUnmarshalTypeName() != null) {
                properties.put("unmarshalTypeName", ((ProtobufDataFormat)this.definition).getUnmarshalTypeName());
            } else {
                properties.put("unmarshalTypeName", ((ProtobufDataFormat)this.definition).getInstanceClass());
            }
            properties.put("jsonView", ((ProtobufDataFormat)this.definition).getJsonView());
            properties.put("include", ((ProtobufDataFormat)this.definition).getInclude());
            properties.put("allowJmsType", ((ProtobufDataFormat)this.definition).getAllowJmsType());
            if (((ProtobufDataFormat)this.definition).getCollectionType() != null) {
                properties.put("collectionTypeName", this.asTypeName(((ProtobufDataFormat)this.definition).getCollectionType()));
            } else {
                properties.put("collectionTypeName", ((ProtobufDataFormat)this.definition).getCollectionTypeName());
            }
            properties.put("useList", ((ProtobufDataFormat)this.definition).getUseList());
            properties.put("moduleClassNames", ((ProtobufDataFormat)this.definition).getModuleClassNames());
            properties.put("moduleRefs", ((ProtobufDataFormat)this.definition).getModuleRefs());
            properties.put("enableFeatures", ((ProtobufDataFormat)this.definition).getEnableFeatures());
            properties.put("disableFeatures", ((ProtobufDataFormat)this.definition).getDisableFeatures());
            properties.put("allowUnmarshallType", ((ProtobufDataFormat)this.definition).getAllowUnmarshallType());
            properties.put("schemaResolver", this.asRef(((ProtobufDataFormat)this.definition).getSchemaResolver()));
            properties.put("autoDiscoverSchemaResolver", ((ProtobufDataFormat)this.definition).getAutoDiscoverSchemaResolver());
        }
    }
}

