/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema;

import com.hazelcast.sql.impl.plan.cache.PlanObjectKey;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public abstract class Table {
    private final String schemaName;
    private final String sqlName;
    private final List<TableField> fields;
    private final TableStatistics statistics;
    private Set<String> conflictingSchemas;

    protected Table(String schemaName, String sqlName, List<TableField> fields, TableStatistics statistics) {
        this.schemaName = schemaName;
        this.sqlName = sqlName;
        this.fields = Collections.unmodifiableList(fields);
        this.statistics = statistics;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getSqlName() {
        return this.sqlName;
    }

    public List<TableField> getFields() {
        return this.fields;
    }

    public int getFieldCount() {
        return this.fields.size();
    }

    public <T extends TableField> T getField(int index) {
        return (T)this.fields.get(index);
    }

    public TableStatistics getStatistics() {
        return this.statistics;
    }

    public abstract PlanObjectKey getObjectKey();

    public Set<String> getConflictingSchemas() {
        return this.conflictingSchemas != null ? this.conflictingSchemas : Collections.emptySet();
    }

    public void setConflictingSchemas(Set<String> conflictingSchemas) {
        this.conflictingSchemas = conflictingSchemas;
    }
}

